/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.gcloud.datastore.Cursor;
import com.google.gcloud.datastore.DatastoreImpl;
import com.google.gcloud.datastore.DatastoreOptions;
import com.google.gcloud.datastore.Query;
import com.google.gcloud.datastore.QueryResults;
import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.Objects;

class QueryResultsImpl<T>
extends AbstractIterator<T>
implements QueryResults<T> {
    private final DatastoreImpl datastore;
    private final DatastoreV1.ReadOptions readOptionsPb;
    private final DatastoreV1.PartitionId partitionIdPb;
    private final Query.ResultType<T> queryResultType;
    private Query<T> query;
    private Query.ResultType<?> actualResultType;
    private DatastoreV1.QueryResultBatch queryResultBatchPb;
    private boolean lastBatch;
    private Iterator<DatastoreV1.EntityResult> entityResultPbIter;
    private ByteString cursor;

    QueryResultsImpl(DatastoreImpl datastore, DatastoreV1.ReadOptions readOptionsPb, Query<T> query) {
        this.datastore = datastore;
        this.readOptionsPb = readOptionsPb;
        this.query = query;
        this.queryResultType = query.type();
        DatastoreV1.PartitionId.Builder pbBuilder = DatastoreV1.PartitionId.newBuilder();
        pbBuilder.setDatasetId(((DatastoreOptions)datastore.options()).projectId());
        if (query.namespace() != null) {
            pbBuilder.setNamespace(query.namespace());
        } else if (((DatastoreOptions)datastore.options()).namespace() != null) {
            pbBuilder.setNamespace(((DatastoreOptions)datastore.options()).namespace());
        }
        this.partitionIdPb = pbBuilder.build();
        this.sendRequest();
    }

    private void sendRequest() {
        DatastoreV1.RunQueryRequest.Builder requestPb = DatastoreV1.RunQueryRequest.newBuilder();
        if (this.readOptionsPb != null) {
            requestPb.setReadOptions(this.readOptionsPb);
        }
        requestPb.setPartitionId(this.partitionIdPb);
        this.query.populatePb(requestPb);
        this.queryResultBatchPb = this.datastore.runQuery(requestPb.build()).getBatch();
        this.lastBatch = this.queryResultBatchPb.getMoreResults() != DatastoreV1.QueryResultBatch.MoreResultsType.NOT_FINISHED;
        this.entityResultPbIter = this.queryResultBatchPb.getEntityResultList().iterator();
        this.actualResultType = Query.ResultType.fromPb(this.queryResultBatchPb.getEntityResultType());
        if (Objects.equals(this.queryResultType, Query.ResultType.PROJECTION_ENTITY)) {
            this.actualResultType = Query.ResultType.PROJECTION_ENTITY;
        }
        Preconditions.checkState((boolean)this.queryResultType.isAssignableFrom(this.actualResultType), (Object)("Unexpected result type " + this.actualResultType + " vs " + this.queryResultType));
    }

    protected T computeNext() {
        while (!this.entityResultPbIter.hasNext() && !this.lastBatch) {
            this.query = this.query.nextQuery(this.queryResultBatchPb);
            this.sendRequest();
        }
        if (!this.entityResultPbIter.hasNext()) {
            this.cursor = this.queryResultBatchPb.getEndCursor();
            return (T)this.endOfData();
        }
        DatastoreV1.EntityResult entityResultPb = this.entityResultPbIter.next();
        Object result = this.actualResultType.convert(entityResultPb.getEntity());
        return (T)result;
    }

    @Override
    public Class<?> resultClass() {
        return this.actualResultType.resultClass();
    }

    @Override
    public Cursor cursorAfter() {
        return this.cursor == null ? null : new Cursor(this.cursor);
    }
}

