/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.gcloud.datastore.BaseDatastoreBatchWriter;
import com.google.gcloud.datastore.Datastore;
import com.google.gcloud.datastore.DatastoreHelper;
import com.google.gcloud.datastore.DatastoreImpl;
import com.google.gcloud.datastore.Entity;
import com.google.gcloud.datastore.Key;
import com.google.gcloud.datastore.Query;
import com.google.gcloud.datastore.QueryResults;
import com.google.gcloud.datastore.Transaction;
import com.google.gcloud.datastore.TransactionOption;
import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class TransactionImpl
extends BaseDatastoreBatchWriter
implements Transaction {
    private final DatastoreImpl datastore;
    private final ByteString transaction;
    private final boolean force;
    private boolean rolledback;

    TransactionImpl(DatastoreImpl datastore, TransactionOption ... options) {
        super("transaction");
        TransactionOption.ForceWrites forceWrites;
        this.datastore = datastore;
        DatastoreV1.BeginTransactionRequest.Builder requestPb = DatastoreV1.BeginTransactionRequest.newBuilder();
        Map<Class<? extends TransactionOption>, TransactionOption> optionsMap = TransactionOption.asImmutableMap(options);
        TransactionOption.IsolationLevel isolationLevel = (TransactionOption.IsolationLevel)optionsMap.get(TransactionOption.IsolationLevel.class);
        if (isolationLevel != null) {
            requestPb.setIsolationLevel(isolationLevel.level().toPb());
        }
        this.force = (forceWrites = (TransactionOption.ForceWrites)optionsMap.get(TransactionOption.ForceWrites.class)) != null && forceWrites.force();
        this.transaction = datastore.requestTransactionId(requestPb);
    }

    @Override
    public Entity get(Key key) {
        return DatastoreHelper.get(this, key);
    }

    @Override
    public Iterator<Entity> get(Key ... keys) {
        this.validateActive();
        DatastoreV1.ReadOptions.Builder readOptionsPb = DatastoreV1.ReadOptions.newBuilder();
        readOptionsPb.setTransaction(this.transaction);
        return this.datastore.get(readOptionsPb.build(), keys);
    }

    @Override
    public List<Entity> fetch(Key ... keys) {
        this.validateActive();
        return DatastoreHelper.fetch(this, keys);
    }

    @Override
    public <T> QueryResults<T> run(Query<T> query) {
        this.validateActive();
        DatastoreV1.ReadOptions.Builder readOptionsPb = DatastoreV1.ReadOptions.newBuilder();
        readOptionsPb.setTransaction(this.transaction);
        return this.datastore.run(readOptionsPb.build(), query);
    }

    @Override
    public Transaction.Response commit() {
        this.validateActive();
        DatastoreV1.Mutation.Builder mutationPb = this.toMutationPb();
        if (this.force) {
            mutationPb.setForce(this.force);
        }
        DatastoreV1.CommitRequest.Builder requestPb = DatastoreV1.CommitRequest.newBuilder();
        requestPb.setMode(DatastoreV1.CommitRequest.Mode.TRANSACTIONAL);
        requestPb.setTransaction(this.transaction);
        requestPb.setMutation(mutationPb);
        DatastoreV1.CommitResponse responsePb = this.datastore.commit(requestPb.build());
        this.deactivate();
        return new ResponseImpl(responsePb);
    }

    @Override
    public void rollback() {
        if (this.rolledback) {
            return;
        }
        this.validateActive();
        this.datastore.rollbackTransaction(this.transaction);
        this.deactivate();
        this.rolledback = true;
    }

    @Override
    public Datastore datastore() {
        return this.datastore;
    }

    static class ResponseImpl
    implements Transaction.Response {
        private final DatastoreV1.CommitResponse response;

        ResponseImpl(DatastoreV1.CommitResponse response) {
            this.response = response;
        }

        @Override
        public List<Key> generatedKeys() {
            return Lists.transform((List)this.response.getMutationResult().getInsertAutoIdKeyList(), (Function)new Function<DatastoreV1.Key, Key>(){

                public Key apply(DatastoreV1.Key keyPb) {
                    return Key.fromPb(keyPb);
                }
            });
        }
    }
}

