/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.collect.ImmutableMap;
import com.google.gcloud.datastore.BatchOption;
import java.io.Serializable;
import java.util.Map;

public abstract class TransactionOption
implements Serializable {
    private static final long serialVersionUID = -1862234444015690375L;

    TransactionOption() {
    }

    public static ForceWrites forceWrites() {
        return new ForceWrites(true);
    }

    public static IsolationLevel serializable() {
        return new IsolationLevel(IsolationLevel.Level.SERIALIZABLE);
    }

    public static IsolationLevel snapshot() {
        return new IsolationLevel(IsolationLevel.Level.SNAPSHOT);
    }

    static Map<Class<? extends TransactionOption>, TransactionOption> asImmutableMap(TransactionOption ... options) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TransactionOption option : options) {
            builder.put(option.getClass(), (Object)option);
        }
        return builder.build();
    }

    abstract BatchOption toBatchWriteOption();

    public static final class IsolationLevel
    extends TransactionOption {
        private static final long serialVersionUID = -5592165378565409515L;
        private final Level level;

        public IsolationLevel(Level level) {
            this.level = level;
        }

        public Level level() {
            return this.level;
        }

        @Override
        BatchOption toBatchWriteOption() {
            return null;
        }

        public static enum Level {
            SERIALIZABLE(DatastoreV1.BeginTransactionRequest.IsolationLevel.SERIALIZABLE),
            SNAPSHOT(DatastoreV1.BeginTransactionRequest.IsolationLevel.SNAPSHOT);

            private final DatastoreV1.BeginTransactionRequest.IsolationLevel levelPb;

            private Level(DatastoreV1.BeginTransactionRequest.IsolationLevel levelPb) {
                this.levelPb = levelPb;
            }

            DatastoreV1.BeginTransactionRequest.IsolationLevel toPb() {
                return this.levelPb;
            }
        }
    }

    public static final class ForceWrites
    extends TransactionOption {
        private static final long serialVersionUID = -6873967516988380886L;
        private final boolean force;

        public ForceWrites(boolean force) {
            this.force = force;
        }

        public boolean force() {
            return this.force;
        }

        @Override
        BatchOption toBatchWriteOption() {
            return new BatchOption.ForceWrites(this.force);
        }
    }
}

