/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.common.collect.ImmutableMap;
import com.google.gcloud.datastore.BlobValue;
import com.google.gcloud.datastore.BooleanValue;
import com.google.gcloud.datastore.DateTimeValue;
import com.google.gcloud.datastore.DoubleValue;
import com.google.gcloud.datastore.EntityValue;
import com.google.gcloud.datastore.KeyValue;
import com.google.gcloud.datastore.ListValue;
import com.google.gcloud.datastore.LongValue;
import com.google.gcloud.datastore.NullValue;
import com.google.gcloud.datastore.RawValue;
import com.google.gcloud.datastore.StringValue;
import com.google.gcloud.datastore.Value;
import com.google.gcloud.datastore.ValueBuilder;
import com.google.gcloud.datastore.ValueMarshaller;

public enum ValueType {
    NULL(NullValue.MARSHALLER),
    STRING(StringValue.MARSHALLER),
    ENTITY(EntityValue.MARSHALLER),
    LIST(ListValue.MARSHALLER),
    KEY(KeyValue.MARSHALLER),
    LONG(LongValue.MARSHALLER),
    DOUBLE(DoubleValue.MARSHALLER),
    BOOLEAN(BooleanValue.MARSHALLER),
    DATE_TIME(DateTimeValue.MARSHALLER),
    BLOB(BlobValue.MARSHALLER),
    RAW_VALUE(RawValue.MARSHALLER);

    private static final ImmutableMap<Integer, ValueType> DESCRIPTOR_TO_TYPE_MAP;
    private final ValueMarshaller marshaller;

    private <V, P extends Value<V>, B extends ValueBuilder<V, P, B>> ValueType(ValueMarshaller<V, P, B> marshaller) {
        this.marshaller = marshaller;
    }

    ValueMarshaller getMarshaller() {
        return this.marshaller;
    }

    static ValueType getByDescriptorId(int descriptorId) {
        return (ValueType)((Object)DESCRIPTOR_TO_TYPE_MAP.get((Object)descriptorId));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ValueType valueType : ValueType.values()) {
            int fieldId = valueType.getMarshaller().getProtoFieldId();
            if (fieldId <= 0) continue;
            builder.put((Object)fieldId, (Object)valueType);
        }
        DESCRIPTOR_TO_TYPE_MAP = builder.build();
    }
}

