/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.spi;

import com.google.api.services.datastore.DatastoreV1;
import com.google.api.services.datastore.client.Datastore;
import com.google.api.services.datastore.client.DatastoreFactory;
import com.google.api.services.datastore.client.DatastoreOptions;
import com.google.common.base.Preconditions;
import com.google.gcloud.datastore.DatastoreException;
import com.google.gcloud.datastore.DatastoreOptions;
import com.google.gcloud.spi.DatastoreRpc;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class DefaultDatastoreRpc
implements DatastoreRpc {
    private final Datastore client;

    public DefaultDatastoreRpc(DatastoreOptions options) {
        String normalizedHost = DefaultDatastoreRpc.normalizeHost(options.host());
        this.client = DatastoreFactory.get().create(new DatastoreOptions.Builder().dataset(options.projectId()).host(normalizedHost).initializer(options.httpRequestInitializer()).build());
    }

    private static String normalizeHost(String host) {
        if (DefaultDatastoreRpc.includesScheme(host = host.toLowerCase())) {
            Preconditions.checkArgument((!host.startsWith("https://") || !DefaultDatastoreRpc.isLocalHost(host) ? 1 : 0) != 0, (Object)"\"https\" is not supported for localhost.  Use \"http\" instead.");
            return host;
        }
        return "http://" + host;
    }

    private static boolean isLocalHost(String host) {
        if (host != null) {
            try {
                InetAddress hostAddr;
                String normalizedHost = host;
                if (!DefaultDatastoreRpc.includesScheme(normalizedHost)) {
                    normalizedHost = "http://" + normalizedHost;
                }
                return (hostAddr = InetAddress.getByName(new URL(normalizedHost).getHost())).isAnyLocalAddress() || hostAddr.isLoopbackAddress();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean includesScheme(String url) {
        return url.startsWith("http://") || url.startsWith("https://");
    }

    private static DatastoreException translate(com.google.api.services.datastore.client.DatastoreException exception) {
        String message = exception.getMessage();
        int code = exception.getCode();
        String reason = "";
        if (message != null) {
            try {
                JSONObject json = new JSONObject(new JSONTokener(message));
                JSONObject error = json.getJSONObject("error").getJSONArray("errors").getJSONObject(0);
                reason = error.getString("reason");
                message = error.getString("message");
            }
            catch (JSONException ignore) {
                // empty catch block
            }
        }
        if (reason == null && exception.getCause() instanceof IOException) {
            return new DatastoreException((IOException)exception.getCause());
        }
        return new DatastoreException(code, message, reason, exception);
    }

    @Override
    public DatastoreV1.AllocateIdsResponse allocateIds(DatastoreV1.AllocateIdsRequest request) throws DatastoreException {
        try {
            return this.client.allocateIds(request);
        }
        catch (com.google.api.services.datastore.client.DatastoreException ex) {
            throw DefaultDatastoreRpc.translate(ex);
        }
    }

    @Override
    public DatastoreV1.BeginTransactionResponse beginTransaction(DatastoreV1.BeginTransactionRequest request) throws DatastoreException {
        try {
            return this.client.beginTransaction(request);
        }
        catch (com.google.api.services.datastore.client.DatastoreException ex) {
            throw DefaultDatastoreRpc.translate(ex);
        }
    }

    @Override
    public DatastoreV1.CommitResponse commit(DatastoreV1.CommitRequest request) throws DatastoreException {
        try {
            return this.client.commit(request);
        }
        catch (com.google.api.services.datastore.client.DatastoreException ex) {
            throw DefaultDatastoreRpc.translate(ex);
        }
    }

    @Override
    public DatastoreV1.LookupResponse lookup(DatastoreV1.LookupRequest request) throws DatastoreException {
        try {
            return this.client.lookup(request);
        }
        catch (com.google.api.services.datastore.client.DatastoreException ex) {
            throw DefaultDatastoreRpc.translate(ex);
        }
    }

    @Override
    public DatastoreV1.RollbackResponse rollback(DatastoreV1.RollbackRequest request) throws DatastoreException {
        try {
            return this.client.rollback(request);
        }
        catch (com.google.api.services.datastore.client.DatastoreException ex) {
            throw DefaultDatastoreRpc.translate(ex);
        }
    }

    @Override
    public DatastoreV1.RunQueryResponse runQuery(DatastoreV1.RunQueryRequest request) throws DatastoreException {
        try {
            return this.client.runQuery(request);
        }
        catch (com.google.api.services.datastore.client.DatastoreException ex) {
            throw DefaultDatastoreRpc.translate(ex);
        }
    }
}

