/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.gcloud.datastore.BaseDatastoreBatchWriter;
import com.google.gcloud.datastore.Batch;
import com.google.gcloud.datastore.BatchOption;
import com.google.gcloud.datastore.Datastore;
import com.google.gcloud.datastore.DatastoreImpl;
import com.google.gcloud.datastore.DatastoreOptions;
import com.google.gcloud.datastore.Key;
import java.util.List;
import java.util.Map;

class BatchImpl
extends BaseDatastoreBatchWriter
implements Batch {
    private final DatastoreImpl datastore;
    private final boolean force;

    BatchImpl(DatastoreImpl datastore, BatchOption ... options) {
        super("batch");
        this.datastore = datastore;
        Map<Class<? extends BatchOption>, BatchOption> optionsMap = BatchOption.asImmutableMap(options);
        this.force = optionsMap.containsKey(BatchOption.ForceWrites.class) ? ((BatchOption.ForceWrites)optionsMap.get(BatchOption.ForceWrites.class)).force() : ((DatastoreOptions)datastore.options()).force();
    }

    @Override
    public Batch.Response submit() {
        this.validateActive();
        DatastoreV1.Mutation.Builder mutationPb = this.toMutationPb();
        if (this.force) {
            mutationPb.setForce(this.force);
        }
        DatastoreV1.CommitRequest.Builder requestPb = DatastoreV1.CommitRequest.newBuilder();
        requestPb.setMode(DatastoreV1.CommitRequest.Mode.NON_TRANSACTIONAL);
        requestPb.setMutation(mutationPb);
        DatastoreV1.CommitResponse responsePb = this.datastore.commit(requestPb.build());
        this.deactivate();
        return new ResponseImpl(responsePb);
    }

    @Override
    public Datastore datastore() {
        return this.datastore;
    }

    static class ResponseImpl
    implements Batch.Response {
        private final DatastoreV1.CommitResponse response;

        ResponseImpl(DatastoreV1.CommitResponse response) {
            this.response = response;
        }

        @Override
        public List<Key> generatedKeys() {
            return Lists.transform((List)this.response.getMutationResult().getInsertAutoIdKeyList(), (Function)new Function<DatastoreV1.Key, Key>(){

                public Key apply(DatastoreV1.Key keyPb) {
                    return Key.fromPb(keyPb);
                }
            });
        }
    }
}

