/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gcloud.ServiceOptions;
import com.google.gcloud.datastore.Datastore;
import com.google.gcloud.datastore.DatastoreFactory;
import com.google.gcloud.datastore.DatastoreImpl;
import com.google.gcloud.datastore.Validator;
import com.google.gcloud.spi.DatastoreRpc;
import com.google.gcloud.spi.DatastoreRpcFactory;
import com.google.gcloud.spi.DefaultDatastoreRpc;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class DatastoreOptions
extends ServiceOptions<Datastore, DatastoreRpc, DatastoreOptions> {
    private static final long serialVersionUID = 5056049000758143852L;
    private static final String DATASET_ENV_NAME = "DATASTORE_DATASET";
    private static final String HOST_ENV_NAME = "DATASTORE_HOST";
    private static final String DATASTORE_SCOPE = "https://www.googleapis.com/auth/datastore";
    private static final String USERINFO_SCOPE = "https://www.googleapis.com/auth/userinfo.email";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/datastore", (Object)"https://www.googleapis.com/auth/userinfo.email");
    private final String namespace;
    private final boolean force;
    private final boolean normalizeDataset;

    private DatastoreOptions(Builder builder) {
        super(DatastoreFactory.class, DatastoreRpcFactory.class, (ServiceOptions.Builder)builder);
        this.normalizeDataset = builder.normalizeDataset;
        this.namespace = builder.namespace != null ? builder.namespace : DatastoreOptions.defaultNamespace();
        this.force = builder.force;
    }

    private DatastoreOptions normalize() {
        if (!this.normalizeDataset) {
            return this;
        }
        Builder builder = this.toBuilder();
        builder.normalizeDataset(false);
        DatastoreV1.LookupRequest.Builder requestPb = DatastoreV1.LookupRequest.newBuilder();
        DatastoreV1.Key key = DatastoreV1.Key.newBuilder().addPathElement(DatastoreV1.Key.PathElement.newBuilder().setKind("__foo__").setName("bar")).build();
        requestPb.addKey(key);
        DatastoreV1.LookupResponse responsePb = ((DatastoreRpc)this.rpc()).lookup(requestPb.build());
        if (responsePb.getDeferredCount() > 0) {
            key = responsePb.getDeferred(0);
        } else {
            Iterator combinedIter = Iterables.concat((Iterable)responsePb.getMissingList(), (Iterable)responsePb.getFoundList()).iterator();
            key = ((DatastoreV1.EntityResult)combinedIter.next()).getEntity().getKey();
        }
        builder.projectId(key.getPartitionId().getDatasetId());
        return new DatastoreOptions(builder);
    }

    protected String defaultHost() {
        String host = System.getProperty(HOST_ENV_NAME, System.getenv(HOST_ENV_NAME));
        return host != null ? host : super.defaultHost();
    }

    protected String defaultProject() {
        String projectId = System.getProperty(DATASET_ENV_NAME, System.getenv(DATASET_ENV_NAME));
        if (projectId == null) {
            projectId = DatastoreOptions.appEngineAppId();
        }
        return projectId != null ? projectId : super.defaultProject();
    }

    protected DatastoreFactory defaultServiceFactory() {
        return DefaultDatastoreFactory.INSTANCE;
    }

    protected DatastoreRpcFactory defaultRpcFactory() {
        return DefaultDatastoreRpcFactory.INSTANCE;
    }

    public String namespace() {
        return this.namespace;
    }

    public static DatastoreOptions defaultInstance() {
        return DatastoreOptions.builder().build();
    }

    private static String defaultNamespace() {
        try {
            Class<?> clazz = Class.forName("com.google.appengine.api.NamespaceManager");
            Method method = clazz.getMethod("get", new Class[0]);
            String namespace = (String)method.invoke(null, new Object[0]);
            return namespace == null || namespace.isEmpty() ? null : namespace;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public boolean force() {
        return this.force;
    }

    protected Set<String> scopes() {
        return SCOPES;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return this.baseHashCode() ^ Objects.hash(this.namespace, this.force, this.normalizeDataset);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DatastoreOptions)) {
            return false;
        }
        DatastoreOptions other = (DatastoreOptions)((Object)obj);
        return this.baseEquals(other) && Objects.equals(this.namespace, other.namespace) && Objects.equals(this.force, other.force) && Objects.equals(this.normalizeDataset, other.normalizeDataset);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceOptions.Builder<Datastore, DatastoreRpc, DatastoreOptions, Builder> {
        private String namespace;
        private boolean force;
        private boolean normalizeDataset = true;

        private Builder() {
        }

        private Builder(DatastoreOptions options) {
            super((ServiceOptions)options);
            this.force = options.force;
            this.namespace = options.namespace;
            this.normalizeDataset = options.normalizeDataset;
        }

        public DatastoreOptions build() {
            DatastoreOptions options = new DatastoreOptions(this);
            return this.normalizeDataset ? options.normalize() : options;
        }

        public Builder namespace(String namespace) {
            this.namespace = Validator.validateNamespace(namespace);
            return this;
        }

        public Builder force(boolean force) {
            this.force = force;
            return this;
        }

        Builder normalizeDataset(boolean normalizeDataset) {
            this.normalizeDataset = normalizeDataset;
            return this;
        }
    }

    public static class DefaultDatastoreRpcFactory
    implements DatastoreRpcFactory {
        private static final DatastoreRpcFactory INSTANCE = new DefaultDatastoreRpcFactory();

        public DatastoreRpc create(DatastoreOptions options) {
            return new DefaultDatastoreRpc(options);
        }
    }

    public static class DefaultDatastoreFactory
    implements DatastoreFactory {
        private static final DatastoreFactory INSTANCE = new DefaultDatastoreFactory();

        public Datastore create(DatastoreOptions options) {
            return new DatastoreImpl(options);
        }
    }
}

