/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.gcloud.datastore.Value;
import com.google.gcloud.datastore.ValueType;

public final class DoubleValue
extends Value<Double> {
    private static final long serialVersionUID = -5096238337676649540L;
    static final Value.BaseMarshaller<Double, DoubleValue, Builder> MARSHALLER = new Value.BaseMarshaller<Double, DoubleValue, Builder>(){
        private static final long serialVersionUID = 3935522813529400538L;

        @Override
        public int getProtoFieldId() {
            return 3;
        }

        @Override
        public Builder newBuilder(Double value) {
            return DoubleValue.builder(value);
        }

        @Override
        protected Double getValue(DatastoreV1.Value from) {
            return from.getDoubleValue();
        }

        @Override
        protected void setValue(DoubleValue from, DatastoreV1.Value.Builder to) {
            to.setDoubleValue(((Double)from.get()).doubleValue());
        }
    };

    public DoubleValue(double value) {
        this(DoubleValue.builder(value));
    }

    private DoubleValue(Builder builder) {
        super(builder);
    }

    public Builder toBuilder() {
        return (Builder)new Builder().mergeFrom(this);
    }

    public static DoubleValue of(double value) {
        return new DoubleValue(value);
    }

    public static Builder builder(double value) {
        return (Builder)new Builder().set((Object)value);
    }

    public static final class Builder
    extends Value.BaseBuilder<Double, DoubleValue, Builder> {
        public Builder() {
            super(ValueType.DOUBLE);
        }

        @Override
        public DoubleValue build() {
            return new DoubleValue(this);
        }
    }
}

