/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.gcloud.datastore.Blob;
import com.google.gcloud.datastore.BlobValue;
import com.google.gcloud.datastore.BooleanValue;
import com.google.gcloud.datastore.Cursor;
import com.google.gcloud.datastore.DateTime;
import com.google.gcloud.datastore.DateTimeValue;
import com.google.gcloud.datastore.DoubleValue;
import com.google.gcloud.datastore.EntityValue;
import com.google.gcloud.datastore.FullEntity;
import com.google.gcloud.datastore.Key;
import com.google.gcloud.datastore.KeyValue;
import com.google.gcloud.datastore.ListValue;
import com.google.gcloud.datastore.LongValue;
import com.google.gcloud.datastore.NullValue;
import com.google.gcloud.datastore.Query;
import com.google.gcloud.datastore.Serializable;
import com.google.gcloud.datastore.StringValue;
import com.google.gcloud.datastore.Validator;
import com.google.gcloud.datastore.Value;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public final class GqlQuery<V>
extends Query<V> {
    private static final long serialVersionUID = 5988280590929540569L;
    private final transient String queryString;
    private final transient boolean allowLiteral;
    private final transient ImmutableList<Binding> namedBindings;
    private final transient ImmutableList<Binding> positionalBindings;

    private GqlQuery(Builder<V> builder) {
        super(((Builder)builder).resultType, ((Builder)builder).namespace);
        this.queryString = ((Builder)builder).queryString;
        this.allowLiteral = ((Builder)builder).allowLiteral;
        this.namedBindings = ImmutableList.copyOf(((Builder)builder).namedBindings.values());
        this.positionalBindings = ImmutableList.copyOf((Collection)((Builder)builder).positionalBindings);
    }

    public String queryString() {
        return this.queryString;
    }

    public boolean allowLiteral() {
        return this.allowLiteral;
    }

    public Map<String, Object> namedBindings() {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Binding binding : this.namedBindings) {
            builder.put((Object)binding.name(), binding.cursorOrValue());
        }
        return builder.build();
    }

    public List<Object> numberArgs() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Binding binding : this.positionalBindings) {
            builder.add(binding.cursorOrValue());
        }
        return builder.build();
    }

    public int hashCode() {
        return Objects.hash(this.namespace(), this.queryString, this.allowLiteral, this.namedBindings, this.positionalBindings);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GqlQuery)) {
            return false;
        }
        GqlQuery other = (GqlQuery)obj;
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.queryString, other.queryString) && this.allowLiteral == other.allowLiteral && Objects.equals(this.namedBindings, other.namedBindings) && Objects.equals(this.positionalBindings, other.positionalBindings);
    }

    @Override
    DatastoreV1.GqlQuery toPb() {
        DatastoreV1.GqlQuery.Builder queryPb = DatastoreV1.GqlQuery.newBuilder();
        queryPb.setQueryString(this.queryString);
        queryPb.setAllowLiteral(this.allowLiteral);
        for (Binding argument : this.namedBindings) {
            queryPb.addNameArg(argument.toPb());
        }
        for (Binding argument : this.positionalBindings) {
            queryPb.addNumberArg(argument.toPb());
        }
        return queryPb.build();
    }

    @Override
    void populatePb(DatastoreV1.RunQueryRequest.Builder requestPb) {
        requestPb.setGqlQuery(this.toPb());
    }

    @Override
    GqlQuery<V> nextQuery(DatastoreV1.QueryResultBatch responsePb) {
        throw new UnsupportedOperationException("paging for this query is not implemented yet");
    }

    @Override
    Object fromPb(Query.ResultType<V> resultType, String namespace, byte[] bytesPb) throws InvalidProtocolBufferException {
        return GqlQuery.fromPb(resultType, namespace, DatastoreV1.GqlQuery.parseFrom((byte[])bytesPb));
    }

    private static <V> GqlQuery<V> fromPb(Query.ResultType<V> resultType, String ns, DatastoreV1.GqlQuery queryPb) {
        Binding argument;
        Builder<V> builder = new Builder<V>(resultType, queryPb.getQueryString());
        builder.namespace(ns);
        if (queryPb.hasAllowLiteral()) {
            ((Builder)builder).allowLiteral = queryPb.getAllowLiteral();
        }
        for (DatastoreV1.GqlQueryArg nameArg : queryPb.getNameArgList()) {
            argument = Binding.fromPb(nameArg);
            ((Builder)builder).namedBindings.put(argument.name(), argument);
        }
        for (DatastoreV1.GqlQueryArg numberArg : queryPb.getNumberArgList()) {
            argument = Binding.fromPb(numberArg);
            ((Builder)builder).positionalBindings.add(argument);
        }
        return builder.build();
    }

    public static final class Builder<V> {
        private final Query.ResultType<V> resultType;
        private String namespace;
        private String queryString;
        private boolean allowLiteral;
        private final Map<String, Binding> namedBindings = new TreeMap<String, Binding>();
        private final List<Binding> positionalBindings = new LinkedList<Binding>();

        Builder(Query.ResultType<V> resultType, String query) {
            this.resultType = (Query.ResultType)Preconditions.checkNotNull(resultType);
            this.queryString = (String)Preconditions.checkNotNull((Object)query);
        }

        public Builder<V> query(String query) {
            this.queryString = (String)Preconditions.checkNotNull((Object)query);
            return this;
        }

        public Builder<V> namespace(String namespace) {
            this.namespace = Validator.validateNamespace(namespace);
            return this;
        }

        public Builder<V> allowLiteral(boolean allowLiteral) {
            this.allowLiteral = allowLiteral;
            return this;
        }

        public Builder<V> clearBindings() {
            this.namedBindings.clear();
            this.positionalBindings.clear();
            return this;
        }

        public Builder<V> setBinding(String name, Cursor cursor) {
            this.namedBindings.put(name, new Binding(name, cursor));
            return this;
        }

        public Builder<V> setBinding(String name, String ... value) {
            this.namedBindings.put(name, Builder.toBinding(name, StringValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> setBinding(String name, long ... value) {
            this.namedBindings.put(name, Builder.toBinding(name, LongValue.MARSHALLER, Longs.asList((long[])value)));
            return this;
        }

        public Builder<V> setBinding(String name, double ... value) {
            this.namedBindings.put(name, Builder.toBinding(name, DoubleValue.MARSHALLER, Doubles.asList((double[])value)));
            return this;
        }

        public Builder<V> setBinding(String name, boolean ... value) {
            this.namedBindings.put(name, Builder.toBinding(name, BooleanValue.MARSHALLER, Booleans.asList((boolean[])value)));
            return this;
        }

        public Builder<V> setBinding(String name, DateTime ... value) {
            this.namedBindings.put(name, Builder.toBinding(name, DateTimeValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> setBinding(String name, Key ... value) {
            this.namedBindings.put(name, Builder.toBinding(name, KeyValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> setBinding(String name, FullEntity<?> ... value) {
            this.namedBindings.put(name, Builder.toBinding(name, EntityValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> setBinding(String name, Blob ... value) {
            this.namedBindings.put(name, Builder.toBinding(name, BlobValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> addBinding(Cursor cursor) {
            this.positionalBindings.add(new Binding(null, cursor));
            return this;
        }

        public Builder<V> addBinding(String ... value) {
            this.positionalBindings.add(Builder.toBinding(StringValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> addBinding(long ... value) {
            this.positionalBindings.add(Builder.toBinding(LongValue.MARSHALLER, Longs.asList((long[])value)));
            return this;
        }

        public Builder<V> addBinding(double ... value) {
            this.positionalBindings.add(Builder.toBinding(DoubleValue.MARSHALLER, Doubles.asList((double[])value)));
            return this;
        }

        public Builder<V> addBinding(boolean ... value) {
            this.positionalBindings.add(Builder.toBinding(BooleanValue.MARSHALLER, Booleans.asList((boolean[])value)));
            return this;
        }

        public Builder<V> addBinding(DateTime ... value) {
            this.positionalBindings.add(Builder.toBinding(DateTimeValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> addBinding(Key ... value) {
            this.positionalBindings.add(Builder.toBinding(KeyValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> addBinding(FullEntity<?> ... value) {
            this.positionalBindings.add(Builder.toBinding(EntityValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public Builder<V> addBinding(Blob ... value) {
            this.positionalBindings.add(Builder.toBinding(BlobValue.MARSHALLER, Arrays.asList(value)));
            return this;
        }

        public GqlQuery<V> build() {
            return new GqlQuery(this);
        }

        private static Binding toBinding(Value.BuilderFactory<?, ?, ?> builderFactory, List<?> values) {
            return Builder.toBinding(null, builderFactory, values);
        }

        private static <V> Binding toBinding(String name, Value.BuilderFactory<V, ?, ?> builderFactory, List<?> values) {
            ArrayList list = new ArrayList(values.size());
            Iterator<?> i$ = values.iterator();
            while (i$.hasNext()) {
                Object object;
                Object v = object = i$.next();
                list.add(builderFactory.newBuilder(v).build());
            }
            Value value = list.isEmpty() ? new NullValue() : (list.size() == 1 ? (Value)list.get(0) : new ListValue(list));
            return new Binding(name, value);
        }
    }

    static final class Binding
    extends Serializable<DatastoreV1.GqlQueryArg> {
        private static final long serialVersionUID = 1976895435257636275L;
        private final transient String name;
        private final transient Cursor cursor;
        private final transient Value<?> value;

        Binding(String name, Cursor cursor) {
            this.name = name;
            this.cursor = (Cursor)Preconditions.checkNotNull((Object)cursor);
            this.value = null;
        }

        Binding(String name, Value<?> value) {
            this.name = name;
            this.value = (Value)Preconditions.checkNotNull(value);
            this.cursor = null;
        }

        Object cursorOrValue() {
            return MoreObjects.firstNonNull((Object)this.cursor, this.value);
        }

        String name() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.cursor, this.value);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Binding)) {
                return false;
            }
            Binding other = (Binding)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.value, other.value);
        }

        @Override
        DatastoreV1.GqlQueryArg toPb() {
            DatastoreV1.GqlQueryArg.Builder argPb = DatastoreV1.GqlQueryArg.newBuilder();
            if (this.name != null) {
                argPb.setName(this.name);
            }
            if (this.cursor != null) {
                argPb.setCursor(this.cursor.byteString());
            }
            if (this.value != null) {
                argPb.setValue(this.value.toPb());
            }
            return argPb.build();
        }

        @Override
        Object fromPb(byte[] bytesPb) throws InvalidProtocolBufferException {
            return Binding.fromPb(DatastoreV1.GqlQueryArg.parseFrom((byte[])bytesPb));
        }

        static Binding fromPb(DatastoreV1.GqlQueryArg argPb) {
            String name;
            String string = name = argPb.hasName() ? argPb.getName() : null;
            if (argPb.hasCursor()) {
                return new Binding(name, new Cursor(argPb.getCursor()));
            }
            return new Binding(name, Value.fromPb(argPb.getValue()));
        }
    }
}

