/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gcloud.datastore.Serializable;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;

public final class PathElement
extends Serializable<DatastoreV1.Key.PathElement> {
    private static final long serialVersionUID = -7968078857690784595L;
    private final transient String kind;
    private final transient Long id;
    private final transient String name;

    private PathElement(String kind, String name, Long id) {
        this.kind = (String)Preconditions.checkNotNull((Object)kind, (Object)"kind must not be null");
        this.name = name;
        this.id = id;
    }

    public String kind() {
        return this.kind;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public Long id() {
        return this.id;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String name() {
        return this.name;
    }

    public Object nameOrId() {
        return this.id == null ? this.name : this.id;
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.id, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PathElement)) {
            return false;
        }
        PathElement other = (PathElement)obj;
        return Objects.equals(this.kind, other.kind) && Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name);
    }

    @Override
    DatastoreV1.Key.PathElement toPb() {
        DatastoreV1.Key.PathElement.Builder pathElementPb = DatastoreV1.Key.PathElement.newBuilder();
        pathElementPb.setKind(this.kind);
        if (this.id != null) {
            pathElementPb.setId(this.id.longValue());
        } else if (this.name != null) {
            pathElementPb.setName(this.name);
        }
        return pathElementPb.build();
    }

    @Override
    Object fromPb(byte[] bytesPb) throws InvalidProtocolBufferException {
        return PathElement.fromPb(DatastoreV1.Key.PathElement.parseFrom((byte[])bytesPb));
    }

    static PathElement fromPb(DatastoreV1.Key.PathElement pathElementPb) {
        String kind = pathElementPb.getKind();
        if (pathElementPb.hasId()) {
            return PathElement.of(kind, pathElementPb.getId());
        }
        if (pathElementPb.hasName()) {
            return PathElement.of(kind, pathElementPb.getName());
        }
        return PathElement.of(kind);
    }

    static PathElement of(String kind) {
        return new PathElement(kind, null, null);
    }

    public static PathElement of(String kind, String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name must not be empty or null");
        Preconditions.checkArgument((name.length() <= 500 ? 1 : 0) != 0, (Object)"name must not exceed 500 characters");
        return new PathElement(kind, name, null);
    }

    public static PathElement of(String kind, long id) {
        Preconditions.checkArgument((id != 0L ? 1 : 0) != 0, (Object)"id must not be equal to zero");
        return new PathElement(kind, null, id);
    }
}

