/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.gcloud.datastore.BaseEntity;
import com.google.gcloud.datastore.Blob;
import com.google.gcloud.datastore.DateTime;
import com.google.gcloud.datastore.Key;
import com.google.gcloud.datastore.LongValue;
import com.google.gcloud.datastore.StringValue;
import com.google.gcloud.datastore.Value;
import com.google.protobuf.ByteString;

public final class ProjectionEntity
extends BaseEntity<Key> {
    private static final long serialVersionUID = 432961565733066915L;

    ProjectionEntity(Builder builder) {
        super(builder);
    }

    @Override
    public DateTime getDateTime(String name) {
        Object value = this.getValue(name);
        if (((Value)value).hasMeaning() && ((Value)value).meaning() == 18 && value instanceof LongValue) {
            return new DateTime(this.getLong(name));
        }
        return (DateTime)((Value)value).get();
    }

    @Override
    public Blob getBlob(String name) {
        Object value = this.getValue(name);
        if (((Value)value).hasMeaning() && ((Value)value).meaning() == 18 && value instanceof StringValue) {
            return new Blob(ByteString.copyFromUtf8((String)this.getString(name)));
        }
        return (Blob)((Value)value).get();
    }

    static ProjectionEntity fromPb(DatastoreV1.Entity entityPb) {
        return ((Builder)new Builder().fill(entityPb)).build();
    }

    protected Builder emptyBuilder() {
        return new Builder();
    }

    public static Builder builder(ProjectionEntity copyFrom) {
        return new Builder(copyFrom);
    }

    public static final class Builder
    extends BaseEntity.Builder<Key, Builder> {
        Builder() {
        }

        private Builder(ProjectionEntity entity) {
            super(entity);
        }

        public ProjectionEntity build() {
            return new ProjectionEntity(this);
        }
    }
}

