/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gcloud.datastore.Blob;
import com.google.gcloud.datastore.BlobValue;
import com.google.gcloud.datastore.BooleanValue;
import com.google.gcloud.datastore.Cursor;
import com.google.gcloud.datastore.DateTime;
import com.google.gcloud.datastore.DateTimeValue;
import com.google.gcloud.datastore.DoubleValue;
import com.google.gcloud.datastore.EntityQuery;
import com.google.gcloud.datastore.Key;
import com.google.gcloud.datastore.KeyQuery;
import com.google.gcloud.datastore.KeyValue;
import com.google.gcloud.datastore.LongValue;
import com.google.gcloud.datastore.NullValue;
import com.google.gcloud.datastore.ProjectionEntityQuery;
import com.google.gcloud.datastore.Query;
import com.google.gcloud.datastore.StringValue;
import com.google.gcloud.datastore.Value;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public abstract class StructuredQuery<V>
extends Query<V> {
    private static final long serialVersionUID = 546838955624019594L;
    static final String KEY_PROPERTY_NAME = "__key__";
    private final transient String kind;
    private final ImmutableList<Projection> projection;
    private final transient Filter filter;
    private final ImmutableList<String> groupBy;
    private final transient ImmutableList<OrderBy> orderBy;
    private final transient Cursor startCursor;
    private final transient Cursor endCursor;
    private final transient int offset;
    private final transient Integer limit;

    StructuredQuery(BuilderImpl<V, ?> builder) {
        super(((BuilderImpl)builder).resultType, ((BuilderImpl)builder).namespace);
        this.kind = ((BuilderImpl)builder).kind;
        this.projection = ImmutableList.copyOf((Collection)((BuilderImpl)builder).projection);
        this.filter = ((BuilderImpl)builder).filter;
        this.groupBy = ImmutableList.copyOf((Collection)((BuilderImpl)builder).groupBy);
        this.orderBy = ImmutableList.copyOf((Collection)((BuilderImpl)builder).orderBy);
        this.startCursor = ((BuilderImpl)builder).startCursor;
        this.endCursor = ((BuilderImpl)builder).endCursor;
        this.offset = ((BuilderImpl)builder).offset;
        this.limit = ((BuilderImpl)builder).limit;
    }

    public int hashCode() {
        return Objects.hash(this.namespace(), this.kind, this.startCursor, this.endCursor, this.offset, this.limit, this.filter, this.orderBy, this.projection(), this.groupBy());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StructuredQuery)) {
            return false;
        }
        StructuredQuery other = (StructuredQuery)obj;
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.kind, other.kind) && Objects.equals(this.startCursor, other.startCursor) && Objects.equals(this.endCursor, other.endCursor) && Objects.equals(this.offset, other.offset) && Objects.equals(this.limit, other.limit) && Objects.equals(this.filter, other.filter) && Objects.equals(this.orderBy, other.orderBy) && Objects.equals(this.projection, other.projection) && Objects.equals(this.groupBy, other.groupBy);
    }

    public String kind() {
        return this.kind;
    }

    boolean keyOnly() {
        return this.projection.size() == 1 && KEY_PROPERTY_NAME.equals(((Projection)this.projection.get(0)).property);
    }

    public List<Projection> projection() {
        return this.projection;
    }

    public Filter filter() {
        return this.filter;
    }

    public List<String> groupBy() {
        return this.groupBy;
    }

    public ImmutableList<OrderBy> orderBy() {
        return this.orderBy;
    }

    public Cursor startCursor() {
        return this.startCursor;
    }

    public Cursor endCursor() {
        return this.endCursor;
    }

    public int offset() {
        return this.offset;
    }

    public Integer limit() {
        return this.limit;
    }

    public abstract Builder<V> toBuilder();

    @Override
    void populatePb(DatastoreV1.RunQueryRequest.Builder requestPb) {
        requestPb.setQuery(this.toPb());
    }

    @Override
    StructuredQuery<V> nextQuery(DatastoreV1.QueryResultBatch responsePb) {
        Builder<V> builder = this.toBuilder();
        builder.startCursor(new Cursor(responsePb.getEndCursor()));
        if (this.offset > 0 && responsePb.getSkippedResults() < this.offset) {
            builder.offset(this.offset - responsePb.getSkippedResults());
        } else {
            builder.offset(0);
            if (this.limit != null) {
                builder.limit(this.limit - responsePb.getEntityResultCount());
            }
        }
        return builder.build();
    }

    @Override
    DatastoreV1.Query toPb() {
        DatastoreV1.Query.Builder queryPb = DatastoreV1.Query.newBuilder();
        if (this.kind != null) {
            queryPb.addKindBuilder().setName(this.kind);
        }
        if (this.startCursor != null) {
            queryPb.setStartCursor(this.startCursor.byteString());
        }
        if (this.endCursor != null) {
            queryPb.setEndCursor(this.endCursor.byteString());
        }
        if (this.offset > 0) {
            queryPb.setOffset(this.offset);
        }
        if (this.limit != null) {
            queryPb.setLimit(this.limit.intValue());
        }
        if (this.filter != null) {
            queryPb.setFilter(this.filter.toPb());
        }
        for (Object value : this.orderBy) {
            queryPb.addOrder(((OrderBy)value).toPb());
        }
        for (Object value : this.groupBy) {
            queryPb.addGroupBy(DatastoreV1.PropertyReference.newBuilder().setName((String)value).build());
        }
        for (Object value : this.projection) {
            queryPb.addProjection(((Projection)value).toPb());
        }
        return queryPb.build();
    }

    @Override
    Object fromPb(Query.ResultType<V> resultType, String namespace, byte[] bytesPb) throws InvalidProtocolBufferException {
        return StructuredQuery.fromPb(resultType, namespace, DatastoreV1.Query.parseFrom((byte[])bytesPb));
    }

    static StructuredQuery<?> fromPb(Query.ResultType<?> resultType, String namespace, DatastoreV1.Query queryPb) {
        BuilderImpl builder = resultType.equals(Query.ResultType.ENTITY) ? new EntityQuery.Builder() : (resultType.equals(Query.ResultType.KEY) ? new KeyQuery.Builder() : new ProjectionEntityQuery.Builder());
        return ((BuilderImpl)builder.namespace(namespace)).mergeFrom(queryPb).build();
    }

    static abstract class BuilderImpl<V, B extends BuilderImpl<V, B>>
    implements Builder<V> {
        private final Query.ResultType<V> resultType;
        private String namespace;
        private String kind;
        private final List<Projection> projection = new LinkedList<Projection>();
        private Filter filter;
        private final List<String> groupBy = new LinkedList<String>();
        private final List<OrderBy> orderBy = new LinkedList<OrderBy>();
        private Cursor startCursor;
        private Cursor endCursor;
        private int offset;
        private Integer limit;

        BuilderImpl(Query.ResultType<V> resultType) {
            this.resultType = resultType;
        }

        BuilderImpl(StructuredQuery<V> query) {
            this(query.type());
            this.namespace = query.namespace();
            this.kind = ((StructuredQuery)query).kind;
            this.projection.addAll((Collection<Projection>)((StructuredQuery)query).projection);
            this.filter = ((StructuredQuery)query).filter;
            this.groupBy.addAll((Collection<String>)((StructuredQuery)query).groupBy);
            this.orderBy.addAll((Collection<OrderBy>)((StructuredQuery)query).orderBy);
            this.startCursor = ((StructuredQuery)query).startCursor;
            this.endCursor = ((StructuredQuery)query).endCursor;
            this.offset = ((StructuredQuery)query).offset;
            this.limit = ((StructuredQuery)query).limit;
        }

        B self() {
            return (B)this;
        }

        public B namespace(String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        public B kind(String kind) {
            this.kind = kind;
            return this.self();
        }

        public B startCursor(Cursor startCursor) {
            this.startCursor = startCursor;
            return this.self();
        }

        public B endCursor(Cursor endCursor) {
            this.endCursor = endCursor;
            return this.self();
        }

        public B offset(int offset) {
            Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"offset must not be negative");
            this.offset = offset;
            return this.self();
        }

        public B limit(Integer limit) {
            Preconditions.checkArgument((limit == null || limit > 0 ? 1 : 0) != 0, (Object)"limit must be positive");
            this.limit = limit;
            return this.self();
        }

        public B filter(Filter filter) {
            this.filter = filter;
            return this.self();
        }

        public B clearOrderBy() {
            this.orderBy.clear();
            return this.self();
        }

        public B orderBy(OrderBy orderBy, OrderBy ... others) {
            this.clearOrderBy();
            this.addOrderBy(orderBy, others);
            return this.self();
        }

        public B addOrderBy(OrderBy orderBy, OrderBy ... others) {
            this.orderBy.add(orderBy);
            Collections.addAll(this.orderBy, others);
            return this.self();
        }

        B clearProjection() {
            this.projection.clear();
            return this.self();
        }

        B projection(Projection projection, Projection ... others) {
            this.clearProjection();
            this.addProjection(projection, others);
            return this.self();
        }

        B addProjection(Projection projection, Projection ... others) {
            this.projection.add(projection);
            Collections.addAll(this.projection, others);
            return this.self();
        }

        B clearGroupBy() {
            this.groupBy.clear();
            return this.self();
        }

        B groupBy(String property, String ... others) {
            this.clearGroupBy();
            this.addGroupBy(property, others);
            return this.self();
        }

        B addGroupBy(String property, String ... others) {
            this.groupBy.add(property);
            Collections.addAll(this.groupBy, others);
            return this.self();
        }

        B mergeFrom(DatastoreV1.Query queryPb) {
            if (queryPb.getKindCount() > 0) {
                this.kind(queryPb.getKind(0).getName());
            }
            if (queryPb.hasStartCursor()) {
                this.startCursor(new Cursor(queryPb.getStartCursor()));
            }
            if (queryPb.hasEndCursor()) {
                this.endCursor(new Cursor(queryPb.getEndCursor()));
            }
            if (queryPb.hasOffset()) {
                this.offset(queryPb.getOffset());
            }
            if (queryPb.hasLimit()) {
                this.limit(queryPb.getLimit());
            }
            if (queryPb.hasFilter()) {
                this.filter(Filter.fromPb(queryPb.getFilter()));
            }
            for (DatastoreV1.PropertyOrder orderByPb : queryPb.getOrderList()) {
                this.addOrderBy(OrderBy.fromPb(orderByPb), new OrderBy[0]);
            }
            for (DatastoreV1.PropertyExpression projectionPb : queryPb.getProjectionList()) {
                this.addProjection(Projection.fromPb(projectionPb), new Projection[0]);
            }
            for (DatastoreV1.PropertyReference groupByPb : queryPb.getGroupByList()) {
                this.addGroupBy(groupByPb.getName(), new String[0]);
            }
            return this.self();
        }
    }

    public static interface Builder<V> {
        public Builder<V> namespace(String var1);

        public Builder<V> kind(String var1);

        public Builder<V> startCursor(Cursor var1);

        public Builder<V> endCursor(Cursor var1);

        public Builder<V> offset(int var1);

        public Builder<V> limit(Integer var1);

        public Builder<V> filter(Filter var1);

        public Builder<V> clearOrderBy();

        public Builder<V> orderBy(OrderBy var1, OrderBy ... var2);

        public Builder<V> addOrderBy(OrderBy var1, OrderBy ... var2);

        public StructuredQuery<V> build();
    }

    public static final class Projection
    implements Serializable {
        private static final long serialVersionUID = 3083707957256279470L;
        private final Aggregate aggregate;
        private final String property;

        private Projection(Aggregate aggregate, String property) {
            this.aggregate = aggregate;
            this.property = property;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.property, this.aggregate});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Projection)) {
                return false;
            }
            Projection other = (Projection)obj;
            return Objects.equals(this.property, other.property) && Objects.equals((Object)this.aggregate, (Object)other.aggregate);
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
            toStringHelper.add("property", (Object)this.property);
            if (this.aggregate != null) {
                toStringHelper.add("aggregate", (Object)this.aggregate);
            }
            return toStringHelper.toString();
        }

        DatastoreV1.PropertyExpression toPb() {
            DatastoreV1.PropertyExpression.Builder expressionPb = DatastoreV1.PropertyExpression.newBuilder();
            if (this.aggregate != null) {
                expressionPb.setAggregationFunction(this.aggregate.toPb());
            }
            expressionPb.setProperty(DatastoreV1.PropertyReference.newBuilder().setName(this.property).build());
            return expressionPb.build();
        }

        static Projection fromPb(DatastoreV1.PropertyExpression propertyExpressionPb) {
            String property = propertyExpressionPb.getProperty().getName();
            Aggregate aggregate = null;
            if (propertyExpressionPb.hasAggregationFunction()) {
                aggregate = Aggregate.fromPb(propertyExpressionPb.getAggregationFunction());
            }
            return new Projection(aggregate, property);
        }

        public static Projection property(String property) {
            return new Projection(null, property);
        }

        public static Projection aggregate(Aggregate aggregate, String property) {
            return new Projection(aggregate, property);
        }

        public static Projection first(String property) {
            return new Projection(Aggregate.FIRST, property);
        }

        public static enum Aggregate {
            FIRST;


            DatastoreV1.PropertyExpression.AggregationFunction toPb() {
                return DatastoreV1.PropertyExpression.AggregationFunction.valueOf((String)this.name());
            }

            static Aggregate fromPb(DatastoreV1.PropertyExpression.AggregationFunction aggregatePb) {
                return Aggregate.valueOf(aggregatePb.name());
            }
        }
    }

    public static final class OrderBy
    implements Serializable {
        private static final long serialVersionUID = 4091186784814400031L;
        private final String property;
        private final Direction direction;

        public OrderBy(String property, Direction direction) {
            this.property = (String)Preconditions.checkNotNull((Object)property);
            this.direction = (Direction)((Object)Preconditions.checkNotNull((Object)((Object)direction)));
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.property, this.direction});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof OrderBy)) {
                return false;
            }
            OrderBy other = (OrderBy)obj;
            return this.property.equals(other.property) && this.direction == other.direction;
        }

        public String property() {
            return this.property;
        }

        public Direction direction() {
            return this.direction;
        }

        DatastoreV1.PropertyOrder toPb() {
            return DatastoreV1.PropertyOrder.newBuilder().setDirection(this.direction.toPb()).setProperty(DatastoreV1.PropertyReference.newBuilder().setName(this.property).build()).build();
        }

        public static OrderBy asc(String property) {
            return new OrderBy(property, Direction.ASCENDING);
        }

        public static OrderBy desc(String property) {
            return new OrderBy(property, Direction.DESCENDING);
        }

        static OrderBy fromPb(DatastoreV1.PropertyOrder propertyOrderPb) {
            String property = propertyOrderPb.getProperty().getName();
            Direction direction = Direction.fromPb(propertyOrderPb.getDirection());
            return new OrderBy(property, direction);
        }

        public static enum Direction {
            ASCENDING,
            DESCENDING;


            DatastoreV1.PropertyOrder.Direction toPb() {
                return DatastoreV1.PropertyOrder.Direction.valueOf((String)this.name());
            }

            static Direction fromPb(DatastoreV1.PropertyOrder.Direction directionPb) {
                return Direction.valueOf(directionPb.name());
            }
        }
    }

    public static final class PropertyFilter
    extends Filter {
        private static final long serialVersionUID = -4514695915258598597L;
        private final String property;
        private final Operator operator;
        private final Value<?> value;

        private PropertyFilter(String property, Operator operator, Value<?> value) {
            this.property = (String)Preconditions.checkNotNull((Object)property);
            this.operator = (Operator)((Object)Preconditions.checkNotNull((Object)((Object)operator)));
            this.value = (Value)Preconditions.checkNotNull(value);
        }

        static PropertyFilter fromPb(DatastoreV1.PropertyFilter propertyFilterPb) {
            String property = propertyFilterPb.getProperty().getName();
            Operator operator = Operator.fromPb(propertyFilterPb.getOperator());
            Value<?> value = Value.fromPb(propertyFilterPb.getValue());
            return new PropertyFilter(property, operator, value);
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
            toStringHelper.add("property", (Object)this.property);
            toStringHelper.add("operator", (Object)this.operator);
            toStringHelper.add("value", this.value);
            return toStringHelper.toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.property, this.operator, this.value});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PropertyFilter)) {
                return false;
            }
            PropertyFilter other = (PropertyFilter)obj;
            return this.property.equals(other.property) && this.operator == other.operator && Objects.equals(this.value, other.value);
        }

        public static PropertyFilter lt(String property, Value<?> value) {
            return new PropertyFilter(property, Operator.LESS_THAN, value);
        }

        public static PropertyFilter lt(String property, String value) {
            return new PropertyFilter(property, Operator.LESS_THAN, StringValue.of(value));
        }

        public static PropertyFilter lt(String property, long value) {
            return new PropertyFilter(property, Operator.LESS_THAN, LongValue.of(value));
        }

        public static PropertyFilter lt(String property, double value) {
            return new PropertyFilter(property, Operator.LESS_THAN, DoubleValue.of(value));
        }

        public static PropertyFilter lt(String property, boolean value) {
            return new PropertyFilter(property, Operator.LESS_THAN, BooleanValue.of(value));
        }

        public static PropertyFilter lt(String property, DateTime value) {
            return new PropertyFilter(property, Operator.LESS_THAN, DateTimeValue.of(value));
        }

        public static PropertyFilter lt(String property, Key value) {
            return new PropertyFilter(property, Operator.LESS_THAN, KeyValue.of(value));
        }

        public static PropertyFilter lt(String property, Blob value) {
            return new PropertyFilter(property, Operator.LESS_THAN, BlobValue.of(value));
        }

        public static PropertyFilter le(String property, Value<?> value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, value);
        }

        public static PropertyFilter le(String property, String value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, StringValue.of(value));
        }

        public static PropertyFilter le(String property, long value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, LongValue.of(value));
        }

        public static PropertyFilter le(String property, double value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, DoubleValue.of(value));
        }

        public static PropertyFilter le(String property, boolean value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, BooleanValue.of(value));
        }

        public static PropertyFilter le(String property, DateTime value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, DateTimeValue.of(value));
        }

        public static PropertyFilter le(String property, Key value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, KeyValue.of(value));
        }

        public static PropertyFilter le(String property, Blob value) {
            return new PropertyFilter(property, Operator.LESS_THAN_OR_EQUAL, BlobValue.of(value));
        }

        public static PropertyFilter gt(String property, Value<?> value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, value);
        }

        public static PropertyFilter gt(String property, String value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, StringValue.of(value));
        }

        public static PropertyFilter gt(String property, long value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, LongValue.of(value));
        }

        public static PropertyFilter gt(String property, double value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, DoubleValue.of(value));
        }

        public static PropertyFilter gt(String property, boolean value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, BooleanValue.of(value));
        }

        public static PropertyFilter gt(String property, DateTime value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, DateTimeValue.of(value));
        }

        public static PropertyFilter gt(String property, Key value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, KeyValue.of(value));
        }

        public static PropertyFilter gt(String property, Blob value) {
            return new PropertyFilter(property, Operator.GREATER_THAN, BlobValue.of(value));
        }

        public static PropertyFilter ge(String property, Value<?> value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, value);
        }

        public static PropertyFilter ge(String property, String value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, StringValue.of(value));
        }

        public static PropertyFilter ge(String property, long value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, LongValue.of(value));
        }

        public static PropertyFilter ge(String property, double value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, DoubleValue.of(value));
        }

        public static PropertyFilter ge(String property, boolean value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, BooleanValue.of(value));
        }

        public static PropertyFilter ge(String property, DateTime value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, DateTimeValue.of(value));
        }

        public static PropertyFilter ge(String property, Key value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, KeyValue.of(value));
        }

        public static PropertyFilter ge(String property, Blob value) {
            return new PropertyFilter(property, Operator.GREATER_THAN_OR_EQUAL, BlobValue.of(value));
        }

        public static PropertyFilter eq(String property, Value<?> value) {
            return new PropertyFilter(property, Operator.EQUAL, value);
        }

        public static PropertyFilter eq(String property, String value) {
            return new PropertyFilter(property, Operator.EQUAL, StringValue.of(value));
        }

        public static PropertyFilter eq(String property, long value) {
            return new PropertyFilter(property, Operator.EQUAL, LongValue.of(value));
        }

        public static PropertyFilter eq(String property, double value) {
            return new PropertyFilter(property, Operator.EQUAL, DoubleValue.of(value));
        }

        public static PropertyFilter eq(String property, boolean value) {
            return new PropertyFilter(property, Operator.EQUAL, BooleanValue.of(value));
        }

        public static PropertyFilter eq(String property, DateTime value) {
            return new PropertyFilter(property, Operator.EQUAL, DateTimeValue.of(value));
        }

        public static PropertyFilter eq(String property, Key value) {
            return new PropertyFilter(property, Operator.EQUAL, KeyValue.of(value));
        }

        public static PropertyFilter eq(String property, Blob value) {
            return new PropertyFilter(property, Operator.EQUAL, BlobValue.of(value));
        }

        public static PropertyFilter hasAncestor(Key key) {
            return new PropertyFilter(StructuredQuery.KEY_PROPERTY_NAME, Operator.HAS_ANCESTOR, KeyValue.of(key));
        }

        public static PropertyFilter isNull(String property) {
            return new PropertyFilter(property, Operator.EQUAL, NullValue.of());
        }

        @Override
        DatastoreV1.Filter toPb() {
            DatastoreV1.Filter.Builder filterPb = DatastoreV1.Filter.newBuilder();
            DatastoreV1.PropertyFilter.Builder propertyFilterPb = filterPb.getPropertyFilterBuilder();
            propertyFilterPb.getPropertyBuilder().setName(this.property);
            propertyFilterPb.setOperator(this.operator.toPb());
            if (this.value != null) {
                propertyFilterPb.setValue(this.value.toPb());
            }
            return filterPb.build();
        }

        static enum Operator {
            LESS_THAN,
            LESS_THAN_OR_EQUAL,
            GREATER_THAN,
            GREATER_THAN_OR_EQUAL,
            EQUAL,
            HAS_ANCESTOR;


            DatastoreV1.PropertyFilter.Operator toPb() {
                return DatastoreV1.PropertyFilter.Operator.valueOf((String)this.name());
            }

            static Operator fromPb(DatastoreV1.PropertyFilter.Operator operatorPb) {
                return Operator.valueOf(operatorPb.name());
            }
        }
    }

    public static final class CompositeFilter
    extends Filter {
        private static final long serialVersionUID = 3610352685739360009L;
        private final Operator operator;
        private final ImmutableList<Filter> filters;

        private CompositeFilter(Operator operator, Filter first, Filter ... other) {
            this.operator = operator;
            this.filters = ImmutableList.builder().add((Object)first).addAll(Arrays.asList(other)).build();
        }

        private CompositeFilter(Operator operator, ImmutableList<Filter> filters) {
            this.operator = operator;
            this.filters = filters;
            Preconditions.checkArgument((!filters.isEmpty() ? 1 : 0) != 0, (Object)"filters list must not be empty");
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
            toStringHelper.add("operator", (Object)this.operator);
            toStringHelper.add("filters", this.filters);
            return toStringHelper.toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.operator, this.filters});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CompositeFilter)) {
                return false;
            }
            CompositeFilter other = (CompositeFilter)obj;
            return this.operator == other.operator && this.filters.equals(other.filters);
        }

        static CompositeFilter fromPb(DatastoreV1.CompositeFilter compositeFilterPb) {
            Operator operator = Operator.fromPb(compositeFilterPb.getOperator());
            ImmutableList.Builder filters = ImmutableList.builder();
            for (DatastoreV1.Filter filterPb : compositeFilterPb.getFilterList()) {
                filters.add((Object)Filter.fromPb(filterPb));
            }
            return new CompositeFilter(operator, (ImmutableList<Filter>)filters.build());
        }

        public static CompositeFilter and(Filter first, Filter ... other) {
            return new CompositeFilter(Operator.AND, first, other);
        }

        @Override
        DatastoreV1.Filter toPb() {
            DatastoreV1.Filter.Builder filterPb = DatastoreV1.Filter.newBuilder();
            DatastoreV1.CompositeFilter.Builder compositeFilterPb = filterPb.getCompositeFilterBuilder();
            compositeFilterPb.setOperator(this.operator.toPb());
            for (Filter filter : this.filters) {
                compositeFilterPb.addFilter(filter.toPb());
            }
            return filterPb.build();
        }

        static enum Operator {
            AND;


            DatastoreV1.CompositeFilter.Operator toPb() {
                return DatastoreV1.CompositeFilter.Operator.valueOf((String)this.name());
            }

            static Operator fromPb(DatastoreV1.CompositeFilter.Operator operatorPb) {
                return Operator.valueOf(operatorPb.name());
            }
        }
    }

    public static abstract class Filter
    implements Serializable {
        private static final long serialVersionUID = -6443285436239990860L;

        Filter() {
        }

        abstract DatastoreV1.Filter toPb();

        static Filter fromPb(DatastoreV1.Filter filterPb) {
            if (filterPb.hasCompositeFilter()) {
                return CompositeFilter.fromPb(filterPb.getCompositeFilter());
            }
            return PropertyFilter.fromPb(filterPb.getPropertyFilter());
        }
    }
}

