/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore.testing;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class LocalGcdHelper {
    private static final Logger log = Logger.getLogger(LocalGcdHelper.class.getName());
    private final String projectId;
    private Path gcdPath;
    private Process startProcess;
    private ProcessStreamReader processReader;
    private ProcessErrorStreamReader processErrorReader;
    private final int port;
    public static final String DEFAULT_PROJECT_ID = "projectid1";
    public static final int DEFAULT_PORT = 8080;
    private static final String GCD_VERSION = "v1beta2";
    private static final String GCD_BUILD = "rev1-2.1.2b";
    private static final String GCD_BASENAME = "gcd-v1beta2-rev1-2.1.2b";
    private static final String GCD_FILENAME = "gcd-v1beta2-rev1-2.1.2b.zip";
    private static final String MD5_CHECKSUM = "d84384cdfa8658e1204f4f8be51300e8";
    private static final URL GCD_URL;
    private static final String GCLOUD = "gcloud";
    private static final Path INSTALLED_GCD_PATH;
    private static final String GCD_VERSION_PREFIX = "gcd-emulator ";
    private static final double DEFAULT_CONSISTENCY = 0.9;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findAvailablePort(int defaultPort) {
        try (ServerSocket tempSocket = new ServerSocket(0);){
            int n = tempSocket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            return defaultPort;
        }
    }

    private static Path installedGcdPath() {
        Path installedGcdPath;
        String gcloudExecutableName = LocalGcdHelper.isWindows() ? "gcloud.cmd" : GCLOUD;
        Path gcloudPath = LocalGcdHelper.executablePath(gcloudExecutableName);
        Path path = gcloudPath = gcloudPath == null ? null : gcloudPath.getParent();
        if (gcloudPath == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("SDK not found");
            }
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("SDK found, looking for datastore emulator");
        }
        if (Files.exists(installedGcdPath = gcloudPath.resolve("platform").resolve("gcd"), new LinkOption[0])) {
            try {
                String installedVersion = LocalGcdHelper.installedGcdVersion();
                if (installedVersion != null && installedVersion.startsWith(GCD_VERSION)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("SDK datastore emulator found");
                    }
                    return installedGcdPath;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("SDK datastore emulator found but version mismatch");
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String installedGcdVersion() throws IOException, InterruptedException {
        Process process = CommandWrapper.create().command(GCLOUD, "version").redirectErrorStream().start();
        process.waitFor();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line = reader.readLine();
            while (line != null) {
                String[] lineComponents;
                if (line.startsWith(GCD_VERSION_PREFIX) && (lineComponents = line.split(" ")).length > 1) {
                    String string = lineComponents[1];
                    return string;
                }
                line = reader.readLine();
            }
            String string = null;
            return string;
        }
    }

    private static Path executablePath(String cmd) {
        String[] paths;
        for (String pathString : paths = System.getenv("PATH").split(Pattern.quote(File.pathSeparator))) {
            try {
                Path path = Paths.get(pathString, new String[0]);
                if (!Files.exists(path.resolve(cmd), new LinkOption[0])) continue;
                return path;
            }
            catch (InvalidPathException ignore) {
                // empty catch block
            }
        }
        return null;
    }

    public LocalGcdHelper(String projectId, int port) {
        this.projectId = projectId;
        this.port = port;
    }

    public void start(double consistency) throws IOException, InterruptedException {
        Path gcdExecutablePath;
        Preconditions.checkArgument((consistency >= 0.0 && consistency <= 1.0 ? 1 : 0) != 0, (Object)"Consistency must be between 0 and 1");
        LocalGcdHelper.sendQuitRequest(this.port);
        this.gcdPath = Files.createTempDirectory("gcd", new FileAttribute[0]);
        File gcdFolder = this.gcdPath.toFile();
        gcdFolder.deleteOnExit();
        if (INSTALLED_GCD_PATH == null) {
            this.downloadGcd();
            gcdExecutablePath = this.gcdPath.resolve(GCD_BASENAME);
        } else {
            gcdExecutablePath = INSTALLED_GCD_PATH;
        }
        this.startGcd(gcdExecutablePath, consistency);
    }

    private void downloadGcd() throws IOException {
        File gcdZipFile = new File(System.getProperty("java.io.tmpdir"), GCD_FILENAME);
        if (!gcdZipFile.exists() || !MD5_CHECKSUM.equals(LocalGcdHelper.md5(gcdZipFile))) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Fetching datastore emulator");
            }
            ReadableByteChannel rbc = Channels.newChannel(GCD_URL.openStream());
            try (FileOutputStream fos = new FileOutputStream(gcdZipFile);){
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Using cached datastore emulator");
        }
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(gcdZipFile));){
            if (log.isLoggable(Level.FINE)) {
                log.fine("Unzipping datastore emulator");
            }
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                File filePath = new File(this.gcdPath.toFile(), entry.getName());
                if (!entry.isDirectory()) {
                    LocalGcdHelper.extractFile(zipIn, filePath);
                } else {
                    filePath.mkdir();
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
    }

    private void startGcd(Path executablePath, double consistency) throws IOException, InterruptedException {
        File datasetFolder = new File(this.gcdPath.toFile(), this.projectId);
        LocalGcdHelper.deleteRecurse(datasetFolder.toPath());
        Path gcdAbsolutePath = LocalGcdHelper.isWindows() ? executablePath.toAbsolutePath().resolve("gcd.cmd") : executablePath.toAbsolutePath().resolve("gcd.sh");
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating datastore for the project: {0}", this.projectId);
        }
        Process createProcess = CommandWrapper.create().command(gcdAbsolutePath.toString(), "create", "-p", this.projectId, this.projectId).redirectErrorInherit().directory(this.gcdPath).redirectOutputToNull().start();
        createProcess.waitFor();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Starting datastore emulator for the project: {0}", this.projectId);
        }
        this.startProcess = CommandWrapper.create().command(gcdAbsolutePath.toString(), "start", "--testing", "--allow_remote_shutdown", "--port=" + Integer.toString(this.port), "--consistency=" + Double.toString(consistency), this.projectId).directory(this.gcdPath).start();
        this.processReader = ProcessStreamReader.start(this.startProcess.getInputStream());
        this.processErrorReader = ProcessErrorStreamReader.start(this.startProcess.getErrorStream(), "Dev App Server is now running");
    }

    private static String md5(File gcdZipFile) throws IOException {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(gcdZipFile));){
                int len;
                byte[] bytes = new byte[0x400000];
                while ((len = ((InputStream)is).read(bytes)) >= 0) {
                    md5.update(bytes, 0, len);
                }
            }
            return String.format("%032x", new BigInteger(1, md5.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    }

    private static void extractFile(ZipInputStream zipIn, File filePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));){
            int read;
            byte[] bytesIn = new byte[1024];
            while ((read = zipIn.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }

    public static boolean sendQuitRequest(int port) {
        StringBuilder result = new StringBuilder();
        String shutdownMsg = "Shutting down local server";
        try {
            URL url = new URL("http", "localhost", port, "/_ah/admin/quit");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            OutputStream out = con.getOutputStream();
            out.write("".getBytes());
            out.flush();
            InputStream in = con.getInputStream();
            int currByte = 0;
            while ((currByte = in.read()) != -1 && result.length() < shutdownMsg.length()) {
                result.append((char)currByte);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toString().startsWith(shutdownMsg);
    }

    public void stop() throws IOException, InterruptedException {
        LocalGcdHelper.sendQuitRequest(this.port);
        if (this.processReader != null) {
            this.processReader.terminate();
            this.processErrorReader.terminate();
            this.startProcess.destroy();
            this.startProcess.waitFor();
        }
        if (this.gcdPath != null) {
            LocalGcdHelper.deleteRecurse(this.gcdPath);
        }
    }

    private static void deleteRecurse(Path path) throws IOException {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static LocalGcdHelper start(String projectId, int port, double consistency) throws IOException, InterruptedException {
        LocalGcdHelper helper = new LocalGcdHelper(projectId, port);
        helper.start(consistency);
        return helper;
    }

    public static void main(String ... args) throws IOException, InterruptedException {
        Map<String, String> parsedArgs = LocalGcdHelper.parseArgs(args);
        String action = parsedArgs.get("action");
        int port = parsedArgs.get("port") == null ? 8080 : Integer.parseInt(parsedArgs.get("port"));
        switch (action) {
            case "START": {
                if (!LocalGcdHelper.isActive(DEFAULT_PROJECT_ID, port)) {
                    double consistency = parsedArgs.get("consistency") == null ? 0.9 : Double.parseDouble(parsedArgs.get("consistency"));
                    LocalGcdHelper helper = LocalGcdHelper.start(DEFAULT_PROJECT_ID, port, consistency);
                    try (FileWriter writer = new FileWriter(".local_gcd_helper");){
                        writer.write(helper.gcdPath.toAbsolutePath().toString() + System.lineSeparator());
                        writer.write(Integer.toString(port));
                    }
                }
                return;
            }
            case "STOP": {
                File file = new File(".local_gcd_helper");
                String path = null;
                boolean fileExists = file.exists();
                if (fileExists) {
                    try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                        path = reader.readLine();
                        port = Integer.parseInt(reader.readLine());
                    }
                }
                LocalGcdHelper.sendQuitRequest(port);
                if (fileExists) {
                    LocalGcdHelper.deleteRecurse(Paths.get(path, new String[0]));
                    file.delete();
                }
                return;
            }
        }
    }

    private static Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> parsedArgs = new HashMap<String, String>();
        for (String arg : args) {
            if (arg.startsWith("--port=")) {
                parsedArgs.put("port", arg.substring("--port=".length()));
                continue;
            }
            if (arg.equals("START") || arg.equals("STOP")) {
                parsedArgs.put("action", arg);
                continue;
            }
            throw new RuntimeException("Only accepts START, STOP, and --port=<port #> as arguments");
        }
        if (parsedArgs.get("action") == null) {
            throw new RuntimeException("EXPECTING START | STOP");
        }
        return parsedArgs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isActive(String projectId, int port) {
        try {
            StringBuilder urlBuilder = new StringBuilder("http://localhost:").append(port);
            urlBuilder.append("/datastore/v1beta2/datasets/").append(projectId).append("/lookup");
            URL url = new URL(urlBuilder.toString());
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                boolean bl = "Valid RPC".equals(reader.readLine());
                return bl;
            }
        }
        catch (IOException ignore) {
            return false;
        }
    }

    static {
        INSTALLED_GCD_PATH = LocalGcdHelper.installedGcdPath();
        if (INSTALLED_GCD_PATH != null) {
            GCD_URL = null;
        } else {
            try {
                GCD_URL = new URL("http://storage.googleapis.com/gcd/tools/gcd-v1beta2-rev1-2.1.2b.zip");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class CommandWrapper {
        private final List<String> prefix = new ArrayList<String>();
        private List<String> command;
        private String nullFilename;
        private boolean redirectOutputToNull;
        private boolean redirectErrorStream;
        private boolean redirectErrorInherit;
        private Path directory;

        private CommandWrapper() {
            if (LocalGcdHelper.isWindows()) {
                this.prefix.add("cmd");
                this.prefix.add("/C");
                this.nullFilename = "NUL:";
            } else {
                this.prefix.add("bash");
                this.nullFilename = "/dev/null";
            }
        }

        public CommandWrapper command(String ... command) {
            this.command = new ArrayList<String>(command.length + this.prefix.size());
            this.command.addAll(this.prefix);
            this.command.addAll(Arrays.asList(command));
            return this;
        }

        public CommandWrapper redirectOutputToNull() {
            this.redirectOutputToNull = true;
            return this;
        }

        public CommandWrapper redirectErrorStream() {
            this.redirectErrorStream = true;
            return this;
        }

        public CommandWrapper redirectErrorInherit() {
            this.redirectErrorInherit = true;
            return this;
        }

        public CommandWrapper directory(Path directory) {
            this.directory = directory;
            return this;
        }

        public ProcessBuilder builder() {
            ProcessBuilder builder = new ProcessBuilder(this.command);
            if (this.redirectOutputToNull) {
                builder.redirectOutput(new File(this.nullFilename));
            }
            if (this.directory != null) {
                builder.directory(this.directory.toFile());
            }
            if (this.redirectErrorStream) {
                builder.redirectErrorStream(true);
            }
            if (this.redirectErrorInherit) {
                builder.redirectError(ProcessBuilder.Redirect.INHERIT);
            }
            return builder;
        }

        public Process start() throws IOException {
            return this.builder().start();
        }

        public static CommandWrapper create() {
            return new CommandWrapper();
        }
    }

    private static class ProcessErrorStreamReader
    extends Thread {
        private static final int LOG_LENGTH_LIMIT = 50000;
        private static final String GCD_LOGGING_CLASS = "com.google.apphosting.client.serviceapp.BaseApiServlet";
        private final BufferedReader errorReader;
        private StringBuilder currentLog;
        private Level currentLogLevel;
        private boolean collectionMode;
        private volatile boolean terminated;

        ProcessErrorStreamReader(InputStream errorStream, String blockUntil) throws IOException {
            super("Local GCD ErrorStream reader");
            this.setDaemon(true);
            this.errorReader = new BufferedReader(new InputStreamReader(errorStream));
            if (!Strings.isNullOrEmpty((String)blockUntil)) {
                String line;
                while ((line = this.errorReader.readLine()) != null && !line.contains(blockUntil)) {
                }
            }
        }

        void terminate() throws IOException {
            this.terminated = true;
            this.errorReader.close();
        }

        @Override
        public void run() {
            String previousLine = "";
            String nextLine = "";
            while (!this.terminated) {
                try {
                    previousLine = nextLine;
                    nextLine = this.errorReader.readLine();
                    if (nextLine == null) {
                        this.terminated = true;
                        continue;
                    }
                    this.processLogLine(previousLine, nextLine);
                }
                catch (IOException iOException) {}
            }
            this.processLogLine(previousLine, (String)MoreObjects.firstNonNull((Object)nextLine, (Object)""));
            ProcessErrorStreamReader.writeLog(this.currentLogLevel, this.currentLog);
        }

        private void processLogLine(String previousLine, String nextLine) {
            Level nextLogLevel = ProcessErrorStreamReader.getLevel(nextLine);
            if (nextLogLevel != null) {
                ProcessErrorStreamReader.writeLog(this.currentLogLevel, this.currentLog);
                this.currentLog = new StringBuilder();
                this.currentLogLevel = nextLogLevel;
                this.collectionMode = previousLine.contains(GCD_LOGGING_CLASS);
            } else if (this.collectionMode) {
                if (this.currentLog.length() > 50000) {
                    this.collectionMode = false;
                } else if (this.currentLog.length() == 0) {
                    this.currentLog.append("GCD");
                    this.currentLog.append(previousLine.split(":", 2)[1]);
                    this.currentLog.append(System.getProperty("line.separator"));
                } else {
                    this.currentLog.append(previousLine);
                    this.currentLog.append(System.getProperty("line.separator"));
                }
            }
        }

        private static void writeLog(Level level, StringBuilder msg) {
            if (level != null && msg != null && msg.length() != 0) {
                log.log(level, msg.toString().trim());
            }
        }

        private static Level getLevel(String line) {
            try {
                return Level.parse(line.split(":")[0]);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static ProcessErrorStreamReader start(InputStream errorStream, String blockUntil) throws IOException {
            ProcessErrorStreamReader thread = new ProcessErrorStreamReader(errorStream, blockUntil);
            thread.start();
            return thread;
        }
    }

    private static class ProcessStreamReader
    extends Thread {
        private final BufferedReader reader;
        private volatile boolean terminated;

        ProcessStreamReader(InputStream inputStream) {
            super("Local GCD InputStream reader");
            this.setDaemon(true);
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        void terminate() throws IOException {
            this.terminated = true;
            this.reader.close();
        }

        @Override
        public void run() {
            while (!this.terminated) {
                try {
                    String line = this.reader.readLine();
                    if (line != null) continue;
                    this.terminated = true;
                }
                catch (IOException iOException) {}
            }
        }

        public static ProcessStreamReader start(InputStream inputStream) {
            ProcessStreamReader thread = new ProcessStreamReader(inputStream);
            thread.start();
            return thread;
        }
    }
}

