/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.gcloud.datastore.BaseKey;
import com.google.gcloud.datastore.Blob;
import com.google.gcloud.datastore.BlobValue;
import com.google.gcloud.datastore.BooleanValue;
import com.google.gcloud.datastore.DatastoreException;
import com.google.gcloud.datastore.DateTime;
import com.google.gcloud.datastore.DateTimeValue;
import com.google.gcloud.datastore.DoubleValue;
import com.google.gcloud.datastore.EntityValue;
import com.google.gcloud.datastore.FullEntity;
import com.google.gcloud.datastore.IncompleteKey;
import com.google.gcloud.datastore.Key;
import com.google.gcloud.datastore.KeyValue;
import com.google.gcloud.datastore.ListValue;
import com.google.gcloud.datastore.LongValue;
import com.google.gcloud.datastore.NullValue;
import com.google.gcloud.datastore.Serializable;
import com.google.gcloud.datastore.StringValue;
import com.google.gcloud.datastore.Value;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class BaseEntity<K extends IncompleteKey>
extends Serializable<DatastoreV1.Entity> {
    private static final long serialVersionUID = 8175618724683792766L;
    private final transient ImmutableSortedMap<String, Value<?>> properties;
    private final K key;

    BaseEntity(Builder<K, ?> builder) {
        this.key = ((Builder)builder).key;
        this.properties = ImmutableSortedMap.copyOf((Map)((Builder)builder).properties);
    }

    BaseEntity(BaseEntity<K> from) {
        this.key = from.key();
        this.properties = from.properties;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.properties);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BaseEntity)) {
            return false;
        }
        BaseEntity other = (BaseEntity)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.properties, other.properties);
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public K key() {
        return this.key;
    }

    public boolean contains(String name) {
        return this.properties.containsKey((Object)name);
    }

    public <V extends Value<?>> V getValue(String name) {
        Value property = (Value)this.properties.get((Object)name);
        if (property == null) {
            throw DatastoreException.throwInvalidRequest("No such property %s", name);
        }
        return (V)property;
    }

    public boolean isNull(String name) {
        return this.getValue(name) instanceof NullValue;
    }

    public String getString(String name) {
        return (String)((Value)this.getValue(name)).get();
    }

    public long getLong(String name) {
        return (Long)((Value)this.getValue(name)).get();
    }

    public double getDouble(String name) {
        return (Double)((Value)this.getValue(name)).get();
    }

    public boolean getBoolean(String name) {
        return (Boolean)((Value)this.getValue(name)).get();
    }

    public DateTime getDateTime(String name) {
        return (DateTime)((Value)this.getValue(name)).get();
    }

    public Key getKey(String name) {
        return (Key)((Value)this.getValue(name)).get();
    }

    public <K extends IncompleteKey> FullEntity<K> getEntity(String name) {
        return (FullEntity)((Value)this.getValue(name)).get();
    }

    public <T extends Value<?>> List<T> getList(String name) {
        return (List)((Value)this.getValue(name)).get();
    }

    public Blob getBlob(String name) {
        return (Blob)((Value)this.getValue(name)).get();
    }

    public Set<String> names() {
        return this.properties.keySet();
    }

    ImmutableSortedMap<String, Value<?>> properties() {
        return this.properties;
    }

    @Override
    Object fromPb(byte[] bytesPb) throws InvalidProtocolBufferException {
        Builder<?, ?> builder = this.emptyBuilder();
        builder.fill(DatastoreV1.Entity.parseFrom((byte[])bytesPb));
        return builder.build();
    }

    protected abstract Builder<?, ?> emptyBuilder();

    @Override
    final DatastoreV1.Entity toPb() {
        DatastoreV1.Entity.Builder entityPb = DatastoreV1.Entity.newBuilder();
        for (Map.Entry entry : this.properties.entrySet()) {
            DatastoreV1.Property.Builder propertyPb = DatastoreV1.Property.newBuilder();
            propertyPb.setName((String)entry.getKey());
            propertyPb.setValue(((Value)entry.getValue()).toPb());
            entityPb.addProperty(propertyPb.build());
        }
        if (this.key != null) {
            entityPb.setKey(((BaseKey)this.key).toPb());
        }
        return entityPb.build();
    }

    public static abstract class Builder<K extends IncompleteKey, B extends Builder<K, B>> {
        private K key;
        private final Map<String, Value<?>> properties = new HashMap();

        Builder() {
        }

        Builder(K key) {
            this.key(key);
        }

        Builder(BaseEntity<K> entity) {
            this(((BaseEntity)entity).key, entity);
        }

        Builder(K key, BaseEntity<?> entity) {
            this.key(key);
            this.properties((Map<String, Value<?>>)((BaseEntity)entity).properties);
        }

        protected K key() {
            return this.key;
        }

        protected Map<String, Value<?>> properties() {
            return this.properties;
        }

        private B self() {
            return (B)this;
        }

        B fill(DatastoreV1.Entity entityPb) {
            HashMap copiedProperties = Maps.newHashMap();
            for (DatastoreV1.Property property : entityPb.getPropertyList()) {
                copiedProperties.put(property.getName(), Value.fromPb(property.getValue()));
            }
            this.properties(copiedProperties);
            if (entityPb.hasKey()) {
                this.key(IncompleteKey.fromPb(entityPb.getKey()));
            }
            return this.self();
        }

        protected B properties(Map<String, Value<?>> properties) {
            this.properties.putAll(properties);
            return this.self();
        }

        public B key(K key) {
            this.key = key;
            return this.self();
        }

        public B clear() {
            this.properties.clear();
            return this.self();
        }

        public B remove(String name) {
            this.properties.remove(name);
            return this.self();
        }

        public B set(String name, Value<?> value) {
            this.properties.put(name, value);
            return this.self();
        }

        public B set(String name, String value) {
            this.properties.put(name, StringValue.of(value));
            return this.self();
        }

        public B set(String name, String first, String second, String ... others) {
            LinkedList<StringValue> values = new LinkedList<StringValue>();
            values.add(StringValue.of(first));
            values.add(StringValue.of(second));
            for (String other : others) {
                values.add(StringValue.of(other));
            }
            this.properties.put(name, ListValue.of(values));
            return this.self();
        }

        public B set(String name, long value) {
            this.properties.put(name, LongValue.of(value));
            return this.self();
        }

        public B set(String name, long first, long second, long ... others) {
            LinkedList<LongValue> values = new LinkedList<LongValue>();
            values.add(LongValue.of(first));
            values.add(LongValue.of(second));
            for (long other : others) {
                values.add(LongValue.of(other));
            }
            this.properties.put(name, ListValue.of(values));
            return this.self();
        }

        public B set(String name, double value) {
            this.properties.put(name, DoubleValue.of(value));
            return this.self();
        }

        public B set(String name, double first, double second, double ... others) {
            LinkedList<DoubleValue> values = new LinkedList<DoubleValue>();
            values.add(DoubleValue.of(first));
            values.add(DoubleValue.of(second));
            for (double other : others) {
                values.add(DoubleValue.of(other));
            }
            this.properties.put(name, ListValue.of(values));
            return this.self();
        }

        public B set(String name, boolean value) {
            this.properties.put(name, BooleanValue.of(value));
            return this.self();
        }

        public B set(String name, boolean first, boolean second, boolean ... others) {
            LinkedList<BooleanValue> values = new LinkedList<BooleanValue>();
            values.add(BooleanValue.of(first));
            values.add(BooleanValue.of(second));
            for (boolean other : others) {
                values.add(BooleanValue.of(other));
            }
            this.properties.put(name, ListValue.of(values));
            return this.self();
        }

        public B set(String name, DateTime value) {
            this.properties.put(name, DateTimeValue.of(value));
            return this.self();
        }

        public B set(String name, DateTime first, DateTime second, DateTime ... others) {
            LinkedList<DateTimeValue> values = new LinkedList<DateTimeValue>();
            values.add(DateTimeValue.of(first));
            values.add(DateTimeValue.of(second));
            for (DateTime other : others) {
                values.add(DateTimeValue.of(other));
            }
            this.properties.put(name, ListValue.of(values));
            return this.self();
        }

        public B set(String name, Key value) {
            this.properties.put(name, KeyValue.of(value));
            return this.self();
        }

        public B set(String name, Key first, Key second, Key ... others) {
            LinkedList<KeyValue> values = new LinkedList<KeyValue>();
            values.add(KeyValue.of(first));
            values.add(KeyValue.of(second));
            for (Key other : others) {
                values.add(KeyValue.of(other));
            }
            this.properties.put(name, ListValue.of(values));
            return this.self();
        }

        public B set(String name, FullEntity<?> value) {
            this.properties.put(name, EntityValue.of(value));
            return this.self();
        }

        public B set(String name, FullEntity<?> first, FullEntity<?> second, FullEntity<?> ... others) {
            LinkedList<EntityValue> values = new LinkedList<EntityValue>();
            values.add(EntityValue.of(first));
            values.add(EntityValue.of(second));
            for (FullEntity<?> other : others) {
                values.add(EntityValue.of(other));
            }
            this.properties.put(name, ListValue.of(values));
            return this.self();
        }

        public B set(String name, List<? extends Value<?>> values) {
            this.properties.put(name, ListValue.of(values));
            return this.self();
        }

        public B set(String name, Value<?> first, Value<?> second, Value<?> ... others) {
            this.properties.put(name, ListValue.builder().addValue(first, new Value[0]).addValue(second, others).build());
            return this.self();
        }

        public B set(String name, Blob value) {
            this.properties.put(name, BlobValue.of(value));
            return this.self();
        }

        public B set(String name, Blob first, Blob second, Blob ... others) {
            LinkedList<BlobValue> values = new LinkedList<BlobValue>();
            values.add(BlobValue.of(first));
            values.add(BlobValue.of(second));
            for (Blob other : others) {
                values.add(BlobValue.of(other));
            }
            this.properties.put(name, ListValue.of(values));
            return this.self();
        }

        public B setNull(String name) {
            this.properties.put(name, NullValue.of());
            return this.self();
        }

        public abstract BaseEntity<K> build();
    }
}

