/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.common.collect.ImmutableSet;
import com.google.gcloud.BaseServiceException;
import com.google.gcloud.RetryHelper;
import java.io.IOException;
import java.util.Set;

public class DatastoreException
extends BaseServiceException {
    private static final Set<BaseServiceException.Error> RETRYABLE_ERRORS = ImmutableSet.of((Object)new BaseServiceException.Error(Integer.valueOf(409), "ABORTED"), (Object)new BaseServiceException.Error(Integer.valueOf(403), "DEADLINE_EXCEEDED"), (Object)new BaseServiceException.Error(Integer.valueOf(503), "UNAVAILABLE"));
    private static final long serialVersionUID = 2663750991205874435L;

    public DatastoreException(int code, String message, String reason, Throwable cause) {
        super(code, message, reason, true, cause);
    }

    public DatastoreException(int code, String message, String reason) {
        super(code, message, reason, true);
    }

    public DatastoreException(IOException exception) {
        super(exception, true);
    }

    protected Set<BaseServiceException.Error> retryableErrors() {
        return RETRYABLE_ERRORS;
    }

    static DatastoreException translateAndThrow(RetryHelper.RetryHelperException ex) {
        BaseServiceException.translateAndPropagateIfPossible((RetryHelper.RetryHelperException)ex);
        throw new DatastoreException(0, ex.getMessage(), null);
    }

    static DatastoreException throwInvalidRequest(String massage, Object ... params) {
        throw new DatastoreException(0, String.format(massage, params), "FAILED_PRECONDITION");
    }

    static DatastoreException propagateUserException(Exception ex) {
        throw new DatastoreException(0, ex.getMessage(), null, ex);
    }
}

