/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.Preconditions;
import com.google.gcloud.datastore.BaseEntity;
import com.google.gcloud.datastore.FullEntity;
import com.google.gcloud.datastore.IncompleteKey;
import com.google.gcloud.datastore.Key;
import com.google.gcloud.datastore.Value;
import java.util.Map;

public final class Entity
extends FullEntity<Key> {
    private static final long serialVersionUID = 432961565733066915L;

    Entity(Builder builder) {
        super(builder);
    }

    Entity(FullEntity<Key> from) {
        super(from);
        Preconditions.checkArgument((from.key() != null ? 1 : 0) != 0);
    }

    @Override
    protected BaseEntity.Builder<Key, Builder> emptyBuilder() {
        return new Builder();
    }

    static Entity convert(FullEntity<Key> from) {
        if (from instanceof Entity) {
            return (Entity)from;
        }
        return new Entity(from);
    }

    public static Builder builder(Key key) {
        return new Builder(key);
    }

    public static Builder builder(Entity copyFrom) {
        return new Builder(copyFrom);
    }

    public static Builder builder(Key key, FullEntity<?> copyFrom) {
        return new Builder(key, copyFrom);
    }

    static Entity fromPb(DatastoreV1.Entity entityPb) {
        return ((Builder)new Builder().fill(entityPb)).build();
    }

    public static final class Builder
    extends BaseEntity.Builder<Key, Builder> {
        private Builder() {
        }

        private Builder(Key key) {
            super((IncompleteKey)Preconditions.checkNotNull((Object)key));
        }

        private Builder(Entity entity) {
            super(entity);
        }

        private Builder(Key key, FullEntity<?> entity) {
            this.properties((Map<String, Value<?>>)entity.properties());
            this.key(key);
        }

        @Override
        public Builder key(Key key) {
            super.key((IncompleteKey)Preconditions.checkNotNull((Object)key));
            return this;
        }

        public Entity build() {
            Preconditions.checkState((this.key() != null ? 1 : 0) != 0);
            return new Entity(this);
        }
    }
}

