/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.common.collect.ImmutableList;
import com.google.gcloud.datastore.BaseKey;
import com.google.gcloud.datastore.IncompleteKey;
import com.google.gcloud.datastore.Key;
import com.google.gcloud.datastore.PathElement;

public final class KeyFactory
extends BaseKey.Builder<KeyFactory> {
    private final String pi;
    private final String ns;

    public KeyFactory(String projectId) {
        this(projectId, null);
    }

    public KeyFactory(String projectId, String namespace) {
        super(projectId);
        this.namespace(namespace);
        this.pi = projectId;
        this.ns = namespace;
    }

    public IncompleteKey newKey() {
        ImmutableList path = ImmutableList.builder().addAll((Iterable)this.ancestors).add((Object)PathElement.of(this.kind)).build();
        return new IncompleteKey(this.projectId, this.namespace, (ImmutableList<PathElement>)path);
    }

    public Key newKey(String name) {
        ImmutableList path = ImmutableList.builder().addAll((Iterable)this.ancestors).add((Object)PathElement.of(this.kind, name)).build();
        return new Key(this.projectId, this.namespace, (ImmutableList<PathElement>)path);
    }

    public Key newKey(long id) {
        ImmutableList path = ImmutableList.builder().addAll((Iterable)this.ancestors).add((Object)PathElement.of(this.kind, id)).build();
        return new Key(this.projectId, this.namespace, (ImmutableList<PathElement>)path);
    }

    public KeyFactory reset() {
        this.projectId(this.pi);
        this.namespace(this.ns);
        this.kind = null;
        this.ancestors.clear();
        return this;
    }

    @Override
    protected IncompleteKey build() {
        return this.newKey();
    }
}

