/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.gcloud.datastore.Value;
import com.google.gcloud.datastore.ValueType;

public final class LongValue
extends Value<Long> {
    private static final long serialVersionUID = -8552854340400546861L;
    static final Value.BaseMarshaller<Long, LongValue, Builder> MARSHALLER = new Value.BaseMarshaller<Long, LongValue, Builder>(){
        private static final long serialVersionUID = 2137414214660959845L;

        @Override
        public int getProtoFieldId() {
            return 2;
        }

        @Override
        public Builder newBuilder(Long value) {
            return LongValue.builder(value);
        }

        @Override
        protected Long getValue(DatastoreV1.Value from) {
            return from.getIntegerValue();
        }

        @Override
        protected void setValue(LongValue from, DatastoreV1.Value.Builder to) {
            to.setIntegerValue(((Long)from.get()).longValue());
        }
    };

    public LongValue(long value) {
        this(LongValue.builder(value));
    }

    private LongValue(Builder builder) {
        super(builder);
    }

    public Builder toBuilder() {
        return (Builder)new Builder().mergeFrom(this);
    }

    public static LongValue of(long value) {
        return new LongValue(value);
    }

    public static Builder builder(long value) {
        return (Builder)new Builder().set((Object)value);
    }

    public static final class Builder
    extends Value.BaseBuilder<Long, LongValue, Builder> {
        private Builder() {
            super(ValueType.LONG);
        }

        @Override
        public LongValue build() {
            return new LongValue(this);
        }
    }
}

