/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.datastore;

import com.google.api.services.datastore.DatastoreV1;
import com.google.common.base.Preconditions;
import com.google.gcloud.datastore.NullValue;
import com.google.gcloud.datastore.RawValue;
import com.google.gcloud.datastore.Serializable;
import com.google.gcloud.datastore.ValueBuilder;
import com.google.gcloud.datastore.ValueMarshaller;
import com.google.gcloud.datastore.ValueType;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;
import java.util.Objects;

public abstract class Value<V>
extends Serializable<DatastoreV1.Value> {
    private static final long serialVersionUID = -1899638277588872742L;
    private final transient ValueType valueType;
    private final transient Boolean indexed;
    private final transient Integer meaning;
    private final transient V value;

    <P extends Value<V>, B extends BaseBuilder<V, P, B>> Value(ValueBuilder<V, P, B> builder) {
        this.valueType = builder.getValueType();
        this.indexed = builder.getIndexed();
        this.meaning = builder.getMeaning();
        this.value = builder.get();
    }

    public final ValueType type() {
        return this.valueType;
    }

    public final boolean hasIndexed() {
        return this.indexed != null;
    }

    public final Boolean indexed() {
        return this.indexed;
    }

    @Deprecated
    public final boolean hasMeaning() {
        return this.meaning != null;
    }

    @Deprecated
    public final Integer meaning() {
        return this.meaning;
    }

    public final V get() {
        return this.value;
    }

    public abstract ValueBuilder<?, ?, ?> toBuilder();

    public int hashCode() {
        return Objects.hash(new Object[]{this.valueType, this.indexed, this.meaning, this.value});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        Value other = (Value)obj;
        return Objects.equals((Object)this.valueType, (Object)other.valueType) && Objects.equals(this.indexed, other.indexed) && Objects.equals(this.meaning, other.meaning) && Objects.equals(this.value, other.value);
    }

    @Override
    DatastoreV1.Value toPb() {
        return this.type().getMarshaller().toProto(this);
    }

    static Value<?> fromPb(DatastoreV1.Value proto) {
        for (Map.Entry entry : proto.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor descriptor = (Descriptors.FieldDescriptor)entry.getKey();
            if (!descriptor.getName().endsWith("_value")) continue;
            ValueType valueType = ValueType.getByDescriptorId(descriptor.getNumber());
            if (valueType == null) {
                return RawValue.MARSHALLER.fromProto(proto).build();
            }
            return valueType.getMarshaller().fromProto(proto).build();
        }
        return NullValue.MARSHALLER.fromProto(proto).build();
    }

    @Override
    Object fromPb(byte[] bytesPb) throws InvalidProtocolBufferException {
        return Value.fromPb(DatastoreV1.Value.parseFrom((byte[])bytesPb));
    }

    static abstract class BaseBuilder<V, P extends Value<V>, B extends BaseBuilder<V, P, B>>
    implements ValueBuilder<V, P, B> {
        private final ValueType valueType;
        private Boolean indexed;
        private Integer meaning;
        private V value;

        BaseBuilder(ValueType valueType) {
            this.valueType = valueType;
        }

        @Override
        public ValueType getValueType() {
            return this.valueType;
        }

        @Override
        public B mergeFrom(P other) {
            this.indexed = ((Value)other).indexed();
            this.meaning = ((Value)other).meaning();
            this.set(((Value)other).get());
            return this.self();
        }

        @Override
        public Boolean getIndexed() {
            return this.indexed;
        }

        @Override
        public B indexed(boolean indexed) {
            this.indexed = indexed;
            return this.self();
        }

        @Override
        public Integer getMeaning() {
            return this.meaning;
        }

        @Override
        public B meaning(Integer meaning) {
            this.meaning = meaning;
            return this.self();
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public B set(V value) {
            this.value = Preconditions.checkNotNull(value);
            return this.self();
        }

        private B self() {
            return (B)this;
        }

        @Override
        public abstract P build();
    }

    static abstract class BaseMarshaller<V, P extends Value<V>, B extends ValueBuilder<V, P, B>>
    implements ValueMarshaller<V, P, B>,
    BuilderFactory<V, P, B> {
        private static final long serialVersionUID = 2880767488942992985L;

        BaseMarshaller() {
        }

        @Override
        public final B fromProto(DatastoreV1.Value proto) {
            Object builder = this.newBuilder(this.getValue(proto));
            if (proto.hasIndexed()) {
                builder.indexed(proto.getIndexed());
            }
            if (proto.hasMeaning()) {
                builder.meaning(proto.getMeaning());
            }
            return builder;
        }

        @Override
        public final DatastoreV1.Value toProto(P value) {
            DatastoreV1.Value.Builder builder = DatastoreV1.Value.newBuilder();
            if (((Value)value).hasIndexed()) {
                builder.setIndexed(((Value)value).indexed().booleanValue());
            }
            if (((Value)value).hasMeaning()) {
                builder.setMeaning(((Value)value).meaning().intValue());
            }
            this.setValue(value, builder);
            return builder.build();
        }

        protected abstract V getValue(DatastoreV1.Value var1);

        protected abstract void setValue(P var1, DatastoreV1.Value.Builder var2);
    }

    static interface BuilderFactory<V, P extends Value<V>, B extends ValueBuilder<V, P, B>>
    extends java.io.Serializable {
        public B newBuilder(V var1);
    }
}

