/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.resourcemanager;

import com.google.common.base.Preconditions;
import com.google.gcloud.resourcemanager.ProjectInfo;
import com.google.gcloud.resourcemanager.ResourceManager;

public class Project {
    private final ResourceManager resourceManager;
    private final ProjectInfo info;

    public Project(ResourceManager resourceManager, ProjectInfo projectInfo) {
        this.resourceManager = (ResourceManager)Preconditions.checkNotNull((Object)resourceManager);
        this.info = (ProjectInfo)Preconditions.checkNotNull((Object)projectInfo);
    }

    public static Project get(ResourceManager resourceManager, String projectId) {
        ProjectInfo projectInfo = resourceManager.get(projectId, new ResourceManager.ProjectGetOption[0]);
        return projectInfo != null ? new Project(resourceManager, projectInfo) : null;
    }

    public ProjectInfo info() {
        return this.info;
    }

    public ResourceManager resourceManager() {
        return this.resourceManager;
    }

    public Project reload() {
        return Project.get(this.resourceManager, this.info.projectId());
    }

    public void delete() {
        this.resourceManager.delete(this.info.projectId());
    }

    public void undelete() {
        this.resourceManager.undelete(this.info.projectId());
    }

    public Project replace(ProjectInfo projectInfo) {
        return new Project(this.resourceManager, this.resourceManager.replace((ProjectInfo)Preconditions.checkNotNull((Object)projectInfo)));
    }
}

