/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.resourcemanager;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.gcloud.Page;
import com.google.gcloud.Service;
import com.google.gcloud.resourcemanager.Option;
import com.google.gcloud.resourcemanager.ProjectInfo;
import com.google.gcloud.resourcemanager.ResourceManagerOptions;
import com.google.gcloud.spi.ResourceManagerRpc;
import java.util.HashSet;

public interface ResourceManager
extends Service<ResourceManagerOptions> {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";

    public ProjectInfo create(ProjectInfo var1);

    public void delete(String var1);

    public ProjectInfo get(String var1, ProjectGetOption ... var2);

    public Page<ProjectInfo> list(ProjectListOption ... var1);

    public ProjectInfo replace(ProjectInfo var1);

    public void undelete(String var1);

    public static class ProjectListOption
    extends Option {
        private static final long serialVersionUID = 7888768979702012328L;

        private ProjectListOption(ResourceManagerRpc.Option option, Object value) {
            super(option, value);
        }

        public static ProjectListOption filter(String filter) {
            return new ProjectListOption(ResourceManagerRpc.Option.FILTER, filter);
        }

        public static ProjectListOption pageToken(String pageToken) {
            return new ProjectListOption(ResourceManagerRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static ProjectListOption pageSize(int pageSize) {
            return new ProjectListOption(ResourceManagerRpc.Option.PAGE_SIZE, pageSize);
        }

        public static ProjectListOption fields(ProjectField ... fields) {
            StringBuilder builder = new StringBuilder();
            builder.append("projects(").append(ProjectField.selector(fields)).append(")");
            return new ProjectListOption(ResourceManagerRpc.Option.FIELDS, builder.toString());
        }
    }

    public static class ProjectGetOption
    extends Option {
        private static final long serialVersionUID = 270185129961146874L;

        private ProjectGetOption(ResourceManagerRpc.Option option, Object value) {
            super(option, value);
        }

        public static ProjectGetOption fields(ProjectField ... fields) {
            return new ProjectGetOption(ResourceManagerRpc.Option.FIELDS, ProjectField.selector(fields));
        }
    }

    public static enum ProjectField {
        PROJECT_ID("projectId"),
        NAME("name"),
        LABELS("labels"),
        PROJECT_NUMBER("projectNumber"),
        STATE("lifecycleState"),
        CREATE_TIME("createTime");

        private final String selector;

        private ProjectField(String selector) {
            this.selector = selector;
        }

        public String selector() {
            return this.selector;
        }

        static String selector(ProjectField ... fields) {
            HashSet fieldStrings = Sets.newHashSetWithExpectedSize((int)(fields.length + 1));
            fieldStrings.add(PROJECT_ID.selector());
            for (ProjectField field : fields) {
                fieldStrings.add(field.selector());
            }
            return Joiner.on((char)',').join((Iterable)fieldStrings);
        }
    }
}

