/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.resourcemanager;

import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gcloud.BaseService;
import com.google.gcloud.ExceptionHandler;
import com.google.gcloud.Page;
import com.google.gcloud.PageImpl;
import com.google.gcloud.RetryHelper;
import com.google.gcloud.RetryParams;
import com.google.gcloud.ServiceOptions;
import com.google.gcloud.resourcemanager.Option;
import com.google.gcloud.resourcemanager.ProjectInfo;
import com.google.gcloud.resourcemanager.ResourceManager;
import com.google.gcloud.resourcemanager.ResourceManagerException;
import com.google.gcloud.resourcemanager.ResourceManagerOptions;
import com.google.gcloud.spi.ResourceManagerRpc;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.Callable;

final class ResourceManagerImpl
extends BaseService<ResourceManagerOptions>
implements ResourceManager {
    private final ResourceManagerRpc resourceManagerRpc;

    ResourceManagerImpl(ResourceManagerOptions options) {
        super((ServiceOptions)options);
        this.resourceManagerRpc = (ResourceManagerRpc)options.rpc();
    }

    @Override
    public ProjectInfo create(final ProjectInfo project) {
        try {
            return ProjectInfo.fromPb((Project)RetryHelper.runWithRetries((Callable)new Callable<Project>(){

                @Override
                public Project call() {
                    return ResourceManagerImpl.this.resourceManagerRpc.create(project.toPb());
                }
            }, (RetryParams)((ResourceManagerOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ResourceManagerException.translateAndThrow(e);
        }
    }

    @Override
    public void delete(final String projectId) {
        try {
            RetryHelper.runWithRetries((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    ResourceManagerImpl.this.resourceManagerRpc.delete(projectId);
                    return null;
                }
            }, (RetryParams)((ResourceManagerOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ResourceManagerException.translateAndThrow(e);
        }
    }

    @Override
    public ProjectInfo get(final String projectId, ResourceManager.ProjectGetOption ... options) {
        final Map<ResourceManagerRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            Project answer = (Project)RetryHelper.runWithRetries((Callable)new Callable<Project>(){

                @Override
                public Project call() {
                    return ResourceManagerImpl.this.resourceManagerRpc.get(projectId, optionsMap);
                }
            }, (RetryParams)((ResourceManagerOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
            return answer == null ? null : ProjectInfo.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ResourceManagerException.translateAndThrow(e);
        }
    }

    @Override
    public Page<ProjectInfo> list(ResourceManager.ProjectListOption ... options) {
        return ResourceManagerImpl.listProjects((ResourceManagerOptions)this.options(), this.optionMap(options));
    }

    private static Page<ProjectInfo> listProjects(final ResourceManagerOptions serviceOptions, final Map<ResourceManagerRpc.Option, ?> optionsMap) {
        try {
            ResourceManagerRpc.Tuple result = (ResourceManagerRpc.Tuple)RetryHelper.runWithRetries((Callable)new Callable<ResourceManagerRpc.Tuple<String, Iterable<Project>>>(){

                @Override
                public ResourceManagerRpc.Tuple<String, Iterable<Project>> call() {
                    return ((ResourceManagerRpc)serviceOptions.rpc()).list(optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
            String cursor = (String)result.x();
            ImmutableList projects = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<Project, ProjectInfo>(){

                public ProjectInfo apply(Project projectPb) {
                    return ProjectInfo.fromPb(projectPb);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new ProjectPageFetcher(serviceOptions, cursor, optionsMap), cursor, (Iterable)projects);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ResourceManagerException.translateAndThrow(e);
        }
    }

    @Override
    public ProjectInfo replace(final ProjectInfo newProject) {
        try {
            return ProjectInfo.fromPb((Project)RetryHelper.runWithRetries((Callable)new Callable<Project>(){

                @Override
                public Project call() {
                    return ResourceManagerImpl.this.resourceManagerRpc.replace(newProject.toPb());
                }
            }, (RetryParams)((ResourceManagerOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ResourceManagerException.translateAndThrow(e);
        }
    }

    @Override
    public void undelete(final String projectId) {
        try {
            RetryHelper.runWithRetries((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    ResourceManagerImpl.this.resourceManagerRpc.undelete(projectId);
                    return null;
                }
            }, (RetryParams)((ResourceManagerOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw ResourceManagerException.translateAndThrow(e);
        }
    }

    private Map<ResourceManagerRpc.Option, ?> optionMap(Option ... options) {
        EnumMap temp = Maps.newEnumMap(ResourceManagerRpc.Option.class);
        for (Option option : options) {
            Object prev = temp.put(option.rpcOption(), option.value());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object[])new Object[]{option});
        }
        return ImmutableMap.copyOf((Map)temp);
    }

    private static class ProjectPageFetcher
    implements PageImpl.NextPageFetcher<ProjectInfo> {
        private static final long serialVersionUID = 2158209410430566961L;
        private final Map<ResourceManagerRpc.Option, ?> requestOptions;
        private final ResourceManagerOptions serviceOptions;

        ProjectPageFetcher(ResourceManagerOptions serviceOptions, String cursor, Map<ResourceManagerRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)ResourceManagerRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<ProjectInfo> nextPage() {
            return ResourceManagerImpl.listProjects(this.serviceOptions, this.requestOptions);
        }
    }
}

