/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.resourcemanager;

import com.google.common.collect.ImmutableSet;
import com.google.gcloud.ServiceOptions;
import com.google.gcloud.resourcemanager.ResourceManager;
import com.google.gcloud.resourcemanager.ResourceManagerFactory;
import com.google.gcloud.resourcemanager.ResourceManagerImpl;
import com.google.gcloud.spi.DefaultResourceManagerRpc;
import com.google.gcloud.spi.ResourceManagerRpc;
import com.google.gcloud.spi.ResourceManagerRpcFactory;
import java.util.Set;

public class ResourceManagerOptions
extends ServiceOptions<ResourceManager, ResourceManagerRpc, ResourceManagerOptions> {
    private static final long serialVersionUID = 538303101192527452L;
    private static final String GCRM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/cloud-platform");
    private static final String DEFAULT_HOST = "https://cloudresourcemanager.googleapis.com";

    public static ResourceManagerOptions defaultInstance() {
        return ResourceManagerOptions.builder().build();
    }

    protected String defaultHost() {
        return DEFAULT_HOST;
    }

    private ResourceManagerOptions(Builder builder) {
        super(ResourceManagerFactory.class, ResourceManagerRpcFactory.class, (ServiceOptions.Builder)builder);
    }

    protected boolean projectIdRequired() {
        return false;
    }

    protected ResourceManagerFactory defaultServiceFactory() {
        return DefaultResourceManagerFactory.INSTANCE;
    }

    protected ResourceManagerRpcFactory defaultRpcFactory() {
        return DefaultResourceManagerRpcFactory.INSTANCE;
    }

    protected Set<String> scopes() {
        return SCOPES;
    }

    public boolean equals(Object obj) {
        return obj instanceof ResourceManagerOptions && this.baseEquals((ResourceManagerOptions)((Object)obj));
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceOptions.Builder<ResourceManager, ResourceManagerRpc, ResourceManagerOptions, Builder> {
        private Builder() {
        }

        private Builder(ResourceManagerOptions options) {
            super((ServiceOptions)options);
        }

        public ResourceManagerOptions build() {
            return new ResourceManagerOptions(this);
        }
    }

    public static class DefaultResourceManagerRpcFactory
    implements ResourceManagerRpcFactory {
        private static final ResourceManagerRpcFactory INSTANCE = new DefaultResourceManagerRpcFactory();

        public ResourceManagerRpc create(ResourceManagerOptions options) {
            return new DefaultResourceManagerRpc(options);
        }
    }

    public static class DefaultResourceManagerFactory
    implements ResourceManagerFactory {
        private static final ResourceManagerFactory INSTANCE = new DefaultResourceManagerFactory();

        public ResourceManager create(ResourceManagerOptions options) {
            return new ResourceManagerImpl(options);
        }
    }
}

