/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.spi;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.cloudresourcemanager.Cloudresourcemanager;
import com.google.api.services.cloudresourcemanager.model.ListProjectsResponse;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.gcloud.resourcemanager.ResourceManagerException;
import com.google.gcloud.resourcemanager.ResourceManagerOptions;
import com.google.gcloud.spi.ResourceManagerRpc;
import java.io.IOException;
import java.util.Map;

public class DefaultResourceManagerRpc
implements ResourceManagerRpc {
    private final Cloudresourcemanager resourceManager;

    public DefaultResourceManagerRpc(ResourceManagerOptions options) {
        HttpTransport transport = options.httpTransportFactory().create();
        HttpRequestInitializer initializer = options.httpRequestInitializer();
        this.resourceManager = new Cloudresourcemanager.Builder(transport, (JsonFactory)new JacksonFactory(), initializer).setRootUrl(options.host()).setApplicationName(options.applicationName()).build();
    }

    private static ResourceManagerException translate(IOException exception) {
        return new ResourceManagerException(exception);
    }

    @Override
    public Project create(Project project) throws ResourceManagerException {
        try {
            return (Project)this.resourceManager.projects().create(project).execute();
        }
        catch (IOException ex) {
            throw DefaultResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public void delete(String projectId) throws ResourceManagerException {
        try {
            this.resourceManager.projects().delete(projectId).execute();
        }
        catch (IOException ex) {
            throw DefaultResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public Project get(String projectId, Map<ResourceManagerRpc.Option, ?> options) throws ResourceManagerException {
        try {
            return (Project)this.resourceManager.projects().get(projectId).setFields(ResourceManagerRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            ResourceManagerException translated = DefaultResourceManagerRpc.translate(ex);
            if (translated.code() == 403 || translated.code() == 404) {
                return null;
            }
            throw translated;
        }
    }

    @Override
    public ResourceManagerRpc.Tuple<String, Iterable<Project>> list(Map<ResourceManagerRpc.Option, ?> options) throws ResourceManagerException {
        try {
            ListProjectsResponse response = (ListProjectsResponse)this.resourceManager.projects().list().setFields(ResourceManagerRpc.Option.FIELDS.getString(options)).setFilter(ResourceManagerRpc.Option.FILTER.getString(options)).setPageSize(ResourceManagerRpc.Option.PAGE_SIZE.getInt(options)).setPageToken(ResourceManagerRpc.Option.PAGE_TOKEN.getString(options)).execute();
            return ResourceManagerRpc.Tuple.of(response.getNextPageToken(), response.getProjects());
        }
        catch (IOException ex) {
            throw DefaultResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public void undelete(String projectId) throws ResourceManagerException {
        try {
            this.resourceManager.projects().undelete(projectId).execute();
        }
        catch (IOException ex) {
            throw DefaultResourceManagerRpc.translate(ex);
        }
    }

    @Override
    public Project replace(Project project) throws ResourceManagerException {
        try {
            return (Project)this.resourceManager.projects().update(project.getProjectId(), project).execute();
        }
        catch (IOException ex) {
            throw DefaultResourceManagerRpc.translate(ex);
        }
    }
}

