/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.spi;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.Buckets;
import com.google.api.services.storage.model.ComposeRequest;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.RewriteResponse;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gcloud.spi.StorageRpc;
import com.google.gcloud.storage.StorageException;
import com.google.gcloud.storage.StorageOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class DefaultStorageRpc
implements StorageRpc {
    public static final String DEFAULT_PROJECTION = "full";
    private final StorageOptions options;
    private final Storage storage;
    private static final long MEGABYTE = 0x100000L;
    private static final int MAX_BATCH_DELETES = 100;

    public DefaultStorageRpc(StorageOptions options) {
        HttpTransport transport = options.httpTransportFactory().create();
        HttpRequestInitializer initializer = options.httpRequestInitializer();
        this.options = options;
        this.storage = new Storage.Builder(transport, (JsonFactory)new JacksonFactory(), initializer).setRootUrl(options.host()).setApplicationName(options.applicationName()).build();
    }

    private static StorageException translate(IOException exception) {
        return new StorageException(exception);
    }

    private static StorageException translate(GoogleJsonError exception) {
        return new StorageException(exception);
    }

    @Override
    public Bucket create(Bucket bucket, Map<StorageRpc.Option, ?> options) throws StorageException {
        try {
            return (Bucket)this.storage.buckets().insert(this.options.projectId(), bucket).setProjection(DEFAULT_PROJECTION).setPredefinedAcl(StorageRpc.Option.PREDEFINED_ACL.getString(options)).setPredefinedDefaultObjectAcl(StorageRpc.Option.PREDEFINED_DEFAULT_OBJECT_ACL.getString(options)).execute();
        }
        catch (IOException ex) {
            throw DefaultStorageRpc.translate(ex);
        }
    }

    @Override
    public StorageObject create(StorageObject storageObject, InputStream content, Map<StorageRpc.Option, ?> options) throws StorageException {
        try {
            Storage.Objects.Insert insert = this.storage.objects().insert(storageObject.getBucket(), storageObject, (AbstractInputStreamContent)new InputStreamContent(storageObject.getContentType(), content));
            insert.getMediaHttpUploader().setDirectUploadEnabled(true);
            return (StorageObject)insert.setProjection(DEFAULT_PROJECTION).setPredefinedAcl(StorageRpc.Option.PREDEFINED_ACL.getString(options)).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).execute();
        }
        catch (IOException ex) {
            throw DefaultStorageRpc.translate(ex);
        }
    }

    @Override
    public StorageRpc.Tuple<String, Iterable<Bucket>> list(Map<StorageRpc.Option, ?> options) {
        try {
            Buckets buckets = (Buckets)this.storage.buckets().list(this.options.projectId()).setProjection(DEFAULT_PROJECTION).setPrefix(StorageRpc.Option.PREFIX.getString(options)).setMaxResults(StorageRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(StorageRpc.Option.PAGE_TOKEN.getString(options)).setFields(StorageRpc.Option.FIELDS.getString(options)).execute();
            return StorageRpc.Tuple.of(buckets.getNextPageToken(), buckets.getItems());
        }
        catch (IOException ex) {
            throw DefaultStorageRpc.translate(ex);
        }
    }

    @Override
    public StorageRpc.Tuple<String, Iterable<StorageObject>> list(String bucket, Map<StorageRpc.Option, ?> options) {
        try {
            Objects objects = (Objects)this.storage.objects().list(bucket).setProjection(DEFAULT_PROJECTION).setVersions(StorageRpc.Option.VERSIONS.getBoolean(options)).setDelimiter(StorageRpc.Option.DELIMITER.getString(options)).setPrefix(StorageRpc.Option.PREFIX.getString(options)).setMaxResults(StorageRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(StorageRpc.Option.PAGE_TOKEN.getString(options)).setFields(StorageRpc.Option.FIELDS.getString(options)).execute();
            return StorageRpc.Tuple.of(objects.getNextPageToken(), objects.getItems());
        }
        catch (IOException ex) {
            throw DefaultStorageRpc.translate(ex);
        }
    }

    @Override
    public Bucket get(Bucket bucket, Map<StorageRpc.Option, ?> options) {
        try {
            return (Bucket)this.storage.buckets().get(bucket.getName()).setProjection(DEFAULT_PROJECTION).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setFields(StorageRpc.Option.FIELDS.getString(options)).execute();
        }
        catch (IOException ex) {
            StorageException serviceException = DefaultStorageRpc.translate(ex);
            if (serviceException.code() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @Override
    public StorageObject get(StorageObject object, Map<StorageRpc.Option, ?> options) {
        try {
            return (StorageObject)this.getRequest(object, options).execute();
        }
        catch (IOException ex) {
            StorageException serviceException = DefaultStorageRpc.translate(ex);
            if (serviceException.code() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    private Storage.Objects.Get getRequest(StorageObject object, Map<StorageRpc.Option, ?> options) throws IOException {
        return this.storage.objects().get(object.getBucket(), object.getName()).setGeneration(object.getGeneration()).setProjection(DEFAULT_PROJECTION).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options)).setFields(StorageRpc.Option.FIELDS.getString(options));
    }

    @Override
    public Bucket patch(Bucket bucket, Map<StorageRpc.Option, ?> options) {
        try {
            return (Bucket)this.storage.buckets().patch(bucket.getName(), bucket).setProjection(DEFAULT_PROJECTION).setPredefinedAcl(StorageRpc.Option.PREDEFINED_ACL.getString(options)).setPredefinedDefaultObjectAcl(StorageRpc.Option.PREDEFINED_DEFAULT_OBJECT_ACL.getString(options)).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).execute();
        }
        catch (IOException ex) {
            throw DefaultStorageRpc.translate(ex);
        }
    }

    @Override
    public StorageObject patch(StorageObject storageObject, Map<StorageRpc.Option, ?> options) {
        try {
            return (StorageObject)this.patchRequest(storageObject, options).execute();
        }
        catch (IOException ex) {
            throw DefaultStorageRpc.translate(ex);
        }
    }

    private Storage.Objects.Patch patchRequest(StorageObject storageObject, Map<StorageRpc.Option, ?> options) throws IOException {
        return this.storage.objects().patch(storageObject.getBucket(), storageObject.getName(), storageObject).setProjection(DEFAULT_PROJECTION).setPredefinedAcl(StorageRpc.Option.PREDEFINED_ACL.getString(options)).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options));
    }

    @Override
    public boolean delete(Bucket bucket, Map<StorageRpc.Option, ?> options) {
        try {
            this.storage.buckets().delete(bucket.getName()).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).execute();
            return true;
        }
        catch (IOException ex) {
            StorageException serviceException = DefaultStorageRpc.translate(ex);
            if (serviceException.code() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    @Override
    public boolean delete(StorageObject blob, Map<StorageRpc.Option, ?> options) {
        try {
            this.deleteRequest(blob, options).execute();
            return true;
        }
        catch (IOException ex) {
            StorageException serviceException = DefaultStorageRpc.translate(ex);
            if (serviceException.code() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    private Storage.Objects.Delete deleteRequest(StorageObject blob, Map<StorageRpc.Option, ?> options) throws IOException {
        return this.storage.objects().delete(blob.getBucket(), blob.getName()).setGeneration(blob.getGeneration()).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options));
    }

    @Override
    public StorageObject compose(Iterable<StorageObject> sources, StorageObject target, Map<StorageRpc.Option, ?> targetOptions) throws StorageException {
        ComposeRequest request = new ComposeRequest();
        if (target.getContentType() == null) {
            target.setContentType("application/octet-stream");
        }
        request.setDestination(target);
        ArrayList<ComposeRequest.SourceObjects> sourceObjects = new ArrayList<ComposeRequest.SourceObjects>();
        for (StorageObject source : sources) {
            ComposeRequest.SourceObjects sourceObject = new ComposeRequest.SourceObjects();
            sourceObject.setName(source.getName());
            Long generation = source.getGeneration();
            if (generation != null) {
                sourceObject.setGeneration(generation);
                sourceObject.setObjectPreconditions(new ComposeRequest.SourceObjects.ObjectPreconditions().setIfGenerationMatch(generation));
            }
            sourceObjects.add(sourceObject);
        }
        request.setSourceObjects(sourceObjects);
        try {
            return (StorageObject)this.storage.objects().compose(target.getBucket(), target.getName(), request).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(targetOptions)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(targetOptions)).execute();
        }
        catch (IOException ex) {
            throw DefaultStorageRpc.translate(ex);
        }
    }

    @Override
    public byte[] load(StorageObject from, Map<StorageRpc.Option, ?> options) throws StorageException {
        try {
            Storage.Objects.Get getRequest = this.storage.objects().get(from.getBucket(), from.getName()).setGeneration(from.getGeneration()).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            getRequest.getMediaHttpDownloader().setDirectDownloadEnabled(true);
            getRequest.executeMediaAndDownloadTo((OutputStream)out);
            return out.toByteArray();
        }
        catch (IOException ex) {
            throw DefaultStorageRpc.translate(ex);
        }
    }

    @Override
    public StorageRpc.BatchResponse batch(StorageRpc.BatchRequest request) throws StorageException {
        List partitionedToDelete = Lists.partition(request.toDelete, (int)100);
        Iterator iterator = partitionedToDelete.iterator();
        StorageRpc.BatchRequest chunkRequest = new StorageRpc.BatchRequest(iterator.hasNext() ? (List)iterator.next() : ImmutableList.of(), request.toUpdate, request.toGet);
        StorageRpc.BatchResponse response = this.batchChunk(chunkRequest);
        HashMap deletes = Maps.newHashMapWithExpectedSize((int)request.toDelete.size());
        deletes.putAll(response.deletes);
        while (iterator.hasNext()) {
            chunkRequest = new StorageRpc.BatchRequest((Iterable)iterator.next(), null, null);
            StorageRpc.BatchResponse deleteBatchResponse = this.batchChunk(chunkRequest);
            deletes.putAll(deleteBatchResponse.deletes);
        }
        return new StorageRpc.BatchResponse(deletes, response.updates, response.gets);
    }

    private StorageRpc.BatchResponse batchChunk(StorageRpc.BatchRequest request) {
        BatchRequest batch = this.storage.batch();
        final ConcurrentMap deletes = Maps.newConcurrentMap();
        final ConcurrentMap updates = Maps.newConcurrentMap();
        final ConcurrentMap gets = Maps.newConcurrentMap();
        try {
            for (final StorageRpc.Tuple<StorageObject, Map<StorageRpc.Option, ?>> tuple : request.toDelete) {
                this.deleteRequest(tuple.x(), tuple.y()).queue(batch, (JsonBatchCallback)new JsonBatchCallback<Void>(){

                    public void onSuccess(Void ignore, HttpHeaders responseHeaders) {
                        deletes.put(tuple.x(), StorageRpc.Tuple.of(Boolean.TRUE, null));
                    }

                    public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
                        if (e.getCode() == 404) {
                            deletes.put(tuple.x(), StorageRpc.Tuple.of(Boolean.FALSE, null));
                        } else {
                            deletes.put(tuple.x(), StorageRpc.Tuple.of(null, DefaultStorageRpc.translate(e)));
                        }
                    }
                });
            }
            for (final StorageRpc.Tuple<StorageObject, Map<StorageRpc.Option, ?>> tuple : request.toUpdate) {
                this.patchRequest(tuple.x(), tuple.y()).queue(batch, (JsonBatchCallback)new JsonBatchCallback<StorageObject>(){

                    public void onSuccess(StorageObject storageObject, HttpHeaders responseHeaders) {
                        updates.put(tuple.x(), StorageRpc.Tuple.of(storageObject, null));
                    }

                    public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
                        updates.put(tuple.x(), StorageRpc.Tuple.of(null, DefaultStorageRpc.translate(e)));
                    }
                });
            }
            for (final StorageRpc.Tuple<StorageObject, Map<StorageRpc.Option, ?>> tuple : request.toGet) {
                this.getRequest(tuple.x(), tuple.y()).queue(batch, (JsonBatchCallback)new JsonBatchCallback<StorageObject>(){

                    public void onSuccess(StorageObject storageObject, HttpHeaders responseHeaders) {
                        gets.put(tuple.x(), StorageRpc.Tuple.of(storageObject, null));
                    }

                    public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
                        if (e.getCode() == 404) {
                            gets.put(tuple.x(), StorageRpc.Tuple.of(null, null));
                        } else {
                            gets.put(tuple.x(), StorageRpc.Tuple.of(null, DefaultStorageRpc.translate(e)));
                        }
                    }
                });
            }
            batch.execute();
        }
        catch (IOException ex) {
            throw DefaultStorageRpc.translate(ex);
        }
        return new StorageRpc.BatchResponse(deletes, updates, gets);
    }

    @Override
    public StorageRpc.Tuple<String, byte[]> read(StorageObject from, Map<StorageRpc.Option, ?> options, long position, int bytes) throws StorageException {
        try {
            Storage.Objects.Get req = this.storage.objects().get(from.getBucket(), from.getName()).setGeneration(from.getGeneration()).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(options)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(options)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(options)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(options));
            StringBuilder range = new StringBuilder();
            range.append("bytes=").append(position).append("-").append(position + (long)bytes - 1L);
            req.getRequestHeaders().setRange(range.toString());
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            req.executeMedia().download((OutputStream)output);
            String etag = req.getLastResponseHeaders().getETag();
            return StorageRpc.Tuple.of(etag, output.toByteArray());
        }
        catch (IOException ex) {
            throw DefaultStorageRpc.translate(ex);
        }
    }

    @Override
    public void write(String uploadId, byte[] toWrite, int toWriteOffset, long destOffset, int length, boolean last) throws StorageException {
        try {
            String message;
            int code;
            GenericUrl url = new GenericUrl(uploadId);
            HttpRequest httpRequest = this.storage.getRequestFactory().buildPutRequest(url, (HttpContent)new ByteArrayContent(null, toWrite, toWriteOffset, length));
            long limit = destOffset + (long)length;
            StringBuilder range = new StringBuilder("bytes ");
            range.append(destOffset).append('-').append(limit - 1L).append('/');
            if (last) {
                range.append(limit);
            } else {
                range.append('*');
            }
            httpRequest.getHeaders().setContentRange(range.toString());
            HttpResponseException exception = null;
            try {
                HttpResponse response = httpRequest.execute();
                code = response.getStatusCode();
                message = response.getStatusMessage();
            }
            catch (HttpResponseException ex) {
                exception = ex;
                code = ex.getStatusCode();
                message = ex.getStatusMessage();
            }
            if (!last && code != 308 || last && code != 200 && code != 201) {
                if (exception != null) {
                    throw exception;
                }
                GoogleJsonError error = new GoogleJsonError();
                error.setCode(code);
                error.setMessage(message);
                throw DefaultStorageRpc.translate(error);
            }
        }
        catch (IOException ex) {
            throw DefaultStorageRpc.translate(ex);
        }
    }

    @Override
    public String open(StorageObject object, Map<StorageRpc.Option, ?> options) throws StorageException {
        try {
            Storage.Objects.Insert req = this.storage.objects().insert(object.getBucket(), object);
            GenericUrl url = req.buildHttpRequest().getUrl();
            String scheme = url.getScheme();
            String host = url.getHost();
            String path = "/upload" + url.getRawPath();
            url = new GenericUrl(scheme + "://" + host + path);
            url.set("uploadType", (Object)"resumable");
            url.set("name", (Object)object.getName());
            for (StorageRpc.Option option : options.keySet()) {
                Object content = option.get(options);
                if (content == null) continue;
                url.set(option.value(), (Object)content.toString());
            }
            JsonFactory jsonFactory = this.storage.getJsonFactory();
            HttpRequestFactory requestFactory = this.storage.getRequestFactory();
            HttpRequest httpRequest = requestFactory.buildPostRequest(url, (HttpContent)new JsonHttpContent(jsonFactory, (Object)object));
            httpRequest.getHeaders().set("X-Upload-Content-Type", MoreObjects.firstNonNull((Object)object.getContentType(), (Object)"application/octet-stream"));
            HttpResponse response = httpRequest.execute();
            if (response.getStatusCode() != 200) {
                GoogleJsonError error = new GoogleJsonError();
                error.setCode(response.getStatusCode());
                error.setMessage(response.getStatusMessage());
                throw DefaultStorageRpc.translate(error);
            }
            return response.getHeaders().getLocation();
        }
        catch (IOException ex) {
            throw DefaultStorageRpc.translate(ex);
        }
    }

    @Override
    public StorageRpc.RewriteResponse openRewrite(StorageRpc.RewriteRequest rewriteRequest) throws StorageException {
        return this.rewrite(rewriteRequest, null);
    }

    @Override
    public StorageRpc.RewriteResponse continueRewrite(StorageRpc.RewriteResponse previousResponse) throws StorageException {
        return this.rewrite(previousResponse.rewriteRequest, previousResponse.rewriteToken);
    }

    private StorageRpc.RewriteResponse rewrite(StorageRpc.RewriteRequest req, String token) throws StorageException {
        try {
            Long maxBytesRewrittenPerCall = req.megabytesRewrittenPerCall != null ? Long.valueOf(req.megabytesRewrittenPerCall * 0x100000L) : null;
            RewriteResponse rewriteResponse = (RewriteResponse)this.storage.objects().rewrite(req.source.getBucket(), req.source.getName(), req.target.getBucket(), req.target.getName(), req.target.getContentType() != null ? req.target : null).setSourceGeneration(req.source.getGeneration()).setRewriteToken(token).setMaxBytesRewrittenPerCall(maxBytesRewrittenPerCall).setProjection(DEFAULT_PROJECTION).setIfSourceMetagenerationMatch(StorageRpc.Option.IF_SOURCE_METAGENERATION_MATCH.getLong(req.sourceOptions)).setIfSourceMetagenerationNotMatch(StorageRpc.Option.IF_SOURCE_METAGENERATION_NOT_MATCH.getLong(req.sourceOptions)).setIfSourceGenerationMatch(StorageRpc.Option.IF_SOURCE_GENERATION_MATCH.getLong(req.sourceOptions)).setIfSourceGenerationNotMatch(StorageRpc.Option.IF_SOURCE_GENERATION_NOT_MATCH.getLong(req.sourceOptions)).setIfMetagenerationMatch(StorageRpc.Option.IF_METAGENERATION_MATCH.getLong(req.targetOptions)).setIfMetagenerationNotMatch(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH.getLong(req.targetOptions)).setIfGenerationMatch(StorageRpc.Option.IF_GENERATION_MATCH.getLong(req.targetOptions)).setIfGenerationNotMatch(StorageRpc.Option.IF_GENERATION_NOT_MATCH.getLong(req.targetOptions)).execute();
            return new StorageRpc.RewriteResponse(req, rewriteResponse.getResource(), rewriteResponse.getObjectSize().longValue(), rewriteResponse.getDone(), rewriteResponse.getRewriteToken(), rewriteResponse.getTotalBytesRewritten().longValue());
        }
        catch (IOException ex) {
            throw DefaultStorageRpc.translate(ex);
        }
    }
}

