/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gcloud.storage.BlobId;
import com.google.gcloud.storage.BlobInfo;
import com.google.gcloud.storage.Storage;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class BatchRequest
implements Serializable {
    private static final long serialVersionUID = -1527992265939800345L;
    private final Map<BlobId, Iterable<Storage.BlobSourceOption>> toDelete;
    private final Map<BlobInfo, Iterable<Storage.BlobTargetOption>> toUpdate;
    private final Map<BlobId, Iterable<Storage.BlobGetOption>> toGet;

    private BatchRequest(Builder builder) {
        this.toDelete = ImmutableMap.copyOf((Map)builder.toDelete);
        this.toUpdate = ImmutableMap.copyOf((Map)builder.toUpdate);
        this.toGet = ImmutableMap.copyOf((Map)builder.toGet);
    }

    public int hashCode() {
        return Objects.hash(this.toDelete, this.toUpdate, this.toGet);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BatchRequest)) {
            return false;
        }
        BatchRequest other = (BatchRequest)obj;
        return Objects.equals(this.toDelete, other.toDelete) && Objects.equals(this.toUpdate, other.toUpdate) && Objects.equals(this.toGet, other.toGet);
    }

    public Map<BlobId, Iterable<Storage.BlobSourceOption>> toDelete() {
        return this.toDelete;
    }

    public Map<BlobInfo, Iterable<Storage.BlobTargetOption>> toUpdate() {
        return this.toUpdate;
    }

    public Map<BlobId, Iterable<Storage.BlobGetOption>> toGet() {
        return this.toGet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<BlobId, Iterable<Storage.BlobSourceOption>> toDelete = new LinkedHashMap<BlobId, Iterable<Storage.BlobSourceOption>>();
        private Map<BlobInfo, Iterable<Storage.BlobTargetOption>> toUpdate = new LinkedHashMap<BlobInfo, Iterable<Storage.BlobTargetOption>>();
        private Map<BlobId, Iterable<Storage.BlobGetOption>> toGet = new LinkedHashMap<BlobId, Iterable<Storage.BlobGetOption>>();

        private Builder() {
        }

        public Builder delete(String bucket, String blob, Storage.BlobSourceOption ... options) {
            this.toDelete.put(BlobId.of(bucket, blob), Lists.newArrayList((Object[])options));
            return this;
        }

        public Builder delete(BlobId blob, Storage.BlobSourceOption ... options) {
            this.toDelete.put(blob, Lists.newArrayList((Object[])options));
            return this;
        }

        public Builder update(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
            this.toUpdate.put(blobInfo, Lists.newArrayList((Object[])options));
            return this;
        }

        public Builder get(String bucket, String blob, Storage.BlobGetOption ... options) {
            this.toGet.put(BlobId.of(bucket, blob), Lists.newArrayList((Object[])options));
            return this;
        }

        public Builder get(BlobId blob, Storage.BlobGetOption ... options) {
            this.toGet.put(blob, Lists.newArrayList((Object[])options));
            return this;
        }

        public BatchRequest build() {
            return new BatchRequest(this);
        }
    }
}

