/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.storage;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.gcloud.storage.BlobInfo;
import com.google.gcloud.storage.StorageException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public final class BatchResponse
implements Serializable {
    private static final long serialVersionUID = 1057416839397037706L;
    private final List<Result<Boolean>> deleteResult;
    private final List<Result<BlobInfo>> updateResult;
    private final List<Result<BlobInfo>> getResult;

    BatchResponse(List<Result<Boolean>> deleteResult, List<Result<BlobInfo>> updateResult, List<Result<BlobInfo>> getResult) {
        this.deleteResult = ImmutableList.copyOf(deleteResult);
        this.updateResult = ImmutableList.copyOf(updateResult);
        this.getResult = ImmutableList.copyOf(getResult);
    }

    public int hashCode() {
        return Objects.hash(this.deleteResult, this.updateResult, this.getResult);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BatchResponse)) {
            return false;
        }
        BatchResponse other = (BatchResponse)obj;
        return Objects.equals(this.deleteResult, other.deleteResult) && Objects.equals(this.updateResult, other.updateResult) && Objects.equals(this.getResult, other.getResult);
    }

    public List<Result<Boolean>> deletes() {
        return this.deleteResult;
    }

    public List<Result<BlobInfo>> updates() {
        return this.updateResult;
    }

    public List<Result<BlobInfo>> gets() {
        return this.getResult;
    }

    public static class Result<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = -1946539570170529094L;
        private static final Result<Serializable> EMPTY = Result.of(null);
        private final T value;
        private final StorageException exception;

        public Result(T value) {
            this.value = value;
            this.exception = null;
        }

        public Result(StorageException exception) {
            this.exception = exception;
            this.value = null;
        }

        static <T extends Serializable> Result<T> of(T value) {
            return new Result<T>(value);
        }

        public T get() throws StorageException {
            if (this.failed()) {
                throw this.failure();
            }
            return this.value;
        }

        public StorageException failure() {
            return this.exception;
        }

        public boolean failed() {
            return this.exception != null;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.value, this.exception});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Result)) {
                return false;
            }
            Result other = (Result)obj;
            return Objects.equals(this.value, other.value) && Objects.equals((Object)this.exception, (Object)other.exception);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("exception", (Object)this.exception).toString();
        }

        static <T extends Serializable> Result<T> empty() {
            Result<Serializable> result = EMPTY;
            return result;
        }
    }
}

