/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.storage;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gcloud.ReadChannel;
import com.google.gcloud.WriteChannel;
import com.google.gcloud.spi.StorageRpc;
import com.google.gcloud.storage.BlobId;
import com.google.gcloud.storage.BlobInfo;
import com.google.gcloud.storage.CopyWriter;
import com.google.gcloud.storage.Option;
import com.google.gcloud.storage.Storage;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class Blob {
    private final Storage storage;
    private final BlobInfo info;

    public Blob(Storage storage, BlobInfo info) {
        this.storage = (Storage)Preconditions.checkNotNull((Object)storage);
        this.info = (BlobInfo)Preconditions.checkNotNull((Object)info);
    }

    public static Blob get(Storage storage, String bucket, String blob, Storage.BlobGetOption ... options) {
        return Blob.get(storage, BlobId.of(bucket, blob), options);
    }

    public static Blob get(Storage storage, BlobId blobId, Storage.BlobGetOption ... options) {
        BlobInfo info = storage.get(blobId, options);
        return info != null ? new Blob(storage, info) : null;
    }

    public BlobInfo info() {
        return this.info;
    }

    public BlobId id() {
        return this.info.blobId();
    }

    public boolean exists(BlobSourceOption ... options) {
        int length = options.length;
        Storage.BlobGetOption[] getOptions = Arrays.copyOf(BlobSourceOption.toGetOptions(this.info, options), length + 1);
        getOptions[length] = Storage.BlobGetOption.fields(new Storage.BlobField[0]);
        return this.storage.get(this.info.blobId(), getOptions) != null;
    }

    public byte[] content(Storage.BlobSourceOption ... options) {
        return this.storage.readAllBytes(this.info.blobId(), options);
    }

    public Blob reload(BlobSourceOption ... options) {
        return Blob.get(this.storage, this.info.blobId(), BlobSourceOption.toGetOptions(this.info, options));
    }

    public Blob update(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        Preconditions.checkArgument((boolean)Objects.equals(blobInfo.bucket(), this.info.bucket()), (Object)"Bucket name must match");
        Preconditions.checkArgument((boolean)Objects.equals(blobInfo.name(), this.info.name()), (Object)"Blob name must match");
        return new Blob(this.storage, this.storage.update(blobInfo, options));
    }

    public boolean delete(BlobSourceOption ... options) {
        return this.storage.delete(this.info.blobId(), BlobSourceOption.toSourceOptions(this.info, options));
    }

    public CopyWriter copyTo(BlobId targetBlob, BlobSourceOption ... options) {
        Storage.CopyRequest copyRequest = Storage.CopyRequest.builder().source(this.info.bucket(), this.info.name()).sourceOptions(BlobSourceOption.toSourceOptions(this.info, options)).target(targetBlob).build();
        return this.storage.copy(copyRequest);
    }

    public CopyWriter copyTo(String targetBucket, BlobSourceOption ... options) {
        return this.copyTo(targetBucket, this.info.name(), options);
    }

    public CopyWriter copyTo(String targetBucket, String targetBlob, BlobSourceOption ... options) {
        return this.copyTo(BlobId.of(targetBucket, targetBlob), options);
    }

    public ReadChannel reader(BlobSourceOption ... options) {
        return this.storage.reader(this.info.blobId(), BlobSourceOption.toSourceOptions(this.info, options));
    }

    public WriteChannel writer(Storage.BlobWriteOption ... options) {
        return this.storage.writer(this.info, options);
    }

    public URL signUrl(long duration, TimeUnit unit, Storage.SignUrlOption ... options) {
        return this.storage.signUrl(this.info, duration, unit, options);
    }

    public Storage storage() {
        return this.storage;
    }

    public static List<Blob> get(Storage storage, BlobId first, BlobId second, BlobId ... other) {
        Preconditions.checkNotNull((Object)storage);
        Preconditions.checkNotNull((Object)first);
        Preconditions.checkNotNull((Object)second);
        Preconditions.checkNotNull((Object)other);
        ImmutableList blobs = ImmutableList.builder().add((Object)first).add((Object)second).addAll(Arrays.asList(other)).build();
        return Blob.get(storage, (List<BlobId>)blobs);
    }

    public static List<Blob> get(final Storage storage, List<BlobId> blobs) {
        Preconditions.checkNotNull((Object)storage);
        Preconditions.checkNotNull(blobs);
        BlobId[] blobArray = blobs.toArray(new BlobId[blobs.size()]);
        return Collections.unmodifiableList(Lists.transform(storage.get(blobArray), (Function)new Function<BlobInfo, Blob>(){

            public Blob apply(BlobInfo blobInfo) {
                return blobInfo != null ? new Blob(storage, blobInfo) : null;
            }
        }));
    }

    public static List<Blob> update(final Storage storage, BlobInfo ... infos) {
        Preconditions.checkNotNull((Object)storage);
        Preconditions.checkNotNull((Object)infos);
        if (infos.length == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Lists.transform(storage.update(infos), (Function)new Function<BlobInfo, Blob>(){

            public Blob apply(BlobInfo blobInfo) {
                return blobInfo != null ? new Blob(storage, blobInfo) : null;
            }
        }));
    }

    public static List<Boolean> delete(Storage storage, BlobId ... blobs) {
        Preconditions.checkNotNull((Object)storage);
        Preconditions.checkNotNull((Object)blobs);
        if (blobs.length == 0) {
            return Collections.emptyList();
        }
        return storage.delete(blobs);
    }

    public static class BlobSourceOption
    extends Option {
        private static final long serialVersionUID = 214616862061934846L;

        private BlobSourceOption(StorageRpc.Option rpcOption) {
            super(rpcOption, null);
        }

        private Storage.BlobSourceOption toSourceOptions(BlobInfo blobInfo) {
            switch (this.rpcOption()) {
                case IF_GENERATION_MATCH: {
                    return Storage.BlobSourceOption.generationMatch(blobInfo.generation());
                }
                case IF_GENERATION_NOT_MATCH: {
                    return Storage.BlobSourceOption.generationNotMatch(blobInfo.generation());
                }
                case IF_METAGENERATION_MATCH: {
                    return Storage.BlobSourceOption.metagenerationMatch(blobInfo.metageneration());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return Storage.BlobSourceOption.metagenerationNotMatch(blobInfo.metageneration());
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        private Storage.BlobGetOption toGetOption(BlobInfo blobInfo) {
            switch (this.rpcOption()) {
                case IF_GENERATION_MATCH: {
                    return Storage.BlobGetOption.generationMatch(blobInfo.generation());
                }
                case IF_GENERATION_NOT_MATCH: {
                    return Storage.BlobGetOption.generationNotMatch(blobInfo.generation());
                }
                case IF_METAGENERATION_MATCH: {
                    return Storage.BlobGetOption.metagenerationMatch(blobInfo.metageneration());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return Storage.BlobGetOption.metagenerationNotMatch(blobInfo.metageneration());
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        public static BlobSourceOption generationMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_GENERATION_MATCH);
        }

        public static BlobSourceOption generationNotMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_GENERATION_NOT_MATCH);
        }

        public static BlobSourceOption metagenerationMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_METAGENERATION_MATCH);
        }

        public static BlobSourceOption metagenerationNotMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH);
        }

        static Storage.BlobSourceOption[] toSourceOptions(BlobInfo blobInfo, BlobSourceOption ... options) {
            Storage.BlobSourceOption[] convertedOptions = new Storage.BlobSourceOption[options.length];
            int index = 0;
            for (BlobSourceOption option : options) {
                convertedOptions[index++] = option.toSourceOptions(blobInfo);
            }
            return convertedOptions;
        }

        static Storage.BlobGetOption[] toGetOptions(BlobInfo blobInfo, BlobSourceOption ... options) {
            Storage.BlobGetOption[] convertedOptions = new Storage.BlobGetOption[options.length];
            int index = 0;
            for (BlobSourceOption option : options) {
                convertedOptions[index++] = option.toGetOption(blobInfo);
            }
            return convertedOptions;
        }
    }
}

