/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.storage;

import com.google.api.services.storage.model.StorageObject;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public final class BlobId
implements Serializable {
    private static final long serialVersionUID = -6156002883225601925L;
    private final String bucket;
    private final String name;
    private final Long generation;

    private BlobId(String bucket, String name, Long generation) {
        this.bucket = bucket;
        this.name = name;
        this.generation = generation;
    }

    public String bucket() {
        return this.bucket;
    }

    public String name() {
        return this.name;
    }

    public Long generation() {
        return this.generation;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucket", (Object)this.bucket()).add("name", (Object)this.name()).add("generation", (Object)this.generation()).toString();
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.name, this.generation);
    }

    public boolean equals(Object obj) {
        return obj instanceof BlobId && Objects.equals(this.bucket, ((BlobId)obj).bucket) && Objects.equals(this.name, ((BlobId)obj).name) && Objects.equals(this.generation, ((BlobId)obj).generation);
    }

    StorageObject toPb() {
        StorageObject storageObject = new StorageObject();
        storageObject.setBucket(this.bucket);
        storageObject.setName(this.name);
        storageObject.setGeneration(this.generation);
        return storageObject;
    }

    public static BlobId of(String bucket, String name) {
        return new BlobId((String)Preconditions.checkNotNull((Object)bucket), (String)Preconditions.checkNotNull((Object)name), null);
    }

    public static BlobId of(String bucket, String name, Long generation) {
        return new BlobId((String)Preconditions.checkNotNull((Object)bucket), (String)Preconditions.checkNotNull((Object)name), generation);
    }

    static BlobId fromPb(StorageObject storageObject) {
        return BlobId.of(storageObject.getBucket(), storageObject.getName(), storageObject.getGeneration());
    }
}

