/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.storage;

import com.google.api.client.util.Data;
import com.google.api.client.util.DateTime;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gcloud.storage.Acl;
import com.google.gcloud.storage.BlobId;
import com.google.gcloud.storage.BucketInfo;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class BlobInfo
implements Serializable {
    static final Function<StorageObject, BlobInfo> FROM_PB_FUNCTION = new Function<StorageObject, BlobInfo>(){

        public BlobInfo apply(StorageObject pb) {
            return BlobInfo.fromPb(pb);
        }
    };
    static final Function<BlobInfo, StorageObject> TO_PB_FUNCTION = new Function<BlobInfo, StorageObject>(){

        public StorageObject apply(BlobInfo blobInfo) {
            return blobInfo.toPb();
        }
    };
    private static final long serialVersionUID = 2228487739943277159L;
    private final BlobId blobId;
    private final String id;
    private final String selfLink;
    private final String cacheControl;
    private final List<Acl> acl;
    private final Acl.Entity owner;
    private final Long size;
    private final String etag;
    private final String md5;
    private final String crc32c;
    private final String mediaLink;
    private final Map<String, String> metadata;
    private final Long metageneration;
    private final Long deleteTime;
    private final Long updateTime;
    private final String contentType;
    private final String contentEncoding;
    private final String contentDisposition;
    private final String contentLanguage;
    private final Integer componentCount;

    private BlobInfo(Builder builder) {
        this.blobId = builder.blobId;
        this.id = builder.id;
        this.cacheControl = builder.cacheControl;
        this.contentEncoding = builder.contentEncoding;
        this.contentType = builder.contentType;
        this.contentDisposition = builder.contentDisposition;
        this.contentLanguage = builder.contentLanguage;
        this.componentCount = builder.componentCount;
        this.acl = builder.acl;
        this.owner = builder.owner;
        this.size = builder.size;
        this.etag = builder.etag;
        this.selfLink = builder.selfLink;
        this.md5 = builder.md5;
        this.crc32c = builder.crc32c;
        this.mediaLink = builder.mediaLink;
        this.metadata = builder.metadata;
        this.metageneration = builder.metageneration;
        this.deleteTime = builder.deleteTime;
        this.updateTime = builder.updateTime;
    }

    public BlobId blobId() {
        return this.blobId;
    }

    public String bucket() {
        return this.blobId().bucket();
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.blobId().name();
    }

    public String cacheControl() {
        return Data.isNull((Object)this.cacheControl) ? null : this.cacheControl;
    }

    public List<Acl> acl() {
        return this.acl;
    }

    public Acl.Entity owner() {
        return this.owner;
    }

    public Long size() {
        return this.size;
    }

    public String contentType() {
        return Data.isNull((Object)this.contentType) ? null : this.contentType;
    }

    public String contentEncoding() {
        return Data.isNull((Object)this.contentEncoding) ? null : this.contentEncoding;
    }

    public String contentDisposition() {
        return Data.isNull((Object)this.contentDisposition) ? null : this.contentDisposition;
    }

    public String contentLanguage() {
        return Data.isNull((Object)this.contentLanguage) ? null : this.contentLanguage;
    }

    public Integer componentCount() {
        return this.componentCount;
    }

    public String etag() {
        return this.etag;
    }

    public String selfLink() {
        return this.selfLink;
    }

    public String md5() {
        return Data.isNull((Object)this.md5) ? null : this.md5;
    }

    public String crc32c() {
        return Data.isNull((Object)this.crc32c) ? null : this.crc32c;
    }

    public String mediaLink() {
        return this.mediaLink;
    }

    public Map<String, String> metadata() {
        return this.metadata == null || Data.isNull(this.metadata) ? null : Collections.unmodifiableMap(this.metadata);
    }

    public Long generation() {
        return this.blobId().generation();
    }

    public Long metageneration() {
        return this.metageneration;
    }

    public Long deleteTime() {
        return this.deleteTime;
    }

    public Long updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucket", (Object)this.bucket()).add("name", (Object)this.name()).add("generation", (Object)this.generation()).add("size", (Object)this.size()).add("content-type", (Object)this.contentType()).add("metadata", this.metadata()).toString();
    }

    public int hashCode() {
        return Objects.hash(this.blobId);
    }

    public boolean equals(Object obj) {
        return obj instanceof BlobInfo && Objects.equals(this.toPb(), ((BlobInfo)obj).toPb());
    }

    StorageObject toPb() {
        StorageObject storageObject = this.blobId.toPb();
        if (this.acl != null) {
            storageObject.setAcl(Lists.transform(this.acl, (Function)new Function<Acl, ObjectAccessControl>(){

                public ObjectAccessControl apply(Acl acl) {
                    return acl.toObjectPb();
                }
            }));
        }
        if (this.deleteTime != null) {
            storageObject.setTimeDeleted(new DateTime(this.deleteTime.longValue()));
        }
        if (this.updateTime != null) {
            storageObject.setUpdated(new DateTime(this.updateTime.longValue()));
        }
        if (this.size != null) {
            storageObject.setSize(BigInteger.valueOf(this.size));
        }
        if (this.owner != null) {
            storageObject.setOwner(new StorageObject.Owner().setEntity(this.owner.toPb()));
        }
        HashMap pbMetadata = this.metadata;
        if (this.metadata != null && !Data.isNull(this.metadata)) {
            pbMetadata = Maps.newHashMapWithExpectedSize((int)this.metadata.size());
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                pbMetadata.put(entry.getKey(), MoreObjects.firstNonNull((Object)entry.getValue(), (Object)Data.nullOf(String.class)));
            }
        }
        storageObject.setMetadata(pbMetadata);
        storageObject.setCacheControl(this.cacheControl);
        storageObject.setContentEncoding(this.contentEncoding);
        storageObject.setCrc32c(this.crc32c);
        storageObject.setContentType(this.contentType);
        storageObject.setMd5Hash(this.md5);
        storageObject.setMediaLink(this.mediaLink);
        storageObject.setMetageneration(this.metageneration);
        storageObject.setContentDisposition(this.contentDisposition);
        storageObject.setComponentCount(this.componentCount);
        storageObject.setContentLanguage(this.contentLanguage);
        storageObject.setEtag(this.etag);
        storageObject.setId(this.id);
        storageObject.setSelfLink(this.selfLink);
        return storageObject;
    }

    public static Builder builder(BucketInfo bucketInfo, String name) {
        return BlobInfo.builder(bucketInfo.name(), name);
    }

    public static Builder builder(String bucket, String name) {
        return new Builder().blobId(BlobId.of(bucket, name));
    }

    public static Builder builder(BucketInfo bucketInfo, String name, Long generation) {
        return BlobInfo.builder(bucketInfo.name(), name, generation);
    }

    public static Builder builder(String bucket, String name, Long generation) {
        return new Builder().blobId(BlobId.of(bucket, name, generation));
    }

    public static Builder builder(BlobId blobId) {
        return new Builder().blobId(blobId);
    }

    static BlobInfo fromPb(StorageObject storageObject) {
        Builder builder = BlobInfo.builder(BlobId.fromPb(storageObject));
        if (storageObject.getCacheControl() != null) {
            builder.cacheControl(storageObject.getCacheControl());
        }
        if (storageObject.getContentEncoding() != null) {
            builder.contentEncoding(storageObject.getContentEncoding());
        }
        if (storageObject.getCrc32c() != null) {
            builder.crc32c(storageObject.getCrc32c());
        }
        if (storageObject.getContentType() != null) {
            builder.contentType(storageObject.getContentType());
        }
        if (storageObject.getMd5Hash() != null) {
            builder.md5(storageObject.getMd5Hash());
        }
        if (storageObject.getMediaLink() != null) {
            builder.mediaLink(storageObject.getMediaLink());
        }
        if (storageObject.getMetageneration() != null) {
            builder.metageneration(storageObject.getMetageneration());
        }
        if (storageObject.getContentDisposition() != null) {
            builder.contentDisposition(storageObject.getContentDisposition());
        }
        if (storageObject.getComponentCount() != null) {
            builder.componentCount(storageObject.getComponentCount());
        }
        if (storageObject.getContentLanguage() != null) {
            builder.contentLanguage(storageObject.getContentLanguage());
        }
        if (storageObject.getEtag() != null) {
            builder.etag(storageObject.getEtag());
        }
        if (storageObject.getId() != null) {
            builder.id(storageObject.getId());
        }
        if (storageObject.getSelfLink() != null) {
            builder.selfLink(storageObject.getSelfLink());
        }
        if (storageObject.getMetadata() != null) {
            builder.metadata(storageObject.getMetadata());
        }
        if (storageObject.getTimeDeleted() != null) {
            builder.deleteTime(storageObject.getTimeDeleted().getValue());
        }
        if (storageObject.getUpdated() != null) {
            builder.updateTime(storageObject.getUpdated().getValue());
        }
        if (storageObject.getSize() != null) {
            builder.size(storageObject.getSize().longValue());
        }
        if (storageObject.getOwner() != null) {
            builder.owner(Acl.Entity.fromPb(storageObject.getOwner().getEntity()));
        }
        if (storageObject.getAcl() != null) {
            builder.acl(Lists.transform((List)storageObject.getAcl(), (Function)new Function<ObjectAccessControl, Acl>(){

                public Acl apply(ObjectAccessControl objectAccessControl) {
                    return Acl.fromPb(objectAccessControl);
                }
            }));
        }
        return builder.build();
    }

    public static final class Builder {
        private BlobId blobId;
        private String id;
        private String contentType;
        private String contentEncoding;
        private String contentDisposition;
        private String contentLanguage;
        private Integer componentCount;
        private String cacheControl;
        private List<Acl> acl;
        private Acl.Entity owner;
        private Long size;
        private String etag;
        private String selfLink;
        private String md5;
        private String crc32c;
        private String mediaLink;
        private Map<String, String> metadata;
        private Long metageneration;
        private Long deleteTime;
        private Long updateTime;

        private Builder() {
        }

        private Builder(BlobInfo blobInfo) {
            this.blobId = blobInfo.blobId;
            this.id = blobInfo.id;
            this.cacheControl = blobInfo.cacheControl;
            this.contentEncoding = blobInfo.contentEncoding;
            this.contentType = blobInfo.contentType;
            this.contentDisposition = blobInfo.contentDisposition;
            this.contentLanguage = blobInfo.contentLanguage;
            this.componentCount = blobInfo.componentCount;
            this.acl = blobInfo.acl;
            this.owner = blobInfo.owner;
            this.size = blobInfo.size;
            this.etag = blobInfo.etag;
            this.selfLink = blobInfo.selfLink;
            this.md5 = blobInfo.md5;
            this.crc32c = blobInfo.crc32c;
            this.mediaLink = blobInfo.mediaLink;
            this.metadata = blobInfo.metadata;
            this.metageneration = blobInfo.metageneration;
            this.deleteTime = blobInfo.deleteTime;
            this.updateTime = blobInfo.updateTime;
        }

        public Builder blobId(BlobId blobId) {
            this.blobId = (BlobId)Preconditions.checkNotNull((Object)blobId);
            return this;
        }

        Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = (String)MoreObjects.firstNonNull((Object)contentType, (Object)Data.nullOf(String.class));
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = (String)MoreObjects.firstNonNull((Object)contentDisposition, (Object)Data.nullOf(String.class));
            return this;
        }

        public Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = (String)MoreObjects.firstNonNull((Object)contentLanguage, (Object)Data.nullOf(String.class));
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = (String)MoreObjects.firstNonNull((Object)contentEncoding, (Object)Data.nullOf(String.class));
            return this;
        }

        Builder componentCount(Integer componentCount) {
            this.componentCount = componentCount;
            return this;
        }

        public Builder cacheControl(String cacheControl) {
            this.cacheControl = (String)MoreObjects.firstNonNull((Object)cacheControl, (Object)Data.nullOf(String.class));
            return this;
        }

        public Builder acl(List<Acl> acl) {
            this.acl = acl != null ? ImmutableList.copyOf(acl) : null;
            return this;
        }

        Builder owner(Acl.Entity owner) {
            this.owner = owner;
            return this;
        }

        Builder size(Long size) {
            this.size = size;
            return this;
        }

        Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        Builder selfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public Builder md5(String md5) {
            this.md5 = (String)MoreObjects.firstNonNull((Object)md5, (Object)Data.nullOf(String.class));
            return this;
        }

        public Builder crc32c(String crc32c) {
            this.crc32c = (String)MoreObjects.firstNonNull((Object)crc32c, (Object)Data.nullOf(String.class));
            return this;
        }

        Builder mediaLink(String mediaLink) {
            this.mediaLink = mediaLink;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata != null ? new HashMap<String, String>(metadata) : (Map)Data.nullOf(ImmutableEmptyMap.class);
            return this;
        }

        Builder metageneration(Long metageneration) {
            this.metageneration = metageneration;
            return this;
        }

        Builder deleteTime(Long deleteTime) {
            this.deleteTime = deleteTime;
            return this;
        }

        Builder updateTime(Long updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public BlobInfo build() {
            Preconditions.checkNotNull((Object)this.blobId);
            return new BlobInfo(this);
        }
    }

    public static final class ImmutableEmptyMap<K, V>
    extends AbstractMap<K, V> {
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return ImmutableSet.of();
        }
    }
}

