/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.storage;

import com.google.gcloud.BaseWriteChannel;
import com.google.gcloud.ExceptionHandler;
import com.google.gcloud.RestorableState;
import com.google.gcloud.RetryHelper;
import com.google.gcloud.RetryParams;
import com.google.gcloud.ServiceOptions;
import com.google.gcloud.WriteChannel;
import com.google.gcloud.spi.StorageRpc;
import com.google.gcloud.storage.BlobInfo;
import com.google.gcloud.storage.StorageException;
import com.google.gcloud.storage.StorageImpl;
import com.google.gcloud.storage.StorageOptions;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Executors;

class BlobWriteChannel
extends BaseWriteChannel<StorageOptions, BlobInfo> {
    BlobWriteChannel(StorageOptions options, BlobInfo blob, Map<StorageRpc.Option, ?> optionsMap) {
        this(options, blob, ((StorageRpc)options.rpc()).open(blob.toPb(), optionsMap));
    }

    BlobWriteChannel(StorageOptions options, BlobInfo blobInfo, String uploadId) {
        super((ServiceOptions)options, (Serializable)blobInfo, uploadId);
    }

    protected void flushBuffer(final int length, final boolean last) {
        try {
            RetryHelper.runWithRetries(Executors.callable(new Runnable(){

                @Override
                public void run() {
                    ((StorageRpc)((StorageOptions)BlobWriteChannel.this.options()).rpc()).write(BlobWriteChannel.this.uploadId(), BlobWriteChannel.this.buffer(), 0, BlobWriteChannel.this.position(), length, last);
                }
            }), (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)StorageImpl.EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    protected StateImpl.Builder stateBuilder() {
        return StateImpl.builder((StorageOptions)this.options(), (BlobInfo)this.entity(), this.uploadId());
    }

    static class StateImpl
    extends BaseWriteChannel.BaseState<StorageOptions, BlobInfo> {
        private static final long serialVersionUID = -9028324143780151286L;

        StateImpl(Builder builder) {
            super((BaseWriteChannel.BaseState.Builder)builder);
        }

        static Builder builder(StorageOptions options, BlobInfo blobInfo, String uploadId) {
            return new Builder(options, blobInfo, uploadId);
        }

        public WriteChannel restore() {
            BlobWriteChannel channel = new BlobWriteChannel((StorageOptions)this.serviceOptions, (BlobInfo)this.entity, this.uploadId);
            channel.restore(this);
            return channel;
        }

        static class Builder
        extends BaseWriteChannel.BaseState.Builder<StorageOptions, BlobInfo> {
            private Builder(StorageOptions options, BlobInfo blobInfo, String uploadId) {
                super((ServiceOptions)options, (Serializable)blobInfo, uploadId);
            }

            public RestorableState<WriteChannel> build() {
                return new StateImpl(this);
            }
        }
    }
}

