/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.storage;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.gcloud.Page;
import com.google.gcloud.PageImpl;
import com.google.gcloud.spi.StorageRpc;
import com.google.gcloud.storage.BatchRequest;
import com.google.gcloud.storage.BatchResponse;
import com.google.gcloud.storage.Blob;
import com.google.gcloud.storage.BlobId;
import com.google.gcloud.storage.BlobInfo;
import com.google.gcloud.storage.BucketInfo;
import com.google.gcloud.storage.Option;
import com.google.gcloud.storage.Storage;
import com.google.gcloud.storage.StorageOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class Bucket {
    private final Storage storage;
    private final BucketInfo info;

    public Bucket(Storage storage, BucketInfo info) {
        this.storage = (Storage)Preconditions.checkNotNull((Object)storage);
        this.info = (BucketInfo)Preconditions.checkNotNull((Object)info);
    }

    public static Bucket get(Storage storage, String bucket, Storage.BucketGetOption ... options) {
        BucketInfo info = storage.get(bucket, options);
        return info != null ? new Bucket(storage, info) : null;
    }

    public BucketInfo info() {
        return this.info;
    }

    public boolean exists(BucketSourceOption ... options) {
        int length = options.length;
        Storage.BucketGetOption[] getOptions = Arrays.copyOf(BucketSourceOption.toGetOptions(this.info, options), length + 1);
        getOptions[length] = Storage.BucketGetOption.fields(new Storage.BucketField[0]);
        return this.storage.get(this.info.name(), getOptions) != null;
    }

    public Bucket reload(BucketSourceOption ... options) {
        return Bucket.get(this.storage, this.info.name(), BucketSourceOption.toGetOptions(this.info, options));
    }

    public Bucket update(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        Preconditions.checkArgument((boolean)Objects.equals(bucketInfo.name(), this.info.name()), (Object)"Bucket name must match");
        return new Bucket(this.storage, this.storage.update(bucketInfo, options));
    }

    public boolean delete(BucketSourceOption ... options) {
        return this.storage.delete(this.info.name(), BucketSourceOption.toSourceOptions(this.info, options));
    }

    public Page<Blob> list(Storage.BlobListOption ... options) {
        Page<BlobInfo> infoPage = this.storage.list(this.info.name(), options);
        StorageOptions storageOptions = (StorageOptions)this.storage.options();
        return new PageImpl((PageImpl.NextPageFetcher)new BlobPageFetcher(storageOptions, infoPage), infoPage.nextPageCursor(), (Iterable)new LazyBlobIterable(storageOptions, infoPage.values()));
    }

    public Blob get(String blob, Storage.BlobGetOption ... options) {
        return new Blob(this.storage, this.storage.get(BlobId.of(this.info.name(), blob), options));
    }

    public List<Blob> get(String blobName1, String blobName2, String ... blobNames) {
        BatchRequest.Builder batch = BatchRequest.builder();
        batch.get(this.info.name(), blobName1, new Storage.BlobGetOption[0]);
        batch.get(this.info.name(), blobName2, new Storage.BlobGetOption[0]);
        for (String name : blobNames) {
            batch.get(this.info.name(), name, new Storage.BlobGetOption[0]);
        }
        ArrayList<Blob> blobs = new ArrayList<Blob>(blobNames.length);
        BatchResponse response = this.storage.submit(batch.build());
        for (BatchResponse.Result<BlobInfo> result : response.gets()) {
            BlobInfo blobInfo = result.get();
            blobs.add(blobInfo != null ? new Blob(this.storage, blobInfo) : null);
        }
        return Collections.unmodifiableList(blobs);
    }

    public Blob create(String blob, byte[] content, String contentType, Storage.BlobTargetOption ... options) {
        BlobInfo blobInfo = BlobInfo.builder(BlobId.of(this.info.name(), blob)).contentType((String)MoreObjects.firstNonNull((Object)contentType, (Object)"application/octet-stream")).build();
        return new Blob(this.storage, this.storage.create(blobInfo, content, options));
    }

    public Blob create(String blob, InputStream content, String contentType, Storage.BlobWriteOption ... options) {
        BlobInfo blobInfo = BlobInfo.builder(BlobId.of(this.info.name(), blob)).contentType((String)MoreObjects.firstNonNull((Object)contentType, (Object)"application/octet-stream")).build();
        return new Blob(this.storage, this.storage.create(blobInfo, content, options));
    }

    public Storage storage() {
        return this.storage;
    }

    public static class BucketSourceOption
    extends Option {
        private static final long serialVersionUID = 6928872234155522371L;

        private BucketSourceOption(StorageRpc.Option rpcOption) {
            super(rpcOption, null);
        }

        private Storage.BucketSourceOption toSourceOptions(BucketInfo bucketInfo) {
            switch (this.rpcOption()) {
                case IF_METAGENERATION_MATCH: {
                    return Storage.BucketSourceOption.metagenerationMatch(bucketInfo.metageneration());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return Storage.BucketSourceOption.metagenerationNotMatch(bucketInfo.metageneration());
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        private Storage.BucketGetOption toGetOption(BucketInfo bucketInfo) {
            switch (this.rpcOption()) {
                case IF_METAGENERATION_MATCH: {
                    return Storage.BucketGetOption.metagenerationMatch(bucketInfo.metageneration());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return Storage.BucketGetOption.metagenerationNotMatch(bucketInfo.metageneration());
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        public static BucketSourceOption metagenerationMatch() {
            return new BucketSourceOption(StorageRpc.Option.IF_METAGENERATION_MATCH);
        }

        public static BucketSourceOption metagenerationNotMatch() {
            return new BucketSourceOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH);
        }

        static Storage.BucketSourceOption[] toSourceOptions(BucketInfo bucketInfo, BucketSourceOption ... options) {
            Storage.BucketSourceOption[] convertedOptions = new Storage.BucketSourceOption[options.length];
            int index = 0;
            for (BucketSourceOption option : options) {
                convertedOptions[index++] = option.toSourceOptions(bucketInfo);
            }
            return convertedOptions;
        }

        static Storage.BucketGetOption[] toGetOptions(BucketInfo bucketInfo, BucketSourceOption ... options) {
            Storage.BucketGetOption[] convertedOptions = new Storage.BucketGetOption[options.length];
            int index = 0;
            for (BucketSourceOption option : options) {
                convertedOptions[index++] = option.toGetOption(bucketInfo);
            }
            return convertedOptions;
        }
    }

    private static class LazyBlobIterable
    implements Iterable<Blob>,
    Serializable {
        private static final long serialVersionUID = -3092290247725378832L;
        private final StorageOptions options;
        private final Iterable<BlobInfo> infoIterable;
        private transient Storage storage;

        public LazyBlobIterable(StorageOptions options, Iterable<BlobInfo> infoIterable) {
            this.options = options;
            this.infoIterable = infoIterable;
            this.storage = (Storage)options.service();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.storage = (Storage)this.options.service();
        }

        @Override
        public Iterator<Blob> iterator() {
            return Iterators.transform(this.infoIterable.iterator(), (Function)new Function<BlobInfo, Blob>(){

                public Blob apply(BlobInfo blobInfo) {
                    return new Blob(LazyBlobIterable.this.storage, blobInfo);
                }
            });
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.options, this.infoIterable});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LazyBlobIterable)) {
                return false;
            }
            LazyBlobIterable other = (LazyBlobIterable)obj;
            return Objects.equals((Object)this.options, (Object)other.options) && Objects.equals(this.infoIterable, other.infoIterable);
        }
    }

    private static class BlobPageFetcher
    implements PageImpl.NextPageFetcher<Blob> {
        private static final long serialVersionUID = 3221100177471323801L;
        private final StorageOptions options;
        private final Page<BlobInfo> infoPage;

        BlobPageFetcher(StorageOptions options, Page<BlobInfo> infoPage) {
            this.options = options;
            this.infoPage = infoPage;
        }

        public Page<Blob> nextPage() {
            Page nextInfoPage = this.infoPage.nextPage();
            return new PageImpl((PageImpl.NextPageFetcher)new BlobPageFetcher(this.options, (Page<BlobInfo>)nextInfoPage), nextInfoPage.nextPageCursor(), (Iterable)new LazyBlobIterable(this.options, nextInfoPage.values()));
        }
    }
}

