/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.storage;

import com.google.common.base.MoreObjects;
import com.google.gcloud.ExceptionHandler;
import com.google.gcloud.Restorable;
import com.google.gcloud.RestorableState;
import com.google.gcloud.RetryHelper;
import com.google.gcloud.RetryParams;
import com.google.gcloud.spi.StorageRpc;
import com.google.gcloud.storage.BlobId;
import com.google.gcloud.storage.BlobInfo;
import com.google.gcloud.storage.StorageException;
import com.google.gcloud.storage.StorageImpl;
import com.google.gcloud.storage.StorageOptions;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;

public class CopyWriter
implements Restorable<CopyWriter> {
    private final StorageOptions serviceOptions;
    private final StorageRpc storageRpc;
    private StorageRpc.RewriteResponse rewriteResponse;

    CopyWriter(StorageOptions serviceOptions, StorageRpc.RewriteResponse rewriteResponse) {
        this.serviceOptions = serviceOptions;
        this.rewriteResponse = rewriteResponse;
        this.storageRpc = (StorageRpc)serviceOptions.rpc();
    }

    public BlobInfo result() {
        while (!this.isDone()) {
            this.copyChunk();
        }
        return BlobInfo.fromPb(this.rewriteResponse.result);
    }

    public long blobSize() {
        return this.rewriteResponse.blobSize;
    }

    public boolean isDone() {
        return this.rewriteResponse.isDone;
    }

    public long totalBytesCopied() {
        return this.rewriteResponse.totalBytesRewritten;
    }

    public void copyChunk() {
        if (!this.isDone()) {
            try {
                this.rewriteResponse = (StorageRpc.RewriteResponse)RetryHelper.runWithRetries((Callable)new Callable<StorageRpc.RewriteResponse>(){

                    @Override
                    public StorageRpc.RewriteResponse call() {
                        return CopyWriter.this.storageRpc.continueRewrite(CopyWriter.this.rewriteResponse);
                    }
                }, (RetryParams)this.serviceOptions.retryParams(), (ExceptionHandler)StorageImpl.EXCEPTION_HANDLER);
            }
            catch (RetryHelper.RetryHelperException e) {
                throw StorageException.translateAndThrow(e);
            }
        }
    }

    public RestorableState<CopyWriter> capture() {
        return StateImpl.builder(this.serviceOptions, BlobId.fromPb(this.rewriteResponse.rewriteRequest.source), this.rewriteResponse.rewriteRequest.sourceOptions, BlobInfo.fromPb(this.rewriteResponse.rewriteRequest.target), this.rewriteResponse.rewriteRequest.targetOptions).blobSize(this.blobSize()).isDone(this.isDone()).megabytesCopiedPerChunk(this.rewriteResponse.rewriteRequest.megabytesRewrittenPerCall).rewriteToken(this.rewriteResponse.rewriteToken).totalBytesRewritten(this.totalBytesCopied()).build();
    }

    static class StateImpl
    implements RestorableState<CopyWriter>,
    Serializable {
        private static final long serialVersionUID = 8279287678903181701L;
        private final StorageOptions serviceOptions;
        private final BlobId source;
        private final Map<StorageRpc.Option, ?> sourceOptions;
        private final BlobInfo target;
        private final Map<StorageRpc.Option, ?> targetOptions;
        private final BlobInfo result;
        private final long blobSize;
        private final boolean isDone;
        private final String rewriteToken;
        private final long totalBytesCopied;
        private final Long megabytesCopiedPerChunk;

        StateImpl(Builder builder) {
            this.serviceOptions = builder.serviceOptions;
            this.source = builder.source;
            this.sourceOptions = builder.sourceOptions;
            this.target = builder.target;
            this.targetOptions = builder.targetOptions;
            this.result = builder.result;
            this.blobSize = builder.blobSize;
            this.isDone = builder.isDone;
            this.rewriteToken = builder.rewriteToken;
            this.totalBytesCopied = builder.totalBytesCopied;
            this.megabytesCopiedPerChunk = builder.megabytesCopiedPerChunk;
        }

        static Builder builder(StorageOptions options, BlobId source, Map<StorageRpc.Option, ?> sourceOptions, BlobInfo target, Map<StorageRpc.Option, ?> targetOptions) {
            return new Builder(options, source, sourceOptions, target, targetOptions);
        }

        public CopyWriter restore() {
            StorageRpc.RewriteRequest rewriteRequest = new StorageRpc.RewriteRequest(this.source.toPb(), this.sourceOptions, this.target.toPb(), this.targetOptions, this.megabytesCopiedPerChunk);
            StorageRpc.RewriteResponse rewriteResponse = new StorageRpc.RewriteResponse(rewriteRequest, this.result != null ? this.result.toPb() : null, this.blobSize, this.isDone, this.rewriteToken, this.totalBytesCopied);
            return new CopyWriter(this.serviceOptions, rewriteResponse);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.serviceOptions, this.source, this.sourceOptions, this.target, this.targetOptions, this.result, this.blobSize, this.isDone, this.megabytesCopiedPerChunk, this.rewriteToken, this.totalBytesCopied});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StateImpl)) {
                return false;
            }
            StateImpl other = (StateImpl)obj;
            return Objects.equals((Object)this.serviceOptions, (Object)other.serviceOptions) && Objects.equals(this.source, other.source) && Objects.equals(this.sourceOptions, other.sourceOptions) && Objects.equals(this.target, other.target) && Objects.equals(this.targetOptions, other.targetOptions) && Objects.equals(this.result, other.result) && Objects.equals(this.rewriteToken, other.rewriteToken) && Objects.equals(this.megabytesCopiedPerChunk, other.megabytesCopiedPerChunk) && this.blobSize == other.blobSize && this.isDone == other.isDone && this.totalBytesCopied == other.totalBytesCopied;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("target", (Object)this.target).add("isDone", this.isDone).add("totalBytesRewritten", this.totalBytesCopied).add("blobSize", this.blobSize).toString();
        }

        static class Builder {
            private final StorageOptions serviceOptions;
            private final BlobId source;
            private final Map<StorageRpc.Option, ?> sourceOptions;
            private final BlobInfo target;
            private final Map<StorageRpc.Option, ?> targetOptions;
            private BlobInfo result;
            private long blobSize;
            private boolean isDone;
            private String rewriteToken;
            private long totalBytesCopied;
            private Long megabytesCopiedPerChunk;

            private Builder(StorageOptions options, BlobId source, Map<StorageRpc.Option, ?> sourceOptions, BlobInfo target, Map<StorageRpc.Option, ?> targetOptions) {
                this.serviceOptions = options;
                this.source = source;
                this.sourceOptions = sourceOptions;
                this.target = target;
                this.targetOptions = targetOptions;
            }

            Builder result(BlobInfo result) {
                this.result = result;
                return this;
            }

            Builder blobSize(long blobSize) {
                this.blobSize = blobSize;
                return this;
            }

            Builder isDone(boolean isDone) {
                this.isDone = isDone;
                return this;
            }

            Builder rewriteToken(String rewriteToken) {
                this.rewriteToken = rewriteToken;
                return this;
            }

            Builder totalBytesRewritten(long totalBytesRewritten) {
                this.totalBytesCopied = totalBytesRewritten;
                return this;
            }

            Builder megabytesCopiedPerChunk(Long megabytesCopiedPerChunk) {
                this.megabytesCopiedPerChunk = megabytesCopiedPerChunk;
                return this;
            }

            RestorableState<CopyWriter> build() {
                return new StateImpl(this);
            }
        }
    }
}

