/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.storage;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gcloud.AuthCredentials;
import com.google.gcloud.Page;
import com.google.gcloud.ReadChannel;
import com.google.gcloud.Service;
import com.google.gcloud.WriteChannel;
import com.google.gcloud.spi.StorageRpc;
import com.google.gcloud.storage.BatchRequest;
import com.google.gcloud.storage.BatchResponse;
import com.google.gcloud.storage.BlobId;
import com.google.gcloud.storage.BlobInfo;
import com.google.gcloud.storage.BucketInfo;
import com.google.gcloud.storage.CopyWriter;
import com.google.gcloud.storage.HttpMethod;
import com.google.gcloud.storage.Option;
import com.google.gcloud.storage.StorageOptions;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface Storage
extends Service<StorageOptions> {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";

    public BucketInfo create(BucketInfo var1, BucketTargetOption ... var2);

    public BlobInfo create(BlobInfo var1, BlobTargetOption ... var2);

    public BlobInfo create(BlobInfo var1, byte[] var2, BlobTargetOption ... var3);

    public BlobInfo create(BlobInfo var1, InputStream var2, BlobWriteOption ... var3);

    public BucketInfo get(String var1, BucketGetOption ... var2);

    public BlobInfo get(String var1, String var2, BlobGetOption ... var3);

    public BlobInfo get(BlobId var1, BlobGetOption ... var2);

    public BlobInfo get(BlobId var1);

    public Page<BucketInfo> list(BucketListOption ... var1);

    public Page<BlobInfo> list(String var1, BlobListOption ... var2);

    public BucketInfo update(BucketInfo var1, BucketTargetOption ... var2);

    public BlobInfo update(BlobInfo var1, BlobTargetOption ... var2);

    public BlobInfo update(BlobInfo var1);

    public boolean delete(String var1, BucketSourceOption ... var2);

    public boolean delete(String var1, String var2, BlobSourceOption ... var3);

    public boolean delete(BlobId var1, BlobSourceOption ... var2);

    public boolean delete(BlobId var1);

    public BlobInfo compose(ComposeRequest var1);

    public CopyWriter copy(CopyRequest var1);

    public byte[] readAllBytes(String var1, String var2, BlobSourceOption ... var3);

    public byte[] readAllBytes(BlobId var1, BlobSourceOption ... var2);

    public BatchResponse submit(BatchRequest var1);

    public ReadChannel reader(String var1, String var2, BlobSourceOption ... var3);

    public ReadChannel reader(BlobId var1, BlobSourceOption ... var2);

    public WriteChannel writer(BlobInfo var1, BlobWriteOption ... var2);

    public URL signUrl(BlobInfo var1, long var2, TimeUnit var4, SignUrlOption ... var5);

    public List<BlobInfo> get(BlobId ... var1);

    public List<BlobInfo> update(BlobInfo ... var1);

    public List<Boolean> delete(BlobId ... var1);

    public static class CopyRequest
    implements Serializable {
        private static final long serialVersionUID = -4498650529476219937L;
        private final BlobId source;
        private final List<BlobSourceOption> sourceOptions;
        private final BlobInfo target;
        private final List<BlobTargetOption> targetOptions;
        private final Long megabytesCopiedPerChunk;

        private CopyRequest(Builder builder) {
            this.source = (BlobId)Preconditions.checkNotNull((Object)builder.source);
            this.sourceOptions = ImmutableList.copyOf((Collection)builder.sourceOptions);
            this.target = (BlobInfo)Preconditions.checkNotNull((Object)builder.target);
            this.targetOptions = ImmutableList.copyOf((Collection)builder.targetOptions);
            this.megabytesCopiedPerChunk = builder.megabytesCopiedPerChunk;
        }

        public BlobId source() {
            return this.source;
        }

        public List<BlobSourceOption> sourceOptions() {
            return this.sourceOptions;
        }

        public BlobInfo target() {
            return this.target;
        }

        public List<BlobTargetOption> targetOptions() {
            return this.targetOptions;
        }

        public Long megabytesCopiedPerChunk() {
            return this.megabytesCopiedPerChunk;
        }

        public static CopyRequest of(String sourceBucket, String sourceBlob, BlobInfo target) throws IllegalArgumentException {
            CopyRequest.checkContentType(target);
            return CopyRequest.builder().source(sourceBucket, sourceBlob).target(target, new BlobTargetOption[0]).build();
        }

        public static CopyRequest of(BlobId sourceBlobId, BlobInfo target) throws IllegalArgumentException {
            CopyRequest.checkContentType(target);
            return CopyRequest.builder().source(sourceBlobId).target(target, new BlobTargetOption[0]).build();
        }

        public static CopyRequest of(String sourceBucket, String sourceBlob, String targetBlob) {
            return CopyRequest.builder().source(sourceBucket, sourceBlob).target(BlobId.of(sourceBucket, targetBlob)).build();
        }

        public static CopyRequest of(String sourceBucket, String sourceBlob, BlobId target) {
            return CopyRequest.builder().source(sourceBucket, sourceBlob).target(target).build();
        }

        public static CopyRequest of(BlobId sourceBlobId, String targetBlob) {
            return CopyRequest.builder().source(sourceBlobId).target(BlobId.of(sourceBlobId.bucket(), targetBlob)).build();
        }

        public static CopyRequest of(BlobId sourceBlobId, BlobId targetBlobId) {
            return CopyRequest.builder().source(sourceBlobId).target(targetBlobId).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        private static void checkContentType(BlobInfo blobInfo) throws IllegalArgumentException {
            Preconditions.checkArgument((blobInfo.contentType() != null ? 1 : 0) != 0, (Object)"Blob content type can not be null");
        }

        public static class Builder {
            private final Set<BlobSourceOption> sourceOptions = new LinkedHashSet<BlobSourceOption>();
            private final Set<BlobTargetOption> targetOptions = new LinkedHashSet<BlobTargetOption>();
            private BlobId source;
            private BlobInfo target;
            private Long megabytesCopiedPerChunk;

            public Builder source(String bucket, String blob) {
                this.source = BlobId.of(bucket, blob);
                return this;
            }

            public Builder source(BlobId source) {
                this.source = source;
                return this;
            }

            public Builder sourceOptions(BlobSourceOption ... options) {
                Collections.addAll(this.sourceOptions, options);
                return this;
            }

            public Builder sourceOptions(Iterable<BlobSourceOption> options) {
                Iterables.addAll(this.sourceOptions, options);
                return this;
            }

            public Builder target(BlobId target) {
                this.target = BlobInfo.builder(target).build();
                return this;
            }

            public Builder target(BlobInfo target, BlobTargetOption ... options) throws IllegalArgumentException {
                CopyRequest.checkContentType(target);
                this.target = target;
                Collections.addAll(this.targetOptions, options);
                return this;
            }

            public Builder target(BlobInfo target, Iterable<BlobTargetOption> options) throws IllegalArgumentException {
                CopyRequest.checkContentType(target);
                this.target = target;
                Iterables.addAll(this.targetOptions, options);
                return this;
            }

            public Builder megabytesCopiedPerChunk(Long megabytesCopiedPerChunk) {
                this.megabytesCopiedPerChunk = megabytesCopiedPerChunk;
                return this;
            }

            public CopyRequest build() {
                Preconditions.checkNotNull((Object)this.source);
                Preconditions.checkNotNull((Object)this.target);
                return new CopyRequest(this);
            }
        }
    }

    public static class ComposeRequest
    implements Serializable {
        private static final long serialVersionUID = -7385681353748590911L;
        private final List<SourceBlob> sourceBlobs;
        private final BlobInfo target;
        private final List<BlobTargetOption> targetOptions;

        private ComposeRequest(Builder builder) {
            this.sourceBlobs = ImmutableList.copyOf((Collection)builder.sourceBlobs);
            this.target = builder.target;
            this.targetOptions = ImmutableList.copyOf((Collection)builder.targetOptions);
        }

        public List<SourceBlob> sourceBlobs() {
            return this.sourceBlobs;
        }

        public BlobInfo target() {
            return this.target;
        }

        public List<BlobTargetOption> targetOptions() {
            return this.targetOptions;
        }

        public static ComposeRequest of(Iterable<String> sources, BlobInfo target) {
            return ComposeRequest.builder().target(target).addSource(sources).build();
        }

        public static ComposeRequest of(String bucket, Iterable<String> sources, String target) {
            return ComposeRequest.of(sources, BlobInfo.builder(BlobId.of(bucket, target)).build());
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private final List<SourceBlob> sourceBlobs = new LinkedList<SourceBlob>();
            private final Set<BlobTargetOption> targetOptions = new LinkedHashSet<BlobTargetOption>();
            private BlobInfo target;

            public Builder addSource(Iterable<String> blobs) {
                for (String blob : blobs) {
                    this.sourceBlobs.add(new SourceBlob(blob));
                }
                return this;
            }

            public Builder addSource(String ... blobs) {
                return this.addSource(Arrays.asList(blobs));
            }

            public Builder addSource(String blob, long generation) {
                this.sourceBlobs.add(new SourceBlob(blob, generation));
                return this;
            }

            public Builder target(BlobInfo target) {
                this.target = target;
                return this;
            }

            public Builder targetOptions(BlobTargetOption ... options) {
                Collections.addAll(this.targetOptions, options);
                return this;
            }

            public Builder targetOptions(Iterable<BlobTargetOption> options) {
                Iterables.addAll(this.targetOptions, options);
                return this;
            }

            public ComposeRequest build() {
                Preconditions.checkArgument((!this.sourceBlobs.isEmpty() ? 1 : 0) != 0);
                Preconditions.checkNotNull((Object)this.target);
                return new ComposeRequest(this);
            }
        }

        public static class SourceBlob
        implements Serializable {
            private static final long serialVersionUID = 4094962795951990439L;
            final String name;
            final Long generation;

            SourceBlob(String name) {
                this(name, null);
            }

            SourceBlob(String name, Long generation) {
                this.name = name;
                this.generation = generation;
            }

            public String name() {
                return this.name;
            }

            public Long generation() {
                return this.generation;
            }
        }
    }

    public static class SignUrlOption
    implements Serializable {
        private static final long serialVersionUID = 7850569877451099267L;
        private final Option option;
        private final Object value;

        private SignUrlOption(Option option, Object value) {
            this.option = option;
            this.value = value;
        }

        Option option() {
            return this.option;
        }

        Object value() {
            return this.value;
        }

        public static SignUrlOption httpMethod(HttpMethod httpMethod) {
            return new SignUrlOption(Option.HTTP_METHOD, httpMethod.name());
        }

        public static SignUrlOption withContentType() {
            return new SignUrlOption(Option.CONTENT_TYPE, true);
        }

        public static SignUrlOption withMd5() {
            return new SignUrlOption(Option.MD5, true);
        }

        public static SignUrlOption serviceAccount(AuthCredentials.ServiceAccountAuthCredentials credentials) {
            return new SignUrlOption(Option.SERVICE_ACCOUNT_CRED, credentials);
        }

        static enum Option {
            HTTP_METHOD,
            CONTENT_TYPE,
            MD5,
            SERVICE_ACCOUNT_CRED;

        }
    }

    public static class BlobListOption
    extends Option {
        private static final long serialVersionUID = 9083383524788661294L;

        private BlobListOption(StorageRpc.Option option, Object value) {
            super(option, value);
        }

        public static BlobListOption maxResults(long maxResults) {
            return new BlobListOption(StorageRpc.Option.MAX_RESULTS, maxResults);
        }

        public static BlobListOption startPageToken(String pageToken) {
            return new BlobListOption(StorageRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static BlobListOption prefix(String prefix) {
            return new BlobListOption(StorageRpc.Option.PREFIX, prefix);
        }

        public static BlobListOption recursive(boolean recursive) {
            return new BlobListOption(StorageRpc.Option.DELIMITER, recursive);
        }

        public static BlobListOption fields(BlobField ... fields) {
            StringBuilder builder = new StringBuilder();
            builder.append("items(").append(BlobField.selector(fields)).append(")");
            return new BlobListOption(StorageRpc.Option.FIELDS, builder.toString());
        }
    }

    public static class BucketListOption
    extends Option {
        private static final long serialVersionUID = 8754017079673290353L;

        private BucketListOption(StorageRpc.Option option, Object value) {
            super(option, value);
        }

        public static BucketListOption maxResults(long maxResults) {
            return new BucketListOption(StorageRpc.Option.MAX_RESULTS, maxResults);
        }

        public static BucketListOption startPageToken(String pageToken) {
            return new BucketListOption(StorageRpc.Option.PAGE_TOKEN, pageToken);
        }

        public static BucketListOption prefix(String prefix) {
            return new BucketListOption(StorageRpc.Option.PREFIX, prefix);
        }

        public static BucketListOption fields(BucketField ... fields) {
            StringBuilder builder = new StringBuilder();
            builder.append("items(").append(BucketField.selector(fields)).append(")");
            return new BucketListOption(StorageRpc.Option.FIELDS, builder.toString());
        }
    }

    public static class BlobGetOption
    extends Option {
        private static final long serialVersionUID = 803817709703661480L;

        private BlobGetOption(StorageRpc.Option rpcOption, Long value) {
            super(rpcOption, value);
        }

        private BlobGetOption(StorageRpc.Option rpcOption, String value) {
            super(rpcOption, value);
        }

        public static BlobGetOption generationMatch() {
            return new BlobGetOption(StorageRpc.Option.IF_GENERATION_MATCH, (Long)null);
        }

        public static BlobGetOption generationMatch(long generation) {
            return new BlobGetOption(StorageRpc.Option.IF_GENERATION_MATCH, generation);
        }

        public static BlobGetOption generationNotMatch() {
            return new BlobGetOption(StorageRpc.Option.IF_GENERATION_NOT_MATCH, (Long)null);
        }

        public static BlobGetOption generationNotMatch(long generation) {
            return new BlobGetOption(StorageRpc.Option.IF_GENERATION_NOT_MATCH, generation);
        }

        public static BlobGetOption metagenerationMatch(long metageneration) {
            return new BlobGetOption(StorageRpc.Option.IF_METAGENERATION_MATCH, metageneration);
        }

        public static BlobGetOption metagenerationNotMatch(long metageneration) {
            return new BlobGetOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, metageneration);
        }

        public static BlobGetOption fields(BlobField ... fields) {
            return new BlobGetOption(StorageRpc.Option.FIELDS, BlobField.selector(fields));
        }
    }

    public static class BlobSourceOption
    extends Option {
        private static final long serialVersionUID = -3712768261070182991L;

        private BlobSourceOption(StorageRpc.Option rpcOption, Long value) {
            super(rpcOption, value);
        }

        public static BlobSourceOption generationMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_GENERATION_MATCH, null);
        }

        public static BlobSourceOption generationMatch(long generation) {
            return new BlobSourceOption(StorageRpc.Option.IF_GENERATION_MATCH, generation);
        }

        public static BlobSourceOption generationNotMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_GENERATION_NOT_MATCH, null);
        }

        public static BlobSourceOption generationNotMatch(long generation) {
            return new BlobSourceOption(StorageRpc.Option.IF_GENERATION_NOT_MATCH, generation);
        }

        public static BlobSourceOption metagenerationMatch(long metageneration) {
            return new BlobSourceOption(StorageRpc.Option.IF_METAGENERATION_MATCH, metageneration);
        }

        public static BlobSourceOption metagenerationNotMatch(long metageneration) {
            return new BlobSourceOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, metageneration);
        }
    }

    public static class BlobWriteOption
    implements Serializable {
        private static final long serialVersionUID = -3880421670966224580L;
        private final Option option;
        private final Object value;

        BlobTargetOption toTargetOption() {
            return new BlobTargetOption(this.option.toRpcOption(), this.value);
        }

        private BlobWriteOption(Option option, Object value) {
            this.option = option;
            this.value = value;
        }

        private BlobWriteOption(Option option) {
            this(option, null);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.option, this.value});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BlobWriteOption)) {
                return false;
            }
            BlobWriteOption other = (BlobWriteOption)obj;
            return this.option == other.option && Objects.equals(this.value, other.value);
        }

        public static BlobWriteOption predefinedAcl(PredefinedAcl acl) {
            return new BlobWriteOption(Option.PREDEFINED_ACL, acl.entry());
        }

        public static BlobWriteOption doesNotExist() {
            return new BlobWriteOption(Option.IF_GENERATION_MATCH, 0L);
        }

        public static BlobWriteOption generationMatch() {
            return new BlobWriteOption(Option.IF_GENERATION_MATCH);
        }

        public static BlobWriteOption generationNotMatch() {
            return new BlobWriteOption(Option.IF_GENERATION_NOT_MATCH);
        }

        public static BlobWriteOption metagenerationMatch() {
            return new BlobWriteOption(Option.IF_METAGENERATION_MATCH);
        }

        public static BlobWriteOption metagenerationNotMatch() {
            return new BlobWriteOption(Option.IF_METAGENERATION_NOT_MATCH);
        }

        public static BlobWriteOption md5Match() {
            return new BlobWriteOption(Option.IF_MD5_MATCH, true);
        }

        public static BlobWriteOption crc32cMatch() {
            return new BlobWriteOption(Option.IF_CRC32C_MATCH, true);
        }

        static enum Option {
            PREDEFINED_ACL,
            IF_GENERATION_MATCH,
            IF_GENERATION_NOT_MATCH,
            IF_METAGENERATION_MATCH,
            IF_METAGENERATION_NOT_MATCH,
            IF_MD5_MATCH,
            IF_CRC32C_MATCH;


            StorageRpc.Option toRpcOption() {
                return StorageRpc.Option.valueOf(this.name());
            }
        }
    }

    public static class BlobTargetOption
    extends Option {
        private static final long serialVersionUID = 214616862061934846L;

        private BlobTargetOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        private BlobTargetOption(StorageRpc.Option rpcOption) {
            this(rpcOption, null);
        }

        public static BlobTargetOption predefinedAcl(PredefinedAcl acl) {
            return new BlobTargetOption(StorageRpc.Option.PREDEFINED_ACL, acl.entry());
        }

        public static BlobTargetOption doesNotExist() {
            return new BlobTargetOption(StorageRpc.Option.IF_GENERATION_MATCH, 0L);
        }

        public static BlobTargetOption generationMatch() {
            return new BlobTargetOption(StorageRpc.Option.IF_GENERATION_MATCH);
        }

        public static BlobTargetOption generationNotMatch() {
            return new BlobTargetOption(StorageRpc.Option.IF_GENERATION_NOT_MATCH);
        }

        public static BlobTargetOption metagenerationMatch() {
            return new BlobTargetOption(StorageRpc.Option.IF_METAGENERATION_MATCH);
        }

        public static BlobTargetOption metagenerationNotMatch() {
            return new BlobTargetOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH);
        }

        static StorageRpc.Tuple<BlobInfo, BlobTargetOption[]> convert(BlobInfo info, BlobWriteOption ... options) {
            BlobInfo.Builder infoBuilder = info.toBuilder().crc32c(null).md5(null);
            ArrayList targetOptions = Lists.newArrayListWithCapacity((int)options.length);
            block4: for (BlobWriteOption option : options) {
                switch (option.option) {
                    case IF_CRC32C_MATCH: {
                        infoBuilder.crc32c(info.crc32c());
                        continue block4;
                    }
                    case IF_MD5_MATCH: {
                        infoBuilder.md5(info.md5());
                        continue block4;
                    }
                    default: {
                        targetOptions.add(option.toTargetOption());
                    }
                }
            }
            return StorageRpc.Tuple.of(infoBuilder.build(), targetOptions.toArray(new BlobTargetOption[targetOptions.size()]));
        }
    }

    public static class BucketGetOption
    extends Option {
        private static final long serialVersionUID = 1901844869484087395L;

        private BucketGetOption(StorageRpc.Option rpcOption, long metageneration) {
            super(rpcOption, metageneration);
        }

        private BucketGetOption(StorageRpc.Option rpcOption, String value) {
            super(rpcOption, value);
        }

        public static BucketGetOption metagenerationMatch(long metageneration) {
            return new BucketGetOption(StorageRpc.Option.IF_METAGENERATION_MATCH, metageneration);
        }

        public static BucketGetOption metagenerationNotMatch(long metageneration) {
            return new BucketGetOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, metageneration);
        }

        public static BucketGetOption fields(BucketField ... fields) {
            return new BucketGetOption(StorageRpc.Option.FIELDS, BucketField.selector(fields));
        }
    }

    public static class BucketSourceOption
    extends Option {
        private static final long serialVersionUID = 5185657617120212117L;

        private BucketSourceOption(StorageRpc.Option rpcOption, long metageneration) {
            super(rpcOption, metageneration);
        }

        public static BucketSourceOption metagenerationMatch(long metageneration) {
            return new BucketSourceOption(StorageRpc.Option.IF_METAGENERATION_MATCH, metageneration);
        }

        public static BucketSourceOption metagenerationNotMatch(long metageneration) {
            return new BucketSourceOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, metageneration);
        }
    }

    public static class BucketTargetOption
    extends Option {
        private static final long serialVersionUID = -5880204616982900975L;

        private BucketTargetOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        private BucketTargetOption(StorageRpc.Option rpcOption) {
            this(rpcOption, null);
        }

        public static BucketTargetOption predefinedAcl(PredefinedAcl acl) {
            return new BucketTargetOption(StorageRpc.Option.PREDEFINED_ACL, acl.entry());
        }

        public static BucketTargetOption predefinedDefaultObjectAcl(PredefinedAcl acl) {
            return new BucketTargetOption(StorageRpc.Option.PREDEFINED_DEFAULT_OBJECT_ACL, acl.entry());
        }

        public static BucketTargetOption metagenerationMatch() {
            return new BucketTargetOption(StorageRpc.Option.IF_METAGENERATION_MATCH);
        }

        public static BucketTargetOption metagenerationNotMatch() {
            return new BucketTargetOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH);
        }
    }

    public static enum BlobField {
        ACL("acl"),
        BUCKET("bucket"),
        CACHE_CONTROL("cacheControl"),
        COMPONENT_COUNT("componentCount"),
        CONTENT_DISPOSITION("contentDisposition"),
        CONTENT_ENCODING("contentEncoding"),
        CONTENT_LANGUAGE("contentLanguage"),
        CONTENT_TYPE("contentType"),
        CRC32C("crc32c"),
        ETAG("etag"),
        GENERATION("generation"),
        ID("id"),
        KIND("kind"),
        MD5HASH("md5Hash"),
        MEDIA_LINK("mediaLink"),
        METADATA("metadata"),
        METAGENERATION("metageneration"),
        NAME("name"),
        OWNER("owner"),
        SELF_LINK("selfLink"),
        SIZE("size"),
        STORAGE_CLASS("storageClass"),
        TIME_DELETED("timeDeleted"),
        UPDATED("updated");

        private final String selector;

        private BlobField(String selector) {
            this.selector = selector;
        }

        public String selector() {
            return this.selector;
        }

        static String selector(BlobField ... fields) {
            HashSet fieldStrings = Sets.newHashSetWithExpectedSize((int)(fields.length + 2));
            fieldStrings.add(BUCKET.selector());
            fieldStrings.add(NAME.selector());
            for (BlobField field : fields) {
                fieldStrings.add(field.selector());
            }
            return Joiner.on((char)',').join((Iterable)fieldStrings);
        }
    }

    public static enum BucketField {
        ID("id"),
        SELF_LINK("selfLink"),
        NAME("name"),
        TIME_CREATED("timeCreated"),
        METAGENERATION("metageneration"),
        ACL("acl"),
        DEFAULT_OBJECT_ACL("defaultObjectAcl"),
        OWNER("owner"),
        LOCATION("location"),
        WEBSITE("website"),
        VERSIONING("versioning"),
        CORS("cors"),
        STORAGE_CLASS("storageClass"),
        ETAG("etag");

        private final String selector;

        private BucketField(String selector) {
            this.selector = selector;
        }

        public String selector() {
            return this.selector;
        }

        static String selector(BucketField ... fields) {
            HashSet fieldStrings = Sets.newHashSetWithExpectedSize((int)(fields.length + 1));
            fieldStrings.add(NAME.selector());
            for (BucketField field : fields) {
                fieldStrings.add(field.selector());
            }
            return Joiner.on((char)',').join((Iterable)fieldStrings);
        }
    }

    public static enum PredefinedAcl {
        AUTHENTICATED_READ("authenticatedRead"),
        ALL_AUTHENTICATED_USERS("allAuthenticatedUsers"),
        PRIVATE("private"),
        PROJECT_PRIVATE("projectPrivate"),
        PUBLIC_READ("publicRead"),
        PUBLIC_READ_WRITE("publicReadWrite"),
        BUCKET_OWNER_READ("bucketOwnerRead"),
        BUCKET_OWNER_FULL_CONTROL("bucketOwnerFullControl");

        private final String entry;

        private PredefinedAcl(String entry) {
            this.entry = entry;
        }

        String entry() {
            return this.entry;
        }
    }
}

