/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.storage;

import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.StorageObject;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Ints;
import com.google.gcloud.AuthCredentials;
import com.google.gcloud.BaseService;
import com.google.gcloud.ExceptionHandler;
import com.google.gcloud.Page;
import com.google.gcloud.PageImpl;
import com.google.gcloud.ReadChannel;
import com.google.gcloud.RetryHelper;
import com.google.gcloud.RetryParams;
import com.google.gcloud.ServiceOptions;
import com.google.gcloud.spi.StorageRpc;
import com.google.gcloud.storage.BatchRequest;
import com.google.gcloud.storage.BatchResponse;
import com.google.gcloud.storage.BlobId;
import com.google.gcloud.storage.BlobInfo;
import com.google.gcloud.storage.BlobReadChannel;
import com.google.gcloud.storage.BlobWriteChannel;
import com.google.gcloud.storage.BucketInfo;
import com.google.gcloud.storage.CopyWriter;
import com.google.gcloud.storage.HttpMethod;
import com.google.gcloud.storage.Option;
import com.google.gcloud.storage.Storage;
import com.google.gcloud.storage.StorageException;
import com.google.gcloud.storage.StorageOptions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

final class StorageImpl
extends BaseService<StorageOptions>
implements Storage {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final String EMPTY_BYTE_ARRAY_MD5 = "1B2M2Y8AsgTpgAmY7PhCfg==";
    private static final String EMPTY_BYTE_ARRAY_CRC32C = "AAAAAA==";
    private final StorageRpc storageRpc;

    StorageImpl(StorageOptions options) {
        super((ServiceOptions)options);
        this.storageRpc = (StorageRpc)options.rpc();
    }

    @Override
    public BucketInfo create(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        final Bucket bucketPb = bucketInfo.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = this.optionMap(bucketInfo, (Option[])options);
        try {
            return BucketInfo.fromPb((Bucket)RetryHelper.runWithRetries((Callable)new Callable<Bucket>(){

                @Override
                public Bucket call() {
                    return StorageImpl.this.storageRpc.create(bucketPb, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public BlobInfo create(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        BlobInfo updatedInfo = blobInfo.toBuilder().md5(EMPTY_BYTE_ARRAY_MD5).crc32c(EMPTY_BYTE_ARRAY_CRC32C).build();
        return this.create(updatedInfo, (InputStream)new ByteArrayInputStream(EMPTY_BYTE_ARRAY), options);
    }

    @Override
    public BlobInfo create(BlobInfo blobInfo, byte[] content, Storage.BlobTargetOption ... options) {
        content = (byte[])MoreObjects.firstNonNull((Object)content, (Object)EMPTY_BYTE_ARRAY);
        BlobInfo updatedInfo = blobInfo.toBuilder().md5(BaseEncoding.base64().encode(Hashing.md5().hashBytes(content).asBytes())).crc32c(BaseEncoding.base64().encode(Ints.toByteArray((int)Hashing.crc32c().hashBytes(content).asInt()))).build();
        return this.create(updatedInfo, (InputStream)new ByteArrayInputStream(content), options);
    }

    @Override
    public BlobInfo create(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) {
        StorageRpc.Tuple<BlobInfo, Storage.BlobTargetOption[]> targetOptions = Storage.BlobTargetOption.convert(blobInfo, options);
        return this.create(targetOptions.x(), content, targetOptions.y());
    }

    private BlobInfo create(BlobInfo info, final InputStream content, Storage.BlobTargetOption ... options) {
        final StorageObject blobPb = info.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = this.optionMap(info, (Option[])options);
        try {
            return BlobInfo.fromPb((StorageObject)RetryHelper.runWithRetries((Callable)new Callable<StorageObject>(){

                @Override
                public StorageObject call() {
                    return StorageImpl.this.storageRpc.create(blobPb, (InputStream)MoreObjects.firstNonNull((Object)content, (Object)new ByteArrayInputStream(EMPTY_BYTE_ARRAY)), optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public BucketInfo get(String bucket, Storage.BucketGetOption ... options) {
        final Bucket bucketPb = BucketInfo.of(bucket).toPb();
        final Map<StorageRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            Bucket answer = (Bucket)RetryHelper.runWithRetries((Callable)new Callable<Bucket>(){

                @Override
                public Bucket call() {
                    return StorageImpl.this.storageRpc.get(bucketPb, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
            return answer == null ? null : BucketInfo.fromPb(answer);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public BlobInfo get(String bucket, String blob, Storage.BlobGetOption ... options) {
        return this.get(BlobId.of(bucket, blob), options);
    }

    @Override
    public BlobInfo get(BlobId blob, Storage.BlobGetOption ... options) {
        final StorageObject storedObject = blob.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = this.optionMap(blob, (Option[])options);
        try {
            StorageObject storageObject = (StorageObject)RetryHelper.runWithRetries((Callable)new Callable<StorageObject>(){

                @Override
                public StorageObject call() {
                    return StorageImpl.this.storageRpc.get(storedObject, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
            return storageObject == null ? null : BlobInfo.fromPb(storageObject);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public BlobInfo get(BlobId blob) {
        return this.get(blob, new Storage.BlobGetOption[0]);
    }

    @Override
    public Page<BucketInfo> list(Storage.BucketListOption ... options) {
        return StorageImpl.listBuckets((StorageOptions)this.options(), this.optionMap(options));
    }

    @Override
    public Page<BlobInfo> list(String bucket, Storage.BlobListOption ... options) {
        return StorageImpl.listBlobs(bucket, (StorageOptions)this.options(), this.optionMap(options));
    }

    private static Page<BucketInfo> listBuckets(final StorageOptions serviceOptions, final Map<StorageRpc.Option, ?> optionsMap) {
        try {
            StorageRpc.Tuple result = (StorageRpc.Tuple)RetryHelper.runWithRetries((Callable)new Callable<StorageRpc.Tuple<String, Iterable<Bucket>>>(){

                @Override
                public StorageRpc.Tuple<String, Iterable<Bucket>> call() {
                    return ((StorageRpc)serviceOptions.rpc()).list(optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
            String cursor = (String)result.x();
            ImmutableList buckets = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<Bucket, BucketInfo>(){

                public BucketInfo apply(Bucket bucketPb) {
                    return BucketInfo.fromPb(bucketPb);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new BucketPageFetcher(serviceOptions, cursor, optionsMap), cursor, (Iterable)buckets);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    private static Page<BlobInfo> listBlobs(final String bucket, final StorageOptions serviceOptions, final Map<StorageRpc.Option, ?> optionsMap) {
        try {
            StorageRpc.Tuple result = (StorageRpc.Tuple)RetryHelper.runWithRetries((Callable)new Callable<StorageRpc.Tuple<String, Iterable<StorageObject>>>(){

                @Override
                public StorageRpc.Tuple<String, Iterable<StorageObject>> call() {
                    return ((StorageRpc)serviceOptions.rpc()).list(bucket, optionsMap);
                }
            }, (RetryParams)serviceOptions.retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
            String cursor = (String)result.x();
            ImmutableList blobs = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)((Iterable)result.y()), (Function)new Function<StorageObject, BlobInfo>(){

                public BlobInfo apply(StorageObject storageObject) {
                    return BlobInfo.fromPb(storageObject);
                }
            });
            return new PageImpl((PageImpl.NextPageFetcher)new BlobPageFetcher(bucket, serviceOptions, cursor, optionsMap), cursor, (Iterable)blobs);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public BucketInfo update(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        final Bucket bucketPb = bucketInfo.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = this.optionMap(bucketInfo, (Option[])options);
        try {
            return BucketInfo.fromPb((Bucket)RetryHelper.runWithRetries((Callable)new Callable<Bucket>(){

                @Override
                public Bucket call() {
                    return StorageImpl.this.storageRpc.patch(bucketPb, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public BlobInfo update(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        final StorageObject storageObject = blobInfo.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = this.optionMap(blobInfo, (Option[])options);
        try {
            return BlobInfo.fromPb((StorageObject)RetryHelper.runWithRetries((Callable)new Callable<StorageObject>(){

                @Override
                public StorageObject call() {
                    return StorageImpl.this.storageRpc.patch(storageObject, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public BlobInfo update(BlobInfo blobInfo) {
        return this.update(blobInfo, new Storage.BlobTargetOption[0]);
    }

    @Override
    public boolean delete(String bucket, Storage.BucketSourceOption ... options) {
        final Bucket bucketPb = BucketInfo.of(bucket).toPb();
        final Map<StorageRpc.Option, ?> optionsMap = this.optionMap(options);
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return StorageImpl.this.storageRpc.delete(bucketPb, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.delete(BlobId.of(bucket, blob), options);
    }

    @Override
    public boolean delete(BlobId blob, Storage.BlobSourceOption ... options) {
        final StorageObject storageObject = blob.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = this.optionMap(blob, (Option[])options);
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return StorageImpl.this.storageRpc.delete(storageObject, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(BlobId blob) {
        return this.delete(blob, new Storage.BlobSourceOption[0]);
    }

    @Override
    public BlobInfo compose(Storage.ComposeRequest composeRequest) {
        final ArrayList sources = Lists.newArrayListWithCapacity((int)composeRequest.sourceBlobs().size());
        for (Storage.ComposeRequest.SourceBlob sourceBlob : composeRequest.sourceBlobs()) {
            sources.add(BlobInfo.builder(BlobId.of(composeRequest.target().bucket(), sourceBlob.name(), sourceBlob.generation())).build().toPb());
        }
        final StorageObject target = composeRequest.target().toPb();
        final Map<StorageRpc.Option, ?> targetOptions = this.optionMap(composeRequest.target().generation(), composeRequest.target().metageneration(), composeRequest.targetOptions());
        try {
            return BlobInfo.fromPb((StorageObject)RetryHelper.runWithRetries((Callable)new Callable<StorageObject>(){

                @Override
                public StorageObject call() {
                    return StorageImpl.this.storageRpc.compose(sources, target, targetOptions);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public CopyWriter copy(final Storage.CopyRequest copyRequest) {
        final StorageObject source = copyRequest.source().toPb();
        final Map<StorageRpc.Option, ?> sourceOptions = this.optionMap(copyRequest.source().generation(), null, copyRequest.sourceOptions(), true);
        final StorageObject target = copyRequest.target().toPb();
        final Map<StorageRpc.Option, ?> targetOptions = this.optionMap(copyRequest.target().generation(), copyRequest.target().metageneration(), copyRequest.targetOptions());
        try {
            StorageRpc.RewriteResponse rewriteResponse = (StorageRpc.RewriteResponse)RetryHelper.runWithRetries((Callable)new Callable<StorageRpc.RewriteResponse>(){

                @Override
                public StorageRpc.RewriteResponse call() {
                    return StorageImpl.this.storageRpc.openRewrite(new StorageRpc.RewriteRequest(source, sourceOptions, target, targetOptions, copyRequest.megabytesCopiedPerChunk()));
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
            return new CopyWriter((StorageOptions)this.options(), rewriteResponse);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public byte[] readAllBytes(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.readAllBytes(BlobId.of(bucket, blob), options);
    }

    @Override
    public byte[] readAllBytes(BlobId blob, Storage.BlobSourceOption ... options) {
        final StorageObject storageObject = blob.toPb();
        final Map<StorageRpc.Option, ?> optionsMap = this.optionMap(blob, (Option[])options);
        try {
            return (byte[])RetryHelper.runWithRetries((Callable)new Callable<byte[]>(){

                @Override
                public byte[] call() {
                    return StorageImpl.this.storageRpc.load(storageObject, optionsMap);
                }
            }, (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)EXCEPTION_HANDLER);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    @Override
    public BatchResponse submit(BatchRequest batchRequest) {
        ArrayList toDelete = Lists.newArrayListWithCapacity((int)batchRequest.toDelete().size());
        for (Map.Entry<BlobId, Iterable<Storage.BlobSourceOption>> entry : batchRequest.toDelete().entrySet()) {
            BlobId blob = entry.getKey();
            Map<StorageRpc.Option, ?> optionsMap = this.optionMap(blob.generation(), null, entry.getValue());
            StorageObject storageObject = blob.toPb();
            toDelete.add(StorageRpc.Tuple.of(storageObject, optionsMap));
        }
        ArrayList toUpdate = Lists.newArrayListWithCapacity((int)batchRequest.toUpdate().size());
        for (Map.Entry<BlobInfo, Iterable<Storage.BlobTargetOption>> entry : batchRequest.toUpdate().entrySet()) {
            BlobInfo blobInfo = entry.getKey();
            Map<StorageRpc.Option, ?> optionsMap = this.optionMap(blobInfo.generation(), blobInfo.metageneration(), entry.getValue());
            toUpdate.add(StorageRpc.Tuple.of(blobInfo.toPb(), optionsMap));
        }
        ArrayList toGet = Lists.newArrayListWithCapacity((int)batchRequest.toGet().size());
        for (Map.Entry<BlobId, Iterable<Storage.BlobGetOption>> entry : batchRequest.toGet().entrySet()) {
            BlobId blob = entry.getKey();
            Map<StorageRpc.Option, ?> optionsMap = this.optionMap(blob.generation(), null, entry.getValue());
            toGet.add(StorageRpc.Tuple.of(blob.toPb(), optionsMap));
        }
        StorageRpc.BatchResponse response = this.storageRpc.batch(new StorageRpc.BatchRequest(toDelete, toUpdate, toGet));
        List<BatchResponse.Result<Boolean>> deletes = this.transformBatchResult(toDelete, response.deletes, Functions.identity());
        List<BatchResponse.Result<BlobInfo>> updates = this.transformBatchResult(toUpdate, response.updates, BlobInfo.FROM_PB_FUNCTION);
        List<BatchResponse.Result<BlobInfo>> gets = this.transformBatchResult(toGet, response.gets, BlobInfo.FROM_PB_FUNCTION);
        return new BatchResponse(deletes, updates, gets);
    }

    private <I, O extends Serializable> List<BatchResponse.Result<O>> transformBatchResult(Iterable<StorageRpc.Tuple<StorageObject, Map<StorageRpc.Option, ?>>> request, Map<StorageObject, StorageRpc.Tuple<I, StorageException>> results, Function<I, O> transform) {
        ArrayList response = Lists.newArrayListWithCapacity((int)results.size());
        for (StorageRpc.Tuple<StorageObject, Map<StorageRpc.Option, ?>> tuple : request) {
            StorageRpc.Tuple<I, StorageException> result = results.get(tuple.x());
            I object = result.x();
            StorageException exception = result.y();
            if (exception != null) {
                response.add(new BatchResponse.Result(exception));
                continue;
            }
            response.add(object != null ? BatchResponse.Result.of((Serializable)transform.apply(object)) : BatchResponse.Result.empty());
        }
        return response;
    }

    @Override
    public ReadChannel reader(String bucket, String blob, Storage.BlobSourceOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = this.optionMap(options);
        return new BlobReadChannel((StorageOptions)this.options(), BlobId.of(bucket, blob), optionsMap);
    }

    @Override
    public ReadChannel reader(BlobId blob, Storage.BlobSourceOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = this.optionMap(blob, (Option[])options);
        return new BlobReadChannel((StorageOptions)this.options(), blob, optionsMap);
    }

    public BlobWriteChannel writer(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        StorageRpc.Tuple<BlobInfo, Storage.BlobTargetOption[]> targetOptions = Storage.BlobTargetOption.convert(blobInfo, options);
        return this.writer(targetOptions.x(), targetOptions.y());
    }

    private BlobWriteChannel writer(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        Map<StorageRpc.Option, ?> optionsMap = this.optionMap(blobInfo, (Option[])options);
        return new BlobWriteChannel((StorageOptions)this.options(), blobInfo, optionsMap);
    }

    @Override
    public URL signUrl(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.SignUrlOption ... options) {
        ServiceAccountCredentials cred;
        EnumMap optionMap = Maps.newEnumMap(Storage.SignUrlOption.Option.class);
        for (Storage.SignUrlOption option : options) {
            optionMap.put(option.option(), option.value());
        }
        AuthCredentials.ServiceAccountAuthCredentials authCred = (AuthCredentials.ServiceAccountAuthCredentials)optionMap.get((Object)Storage.SignUrlOption.Option.SERVICE_ACCOUNT_CRED);
        ServiceAccountCredentials serviceAccountCredentials = cred = authCred != null ? authCred.credentials() : null;
        if (authCred == null) {
            Preconditions.checkArgument((((StorageOptions)this.options()).authCredentials() != null && ((StorageOptions)this.options()).authCredentials().credentials() instanceof ServiceAccountCredentials ? 1 : 0) != 0, (Object)"Signing key was not provided and could not be derived");
            cred = (ServiceAccountCredentials)((StorageOptions)this.options()).authCredentials().credentials();
        }
        StringBuilder stBuilder = new StringBuilder();
        if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.HTTP_METHOD)) {
            stBuilder.append(optionMap.get((Object)Storage.SignUrlOption.Option.HTTP_METHOD));
        } else {
            stBuilder.append((Object)HttpMethod.GET);
        }
        stBuilder.append('\n');
        if (((Boolean)MoreObjects.firstNonNull((Object)((Boolean)optionMap.get((Object)Storage.SignUrlOption.Option.MD5)), (Object)false)).booleanValue()) {
            Preconditions.checkArgument((blobInfo.md5() != null ? 1 : 0) != 0, (Object)"Blob is missing a value for md5");
            stBuilder.append(blobInfo.md5());
        }
        stBuilder.append('\n');
        if (((Boolean)MoreObjects.firstNonNull((Object)((Boolean)optionMap.get((Object)Storage.SignUrlOption.Option.CONTENT_TYPE)), (Object)false)).booleanValue()) {
            Preconditions.checkArgument((blobInfo.contentType() != null ? 1 : 0) != 0, (Object)"Blob is missing a value for content-type");
            stBuilder.append(blobInfo.contentType());
        }
        stBuilder.append('\n');
        long expiration = TimeUnit.SECONDS.convert(((StorageOptions)this.options()).clock().millis() + unit.toMillis(duration), TimeUnit.MILLISECONDS);
        stBuilder.append(expiration).append('\n');
        StringBuilder path = new StringBuilder();
        if (!blobInfo.bucket().startsWith("/")) {
            path.append('/');
        }
        path.append(blobInfo.bucket());
        if (!blobInfo.bucket().endsWith("/")) {
            path.append('/');
        }
        if (blobInfo.name().startsWith("/")) {
            path.setLength(stBuilder.length() - 1);
        }
        path.append(blobInfo.name());
        stBuilder.append((CharSequence)path);
        try {
            Signature signer = Signature.getInstance("SHA256withRSA");
            signer.initSign(cred.getPrivateKey());
            signer.update(stBuilder.toString().getBytes(StandardCharsets.UTF_8));
            stBuilder = new StringBuilder("https://storage.googleapis.com").append((CharSequence)path);
            String signature = URLEncoder.encode(BaseEncoding.base64().encode(signer.sign()), StandardCharsets.UTF_8.name());
            stBuilder.append("?GoogleAccessId=").append(cred.getClientEmail());
            stBuilder.append("&Expires=").append(expiration);
            stBuilder.append("&Signature=").append(signature);
            return new URL(stBuilder.toString());
        }
        catch (UnsupportedEncodingException | MalformedURLException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new IllegalArgumentException("Invalid service account private key");
        }
    }

    @Override
    public List<BlobInfo> get(BlobId ... blobIds) {
        BatchRequest.Builder requestBuilder = BatchRequest.builder();
        for (BlobId blob : blobIds) {
            requestBuilder.get(blob, new Storage.BlobGetOption[0]);
        }
        BatchResponse response = this.submit(requestBuilder.build());
        return Collections.unmodifiableList(StorageImpl.transformResultList(response.gets(), null));
    }

    @Override
    public List<BlobInfo> update(BlobInfo ... blobInfos) {
        BatchRequest.Builder requestBuilder = BatchRequest.builder();
        for (BlobInfo blobInfo : blobInfos) {
            requestBuilder.update(blobInfo, new Storage.BlobTargetOption[0]);
        }
        BatchResponse response = this.submit(requestBuilder.build());
        return Collections.unmodifiableList(StorageImpl.transformResultList(response.updates(), null));
    }

    @Override
    public List<Boolean> delete(BlobId ... blobIds) {
        BatchRequest.Builder requestBuilder = BatchRequest.builder();
        for (BlobId blob : blobIds) {
            requestBuilder.delete(blob, new Storage.BlobSourceOption[0]);
        }
        BatchResponse response = this.submit(requestBuilder.build());
        return Collections.unmodifiableList(StorageImpl.transformResultList(response.deletes(), Boolean.FALSE));
    }

    private static <T extends Serializable> List<T> transformResultList(List<BatchResponse.Result<T>> results, final T errorValue) {
        return Lists.transform(results, (Function)new Function<BatchResponse.Result<T>, T>(){

            public T apply(BatchResponse.Result<T> result) {
                return result.failed() ? errorValue : result.get();
            }
        });
    }

    private static <T> void addToOptionMap(StorageRpc.Option option, T defaultValue, Map<StorageRpc.Option, Object> map) {
        StorageImpl.addToOptionMap(option, option, defaultValue, map);
    }

    private static <T> void addToOptionMap(StorageRpc.Option getOption, StorageRpc.Option putOption, T defaultValue, Map<StorageRpc.Option, Object> map) {
        if (map.containsKey((Object)getOption)) {
            Object value = map.remove((Object)getOption);
            Preconditions.checkArgument((value != null || defaultValue != null ? 1 : 0) != 0, (Object)("Option " + getOption.value() + " is missing a value"));
            value = MoreObjects.firstNonNull((Object)value, defaultValue);
            map.put(putOption, value);
        }
    }

    private Map<StorageRpc.Option, ?> optionMap(Long generation, Long metaGeneration, Iterable<? extends Option> options) {
        return this.optionMap(generation, metaGeneration, options, false);
    }

    private Map<StorageRpc.Option, ?> optionMap(Long generation, Long metaGeneration, Iterable<? extends Option> options, boolean useAsSource) {
        EnumMap temp = Maps.newEnumMap(StorageRpc.Option.class);
        for (Option option : options) {
            Object prev = temp.put(option.rpcOption(), option.value());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object[])new Object[]{option});
        }
        Boolean value = (Boolean)temp.remove((Object)StorageRpc.Option.DELIMITER);
        if (Boolean.TRUE.equals(value)) {
            temp.put(StorageRpc.Option.DELIMITER, ((StorageOptions)this.options()).pathDelimiter());
        }
        if (useAsSource) {
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_MATCH, StorageRpc.Option.IF_SOURCE_GENERATION_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_NOT_MATCH, StorageRpc.Option.IF_SOURCE_GENERATION_NOT_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_MATCH, StorageRpc.Option.IF_SOURCE_METAGENERATION_MATCH, metaGeneration, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, StorageRpc.Option.IF_SOURCE_METAGENERATION_NOT_MATCH, metaGeneration, temp);
        } else {
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_GENERATION_NOT_MATCH, generation, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_MATCH, metaGeneration, temp);
            StorageImpl.addToOptionMap(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, metaGeneration, temp);
        }
        return ImmutableMap.copyOf((Map)temp);
    }

    private Map<StorageRpc.Option, ?> optionMap(Option ... options) {
        return this.optionMap(null, null, Arrays.asList(options));
    }

    private Map<StorageRpc.Option, ?> optionMap(Long generation, Long metaGeneration, Option ... options) {
        return this.optionMap(generation, metaGeneration, Arrays.asList(options));
    }

    private Map<StorageRpc.Option, ?> optionMap(BucketInfo bucketInfo, Option ... options) {
        return this.optionMap(null, bucketInfo.metageneration(), options);
    }

    private Map<StorageRpc.Option, ?> optionMap(BlobInfo blobInfo, Option ... options) {
        return this.optionMap(blobInfo.generation(), blobInfo.metageneration(), options);
    }

    private Map<StorageRpc.Option, ?> optionMap(BlobId blobId, Option ... options) {
        return this.optionMap(blobId.generation(), null, options);
    }

    private static class BlobPageFetcher
    implements PageImpl.NextPageFetcher<BlobInfo> {
        private static final long serialVersionUID = 81807334445874098L;
        private final Map<StorageRpc.Option, ?> requestOptions;
        private final StorageOptions serviceOptions;
        private final String bucket;

        BlobPageFetcher(String bucket, StorageOptions serviceOptions, String cursor, Map<StorageRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)StorageRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.bucket = bucket;
        }

        public Page<BlobInfo> nextPage() {
            return StorageImpl.listBlobs(this.bucket, this.serviceOptions, this.requestOptions);
        }
    }

    private static class BucketPageFetcher
    implements PageImpl.NextPageFetcher<BucketInfo> {
        private static final long serialVersionUID = 5850406828803613729L;
        private final Map<StorageRpc.Option, ?> requestOptions;
        private final StorageOptions serviceOptions;

        BucketPageFetcher(StorageOptions serviceOptions, String cursor, Map<StorageRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)StorageRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<BucketInfo> nextPage() {
            return StorageImpl.listBuckets(this.serviceOptions, this.requestOptions);
        }
    }
}

