/*
 * Decompiled with CFR 0.152.
 */
package com.google.gcloud.storage;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.gcloud.ServiceOptions;
import com.google.gcloud.spi.DefaultStorageRpc;
import com.google.gcloud.spi.StorageRpc;
import com.google.gcloud.spi.StorageRpcFactory;
import com.google.gcloud.storage.Storage;
import com.google.gcloud.storage.StorageFactory;
import com.google.gcloud.storage.StorageImpl;
import java.util.Objects;
import java.util.Set;

public class StorageOptions
extends ServiceOptions<Storage, StorageRpc, StorageOptions> {
    private static final long serialVersionUID = -7804860602287801084L;
    private static final String GCS_SCOPE = "https://www.googleapis.com/auth/devstorage.full_control";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/devstorage.full_control");
    private static final String DEFAULT_PATH_DELIMITER = "/";
    private final String pathDelimiter;

    private StorageOptions(Builder builder) {
        super(StorageFactory.class, StorageRpcFactory.class, (ServiceOptions.Builder)builder);
        this.pathDelimiter = (String)MoreObjects.firstNonNull((Object)builder.pathDelimiter, (Object)DEFAULT_PATH_DELIMITER);
    }

    protected StorageFactory defaultServiceFactory() {
        return DefaultStorageFactory.INSTANCE;
    }

    protected StorageRpcFactory defaultRpcFactory() {
        return DefaultStorageRpcFactory.INSTANCE;
    }

    protected Set<String> scopes() {
        return SCOPES;
    }

    public String pathDelimiter() {
        return this.pathDelimiter;
    }

    public static StorageOptions defaultInstance() {
        return StorageOptions.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return this.baseHashCode() ^ Objects.hash(this.pathDelimiter);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StorageOptions)) {
            return false;
        }
        StorageOptions other = (StorageOptions)((Object)obj);
        return this.baseEquals(other) && Objects.equals(this.pathDelimiter, other.pathDelimiter);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceOptions.Builder<Storage, StorageRpc, StorageOptions, Builder> {
        private String pathDelimiter;

        private Builder() {
        }

        private Builder(StorageOptions options) {
            super((ServiceOptions)options);
            this.pathDelimiter = options.pathDelimiter;
        }

        public Builder pathDelimiter(String pathDelimiter) {
            this.pathDelimiter = pathDelimiter;
            return this;
        }

        public StorageOptions build() {
            return new StorageOptions(this);
        }
    }

    public static class DefaultStorageRpcFactory
    implements StorageRpcFactory {
        private static final StorageRpcFactory INSTANCE = new DefaultStorageRpcFactory();

        public StorageRpc create(StorageOptions options) {
            return new DefaultStorageRpc(options);
        }
    }

    public static class DefaultStorageFactory
    implements StorageFactory {
        private static final StorageFactory INSTANCE = new DefaultStorageFactory();

        public Storage create(StorageOptions options) {
            return new StorageImpl(options);
        }
    }
}

