/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_GenerateContentResponse;
import com.google.genai.types.Candidate;
import com.google.genai.types.Content;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.GenerateContentResponsePromptFeedback;
import com.google.genai.types.GenerateContentResponseUsageMetadata;
import com.google.genai.types.Part;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

@JsonDeserialize(builder=AutoValue_GenerateContentResponse.Builder.class)
@AutoValue
public abstract class GenerateContentResponse
extends JsonSerializable {
    private static final Logger logger = Logger.getLogger(GenerateContentResponse.class.getName());
    private static final ImmutableList<String> EXPECTED_FINISH_REASONS = ImmutableList.of((Object)"FINISH_REASON_UNSPECIFIED", (Object)"STOP", (Object)"MAX_TOKENS", (Object)"");

    @JsonProperty(value="candidates")
    public abstract Optional<List<Candidate>> candidates();

    @JsonProperty(value="modelVersion")
    public abstract Optional<String> modelVersion();

    @JsonProperty(value="promptFeedback")
    public abstract Optional<GenerateContentResponsePromptFeedback> promptFeedback();

    @JsonProperty(value="usageMetadata")
    public abstract Optional<GenerateContentResponseUsageMetadata> usageMetadata();

    public static Builder builder() {
        return new AutoValue_GenerateContentResponse.Builder();
    }

    public abstract Builder toBuilder();

    public static GenerateContentResponse fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, GenerateContentResponse.class);
    }

    public @Nullable ImmutableList<Part> parts() {
        this.checkFinishReason();
        Optional<List<Candidate>> candidates = this.candidates();
        if (candidates.isEmpty() || candidates.get().isEmpty()) {
            return null;
        }
        Optional<Content> content = candidates.get().get(0).content();
        if (content.isEmpty()) {
            return null;
        }
        return ImmutableList.copyOf((Collection)content.get().parts().orElse(new ArrayList()));
    }

    public @Nullable String text() {
        ImmutableList<Part> parts = this.parts();
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        String text = "";
        for (Part part : parts) {
            if (part.inlineData().isPresent() || part.codeExecutionResult().isPresent() || part.executableCode().isPresent() || part.fileData().isPresent() || part.functionCall().isPresent() || part.functionResponse().isPresent()) {
                throw new IllegalArgumentException(String.format("Only text parts are supported, but got %s", part));
            }
            if (part.thought().orElse(false).booleanValue()) continue;
            text = text + part.text().orElse("");
        }
        return text;
    }

    public @Nullable ImmutableList<FunctionCall> functionCalls() {
        ImmutableList<Part> parts = this.parts();
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        return ImmutableList.copyOf((Collection)parts.stream().filter(part -> part.functionCall().isPresent()).map(part -> part.functionCall().get()).collect(Collectors.toList()));
    }

    public @Nullable String executableCode() {
        ImmutableList<Part> parts = this.parts();
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        for (Part part : parts) {
            if (!part.executableCode().isPresent()) continue;
            return part.executableCode().get().code().orElse("");
        }
        return null;
    }

    public @Nullable String codeExecutionResult() {
        ImmutableList<Part> parts = this.parts();
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        for (Part part : parts) {
            if (!part.codeExecutionResult().isPresent()) continue;
            return part.codeExecutionResult().get().output().orElse("");
        }
        return null;
    }

    private String finishReason() {
        List<Candidate> candidates = this.candidates().orElse(Arrays.asList(Candidate.builder().build()));
        if (candidates.size() > 1) {
            logger.warning(String.format("This response has %d candidates, will only use the first candidate", candidates.size()));
        }
        return candidates.get(0).finishReason().orElse("");
    }

    private void checkFinishReason() {
        String finishReason = this.finishReason();
        if (!EXPECTED_FINISH_REASONS.contains((Object)finishReason)) {
            throw new IllegalArgumentException(String.format("The response finished unexpectedly with reason %s.", finishReason));
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty(value="candidates")
        public abstract Builder candidates(List<Candidate> var1);

        @JsonProperty(value="modelVersion")
        public abstract Builder modelVersion(String var1);

        @JsonProperty(value="promptFeedback")
        public abstract Builder promptFeedback(GenerateContentResponsePromptFeedback var1);

        @JsonProperty(value="usageMetadata")
        public abstract Builder usageMetadata(GenerateContentResponseUsageMetadata var1);

        public abstract GenerateContentResponse build();
    }
}

