package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CreateAuthTokenConfig extends CreateAuthTokenConfig {

  private final Optional<HttpOptions> httpOptions;

  private final Optional<Instant> expireTime;

  private final Optional<Instant> newSessionExpireTime;

  private final Optional<Integer> uses;

  private final Optional<LiveEphemeralParameters> liveEphemeralParameters;

  private final Optional<List<String>> lockAdditionalFields;

  private AutoValue_CreateAuthTokenConfig(
      Optional<HttpOptions> httpOptions,
      Optional<Instant> expireTime,
      Optional<Instant> newSessionExpireTime,
      Optional<Integer> uses,
      Optional<LiveEphemeralParameters> liveEphemeralParameters,
      Optional<List<String>> lockAdditionalFields) {
    this.httpOptions = httpOptions;
    this.expireTime = expireTime;
    this.newSessionExpireTime = newSessionExpireTime;
    this.uses = uses;
    this.liveEphemeralParameters = liveEphemeralParameters;
    this.lockAdditionalFields = lockAdditionalFields;
  }

  @JsonProperty("httpOptions")
  @Override
  public Optional<HttpOptions> httpOptions() {
    return httpOptions;
  }

  @JsonProperty("expireTime")
  @Override
  public Optional<Instant> expireTime() {
    return expireTime;
  }

  @JsonProperty("newSessionExpireTime")
  @Override
  public Optional<Instant> newSessionExpireTime() {
    return newSessionExpireTime;
  }

  @JsonProperty("uses")
  @Override
  public Optional<Integer> uses() {
    return uses;
  }

  @JsonProperty("liveEphemeralParameters")
  @Override
  public Optional<LiveEphemeralParameters> liveEphemeralParameters() {
    return liveEphemeralParameters;
  }

  @JsonProperty("lockAdditionalFields")
  @Override
  public Optional<List<String>> lockAdditionalFields() {
    return lockAdditionalFields;
  }

  @Override
  public String toString() {
    return "CreateAuthTokenConfig{"
        + "httpOptions=" + httpOptions + ", "
        + "expireTime=" + expireTime + ", "
        + "newSessionExpireTime=" + newSessionExpireTime + ", "
        + "uses=" + uses + ", "
        + "liveEphemeralParameters=" + liveEphemeralParameters + ", "
        + "lockAdditionalFields=" + lockAdditionalFields
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CreateAuthTokenConfig) {
      CreateAuthTokenConfig that = (CreateAuthTokenConfig) o;
      return this.httpOptions.equals(that.httpOptions())
          && this.expireTime.equals(that.expireTime())
          && this.newSessionExpireTime.equals(that.newSessionExpireTime())
          && this.uses.equals(that.uses())
          && this.liveEphemeralParameters.equals(that.liveEphemeralParameters())
          && this.lockAdditionalFields.equals(that.lockAdditionalFields());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= httpOptions.hashCode();
    h$ *= 1000003;
    h$ ^= expireTime.hashCode();
    h$ *= 1000003;
    h$ ^= newSessionExpireTime.hashCode();
    h$ *= 1000003;
    h$ ^= uses.hashCode();
    h$ *= 1000003;
    h$ ^= liveEphemeralParameters.hashCode();
    h$ *= 1000003;
    h$ ^= lockAdditionalFields.hashCode();
    return h$;
  }

  @Override
  public CreateAuthTokenConfig.Builder toBuilder() {
    return new AutoValue_CreateAuthTokenConfig.Builder(this);
  }

  static final class Builder extends CreateAuthTokenConfig.Builder {
    private Optional<HttpOptions> httpOptions = Optional.empty();
    private Optional<Instant> expireTime = Optional.empty();
    private Optional<Instant> newSessionExpireTime = Optional.empty();
    private Optional<Integer> uses = Optional.empty();
    private Optional<LiveEphemeralParameters> liveEphemeralParameters = Optional.empty();
    private Optional<List<String>> lockAdditionalFields = Optional.empty();
    Builder() {
    }
    Builder(CreateAuthTokenConfig source) {
      this.httpOptions = source.httpOptions();
      this.expireTime = source.expireTime();
      this.newSessionExpireTime = source.newSessionExpireTime();
      this.uses = source.uses();
      this.liveEphemeralParameters = source.liveEphemeralParameters();
      this.lockAdditionalFields = source.lockAdditionalFields();
    }
    @Override
    public CreateAuthTokenConfig.Builder httpOptions(HttpOptions httpOptions) {
      this.httpOptions = Optional.of(httpOptions);
      return this;
    }
    @Override
    public CreateAuthTokenConfig.Builder expireTime(Instant expireTime) {
      this.expireTime = Optional.of(expireTime);
      return this;
    }
    @Override
    public CreateAuthTokenConfig.Builder newSessionExpireTime(Instant newSessionExpireTime) {
      this.newSessionExpireTime = Optional.of(newSessionExpireTime);
      return this;
    }
    @Override
    public CreateAuthTokenConfig.Builder uses(Integer uses) {
      this.uses = Optional.of(uses);
      return this;
    }
    @Override
    public CreateAuthTokenConfig.Builder liveEphemeralParameters(LiveEphemeralParameters liveEphemeralParameters) {
      this.liveEphemeralParameters = Optional.of(liveEphemeralParameters);
      return this;
    }
    @Override
    public CreateAuthTokenConfig.Builder lockAdditionalFields(List<String> lockAdditionalFields) {
      this.lockAdditionalFields = Optional.of(lockAdditionalFields);
      return this;
    }
    @Override
    public CreateAuthTokenConfig build() {
      return new AutoValue_CreateAuthTokenConfig(
          this.httpOptions,
          this.expireTime,
          this.newSessionExpireTime,
          this.uses,
          this.liveEphemeralParameters,
          this.lockAdditionalFields);
    }
  }

}
