/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Auto-generated code. Do not edit.

package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.genai.JsonSerializable;
import java.util.Optional;

/**
 * Incremental server update generated by the model in response to client messages.
 *
 * <p>Content is generated as quickly as possible, and not in real time. Clients may choose to
 * buffer and play it out in real time.
 */
@AutoValue
@JsonDeserialize(builder = LiveServerContent.Builder.class)
public abstract class LiveServerContent extends JsonSerializable {
  /** The content that the model has generated as part of the current conversation with the user. */
  @JsonProperty("modelTurn")
  public abstract Optional<Content> modelTurn();

  /**
   * If true, indicates that the model is done generating. Generation will only start in response to
   * additional client messages. Can be set alongside `content`, indicating that the `content` is
   * the last in the turn.
   */
  @JsonProperty("turnComplete")
  public abstract Optional<Boolean> turnComplete();

  /**
   * If true, indicates that a client message has interrupted current model generation. If the
   * client is playing out the content in realtime, this is a good signal to stop and empty the
   * current queue.
   */
  @JsonProperty("interrupted")
  public abstract Optional<Boolean> interrupted();

  /** Metadata returned to client when grounding is enabled. */
  @JsonProperty("groundingMetadata")
  public abstract Optional<GroundingMetadata> groundingMetadata();

  /**
   * If true, indicates that the model is done generating. When model is interrupted while
   * generating there will be no generation_complete message in interrupted turn, it will go through
   * interrupted > turn_complete. When model assumes realtime playback there will be delay between
   * generation_complete and turn_complete that is caused by model waiting for playback to finish.
   * If true, indicates that the model has finished generating all content. This is a signal to the
   * client that it can stop sending messages.
   */
  @JsonProperty("generationComplete")
  public abstract Optional<Boolean> generationComplete();

  /**
   * Input transcription. The transcription is independent to the model turn which means it doesn’t
   * imply any ordering between transcription and model turn.
   */
  @JsonProperty("inputTranscription")
  public abstract Optional<Transcription> inputTranscription();

  /**
   * Output transcription. The transcription is independent to the model turn which means it doesn’t
   * imply any ordering between transcription and model turn.
   */
  @JsonProperty("outputTranscription")
  public abstract Optional<Transcription> outputTranscription();

  /** Metadata related to url context retrieval tool. */
  @JsonProperty("urlContextMetadata")
  public abstract Optional<UrlContextMetadata> urlContextMetadata();

  /** Instantiates a builder for LiveServerContent. */
  public static Builder builder() {
    return new AutoValue_LiveServerContent.Builder();
  }

  /** Creates a builder with the same values as this instance. */
  public abstract Builder toBuilder();

  /** Builder for LiveServerContent. */
  @AutoValue.Builder
  public abstract static class Builder {
    /** For internal usage. Please use `LiveServerContent.builder()` for instantiation. */
    @JsonCreator
    private static Builder create() {
      return new AutoValue_LiveServerContent.Builder();
    }

    @JsonProperty("modelTurn")
    public abstract Builder modelTurn(Content modelTurn);

    @JsonProperty("turnComplete")
    public abstract Builder turnComplete(boolean turnComplete);

    @JsonProperty("interrupted")
    public abstract Builder interrupted(boolean interrupted);

    @JsonProperty("groundingMetadata")
    public abstract Builder groundingMetadata(GroundingMetadata groundingMetadata);

    @JsonProperty("generationComplete")
    public abstract Builder generationComplete(boolean generationComplete);

    @JsonProperty("inputTranscription")
    public abstract Builder inputTranscription(Transcription inputTranscription);

    @JsonProperty("outputTranscription")
    public abstract Builder outputTranscription(Transcription outputTranscription);

    @JsonProperty("urlContextMetadata")
    public abstract Builder urlContextMetadata(UrlContextMetadata urlContextMetadata);

    public abstract LiveServerContent build();
  }

  /** Deserializes a JSON string to a LiveServerContent object. */
  public static LiveServerContent fromJson(String jsonString) {
    return JsonSerializable.fromJsonString(jsonString, LiveServerContent.class);
  }
}
