/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.AsyncLive;
import com.google.genai.JsonSerializable;
import com.google.genai.LiveConverters;
import com.google.genai.types.LiveClientContent;
import com.google.genai.types.LiveClientMessage;
import com.google.genai.types.LiveClientToolResponse;
import com.google.genai.types.LiveSendClientContentParameters;
import com.google.genai.types.LiveSendRealtimeInputParameters;
import com.google.genai.types.LiveSendToolResponseParameters;
import com.google.genai.types.LiveServerMessage;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public final class AsyncSession {
    private final ApiClient apiClient;
    private final AsyncLive.GenAiWebSocketClient websocket;

    AsyncSession(ApiClient apiClient, AsyncLive.GenAiWebSocketClient websocket) {
        this.apiClient = apiClient;
        this.websocket = websocket;
    }

    public CompletableFuture<Void> sendClientContent(LiveSendClientContentParameters clientContent) {
        return this.send(LiveClientMessage.builder().clientContent(LiveClientContent.fromJson(clientContent.toJson())).build());
    }

    public CompletableFuture<Void> sendRealtimeInput(LiveSendRealtimeInputParameters realtimeInput) {
        LiveClientMessage msg = LiveClientMessage.builder().realtimeInputParameters(realtimeInput).build();
        return this.send(msg);
    }

    public CompletableFuture<Void> sendToolResponse(LiveSendToolResponseParameters toolResponse) {
        return this.send(LiveClientMessage.builder().toolResponse(LiveClientToolResponse.fromJson(toolResponse.toJson())).build());
    }

    private CompletableFuture<Void> send(LiveClientMessage input) {
        LiveConverters liveConverters = new LiveConverters(this.apiClient);
        JsonNode parameterNode = JsonSerializable.toJsonNode(input);
        ObjectNode body = this.apiClient.vertexAI() ? liveConverters.liveClientMessageToVertex(this.apiClient, parameterNode, null) : liveConverters.liveClientMessageToMldev(this.apiClient, parameterNode, null);
        return CompletableFuture.runAsync(() -> this.websocket.send(JsonSerializable.toJsonString(body)));
    }

    public CompletableFuture<Void> receive(Consumer<LiveServerMessage> onMessage) {
        this.websocket.setMessageCallback(onMessage);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> close() {
        return CompletableFuture.runAsync(() -> this.websocket.close());
    }
}

