/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Ascii;
import java.util.Objects;

public class Type {
    private Known typeEnum;
    private final String value;

    @JsonCreator
    public Type(String value) {
        this.value = value;
        for (Known typeEnum : Known.values()) {
            if (!Ascii.equalsIgnoreCase((CharSequence)typeEnum.toString(), (CharSequence)value)) continue;
            this.typeEnum = typeEnum;
            break;
        }
        if (this.typeEnum == null) {
            this.typeEnum = Known.TYPE_UNSPECIFIED;
        }
    }

    public Type(Known knownValue) {
        this.typeEnum = knownValue;
        this.value = knownValue.toString();
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Type)) {
            return false;
        }
        Type other = (Type)o;
        if (this.typeEnum != Known.TYPE_UNSPECIFIED && other.typeEnum != Known.TYPE_UNSPECIFIED) {
            return this.typeEnum == other.typeEnum;
        }
        if (this.typeEnum == Known.TYPE_UNSPECIFIED && other.typeEnum == Known.TYPE_UNSPECIFIED) {
            return this.value.equals(other.value);
        }
        return false;
    }

    public int hashCode() {
        if (this.typeEnum != Known.TYPE_UNSPECIFIED) {
            return this.typeEnum.hashCode();
        }
        return Objects.hashCode(this.value);
    }

    public Known knownEnum() {
        return this.typeEnum;
    }

    public static enum Known {
        TYPE_UNSPECIFIED,
        STRING,
        NUMBER,
        INTEGER,
        BOOLEAN,
        ARRAY,
        OBJECT;

    }
}

