/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_UsageMetadata;
import com.google.genai.types.ModalityTokenCount;
import com.google.genai.types.TrafficType;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class UsageMetadata
extends JsonSerializable {
    @JsonProperty(value="promptTokenCount")
    public abstract Optional<Integer> promptTokenCount();

    @JsonProperty(value="cachedContentTokenCount")
    public abstract Optional<Integer> cachedContentTokenCount();

    @JsonProperty(value="responseTokenCount")
    public abstract Optional<Integer> responseTokenCount();

    @JsonProperty(value="toolUsePromptTokenCount")
    public abstract Optional<Integer> toolUsePromptTokenCount();

    @JsonProperty(value="thoughtsTokenCount")
    public abstract Optional<Integer> thoughtsTokenCount();

    @JsonProperty(value="totalTokenCount")
    public abstract Optional<Integer> totalTokenCount();

    @JsonProperty(value="promptTokensDetails")
    public abstract Optional<List<ModalityTokenCount>> promptTokensDetails();

    @JsonProperty(value="cacheTokensDetails")
    public abstract Optional<List<ModalityTokenCount>> cacheTokensDetails();

    @JsonProperty(value="responseTokensDetails")
    public abstract Optional<List<ModalityTokenCount>> responseTokensDetails();

    @JsonProperty(value="toolUsePromptTokensDetails")
    public abstract Optional<List<ModalityTokenCount>> toolUsePromptTokensDetails();

    @JsonProperty(value="trafficType")
    public abstract Optional<TrafficType> trafficType();

    public static Builder builder() {
        return new AutoValue_UsageMetadata.Builder();
    }

    public abstract Builder toBuilder();

    public static UsageMetadata fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, UsageMetadata.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_UsageMetadata.Builder();
        }

        @JsonProperty(value="promptTokenCount")
        public abstract Builder promptTokenCount(Integer var1);

        @JsonProperty(value="cachedContentTokenCount")
        public abstract Builder cachedContentTokenCount(Integer var1);

        @JsonProperty(value="responseTokenCount")
        public abstract Builder responseTokenCount(Integer var1);

        @JsonProperty(value="toolUsePromptTokenCount")
        public abstract Builder toolUsePromptTokenCount(Integer var1);

        @JsonProperty(value="thoughtsTokenCount")
        public abstract Builder thoughtsTokenCount(Integer var1);

        @JsonProperty(value="totalTokenCount")
        public abstract Builder totalTokenCount(Integer var1);

        @JsonProperty(value="promptTokensDetails")
        public abstract Builder promptTokensDetails(List<ModalityTokenCount> var1);

        @JsonProperty(value="cacheTokensDetails")
        public abstract Builder cacheTokensDetails(List<ModalityTokenCount> var1);

        @JsonProperty(value="responseTokensDetails")
        public abstract Builder responseTokensDetails(List<ModalityTokenCount> var1);

        @JsonProperty(value="toolUsePromptTokensDetails")
        public abstract Builder toolUsePromptTokensDetails(List<ModalityTokenCount> var1);

        @JsonProperty(value="trafficType")
        public abstract Builder trafficType(TrafficType var1);

        @CanIgnoreReturnValue
        public Builder trafficType(TrafficType.Known knownType) {
            return this.trafficType(new TrafficType(knownType));
        }

        @CanIgnoreReturnValue
        public Builder trafficType(String trafficType) {
            return this.trafficType(new TrafficType(trafficType));
        }

        public abstract UsageMetadata build();
    }
}

