package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_DistillationSpec extends DistillationSpec {

  private final Optional<String> baseTeacherModel;

  private final Optional<DistillationHyperParameters> hyperParameters;

  private final Optional<String> pipelineRootDirectory;

  private final Optional<String> studentModel;

  private final Optional<String> trainingDatasetUri;

  private final Optional<String> tunedTeacherModelSource;

  private final Optional<String> validationDatasetUri;

  private AutoValue_DistillationSpec(
      Optional<String> baseTeacherModel,
      Optional<DistillationHyperParameters> hyperParameters,
      Optional<String> pipelineRootDirectory,
      Optional<String> studentModel,
      Optional<String> trainingDatasetUri,
      Optional<String> tunedTeacherModelSource,
      Optional<String> validationDatasetUri) {
    this.baseTeacherModel = baseTeacherModel;
    this.hyperParameters = hyperParameters;
    this.pipelineRootDirectory = pipelineRootDirectory;
    this.studentModel = studentModel;
    this.trainingDatasetUri = trainingDatasetUri;
    this.tunedTeacherModelSource = tunedTeacherModelSource;
    this.validationDatasetUri = validationDatasetUri;
  }

  @JsonProperty("baseTeacherModel")
  @Override
  public Optional<String> baseTeacherModel() {
    return baseTeacherModel;
  }

  @JsonProperty("hyperParameters")
  @Override
  public Optional<DistillationHyperParameters> hyperParameters() {
    return hyperParameters;
  }

  @JsonProperty("pipelineRootDirectory")
  @Override
  public Optional<String> pipelineRootDirectory() {
    return pipelineRootDirectory;
  }

  @JsonProperty("studentModel")
  @Override
  public Optional<String> studentModel() {
    return studentModel;
  }

  @JsonProperty("trainingDatasetUri")
  @Override
  public Optional<String> trainingDatasetUri() {
    return trainingDatasetUri;
  }

  @JsonProperty("tunedTeacherModelSource")
  @Override
  public Optional<String> tunedTeacherModelSource() {
    return tunedTeacherModelSource;
  }

  @JsonProperty("validationDatasetUri")
  @Override
  public Optional<String> validationDatasetUri() {
    return validationDatasetUri;
  }

  @Override
  public String toString() {
    return "DistillationSpec{"
        + "baseTeacherModel=" + baseTeacherModel + ", "
        + "hyperParameters=" + hyperParameters + ", "
        + "pipelineRootDirectory=" + pipelineRootDirectory + ", "
        + "studentModel=" + studentModel + ", "
        + "trainingDatasetUri=" + trainingDatasetUri + ", "
        + "tunedTeacherModelSource=" + tunedTeacherModelSource + ", "
        + "validationDatasetUri=" + validationDatasetUri
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DistillationSpec) {
      DistillationSpec that = (DistillationSpec) o;
      return this.baseTeacherModel.equals(that.baseTeacherModel())
          && this.hyperParameters.equals(that.hyperParameters())
          && this.pipelineRootDirectory.equals(that.pipelineRootDirectory())
          && this.studentModel.equals(that.studentModel())
          && this.trainingDatasetUri.equals(that.trainingDatasetUri())
          && this.tunedTeacherModelSource.equals(that.tunedTeacherModelSource())
          && this.validationDatasetUri.equals(that.validationDatasetUri());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= baseTeacherModel.hashCode();
    h$ *= 1000003;
    h$ ^= hyperParameters.hashCode();
    h$ *= 1000003;
    h$ ^= pipelineRootDirectory.hashCode();
    h$ *= 1000003;
    h$ ^= studentModel.hashCode();
    h$ *= 1000003;
    h$ ^= trainingDatasetUri.hashCode();
    h$ *= 1000003;
    h$ ^= tunedTeacherModelSource.hashCode();
    h$ *= 1000003;
    h$ ^= validationDatasetUri.hashCode();
    return h$;
  }

  @Override
  public DistillationSpec.Builder toBuilder() {
    return new AutoValue_DistillationSpec.Builder(this);
  }

  static final class Builder extends DistillationSpec.Builder {
    private Optional<String> baseTeacherModel = Optional.empty();
    private Optional<DistillationHyperParameters> hyperParameters = Optional.empty();
    private Optional<String> pipelineRootDirectory = Optional.empty();
    private Optional<String> studentModel = Optional.empty();
    private Optional<String> trainingDatasetUri = Optional.empty();
    private Optional<String> tunedTeacherModelSource = Optional.empty();
    private Optional<String> validationDatasetUri = Optional.empty();
    Builder() {
    }
    Builder(DistillationSpec source) {
      this.baseTeacherModel = source.baseTeacherModel();
      this.hyperParameters = source.hyperParameters();
      this.pipelineRootDirectory = source.pipelineRootDirectory();
      this.studentModel = source.studentModel();
      this.trainingDatasetUri = source.trainingDatasetUri();
      this.tunedTeacherModelSource = source.tunedTeacherModelSource();
      this.validationDatasetUri = source.validationDatasetUri();
    }
    @Override
    public DistillationSpec.Builder baseTeacherModel(String baseTeacherModel) {
      this.baseTeacherModel = Optional.of(baseTeacherModel);
      return this;
    }
    @Override
    public DistillationSpec.Builder hyperParameters(DistillationHyperParameters hyperParameters) {
      this.hyperParameters = Optional.of(hyperParameters);
      return this;
    }
    @Override
    public DistillationSpec.Builder pipelineRootDirectory(String pipelineRootDirectory) {
      this.pipelineRootDirectory = Optional.of(pipelineRootDirectory);
      return this;
    }
    @Override
    public DistillationSpec.Builder studentModel(String studentModel) {
      this.studentModel = Optional.of(studentModel);
      return this;
    }
    @Override
    public DistillationSpec.Builder trainingDatasetUri(String trainingDatasetUri) {
      this.trainingDatasetUri = Optional.of(trainingDatasetUri);
      return this;
    }
    @Override
    public DistillationSpec.Builder tunedTeacherModelSource(String tunedTeacherModelSource) {
      this.tunedTeacherModelSource = Optional.of(tunedTeacherModelSource);
      return this;
    }
    @Override
    public DistillationSpec.Builder validationDatasetUri(String validationDatasetUri) {
      this.validationDatasetUri = Optional.of(validationDatasetUri);
      return this;
    }
    @Override
    public DistillationSpec build() {
      return new AutoValue_DistillationSpec(
          this.baseTeacherModel,
          this.hyperParameters,
          this.pipelineRootDirectory,
          this.studentModel,
          this.trainingDatasetUri,
          this.tunedTeacherModelSource,
          this.validationDatasetUri);
    }
  }

}
