/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.TuningDataset;
import com.google.genai.types.TuningExample;
import java.util.List;
import java.util.Optional;

final class AutoValue_TuningDataset
extends TuningDataset {
    private final Optional<String> gcsUri;
    private final Optional<String> vertexDatasetResource;
    private final Optional<List<TuningExample>> examples;

    private AutoValue_TuningDataset(Optional<String> gcsUri, Optional<String> vertexDatasetResource, Optional<List<TuningExample>> examples) {
        this.gcsUri = gcsUri;
        this.vertexDatasetResource = vertexDatasetResource;
        this.examples = examples;
    }

    @Override
    @JsonProperty(value="gcsUri")
    public Optional<String> gcsUri() {
        return this.gcsUri;
    }

    @Override
    @JsonProperty(value="vertexDatasetResource")
    public Optional<String> vertexDatasetResource() {
        return this.vertexDatasetResource;
    }

    @Override
    @JsonProperty(value="examples")
    public Optional<List<TuningExample>> examples() {
        return this.examples;
    }

    public String toString() {
        return "TuningDataset{gcsUri=" + this.gcsUri + ", vertexDatasetResource=" + this.vertexDatasetResource + ", examples=" + this.examples + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TuningDataset) {
            TuningDataset that = (TuningDataset)o;
            return this.gcsUri.equals(that.gcsUri()) && this.vertexDatasetResource.equals(that.vertexDatasetResource()) && this.examples.equals(that.examples());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.gcsUri.hashCode();
        h$ *= 1000003;
        h$ ^= this.vertexDatasetResource.hashCode();
        h$ *= 1000003;
        return h$ ^= this.examples.hashCode();
    }

    @Override
    public TuningDataset.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends TuningDataset.Builder {
        private Optional<String> gcsUri = Optional.empty();
        private Optional<String> vertexDatasetResource = Optional.empty();
        private Optional<List<TuningExample>> examples = Optional.empty();

        Builder() {
        }

        Builder(TuningDataset source) {
            this.gcsUri = source.gcsUri();
            this.vertexDatasetResource = source.vertexDatasetResource();
            this.examples = source.examples();
        }

        @Override
        public TuningDataset.Builder gcsUri(String gcsUri) {
            this.gcsUri = Optional.of(gcsUri);
            return this;
        }

        @Override
        public TuningDataset.Builder vertexDatasetResource(String vertexDatasetResource) {
            this.vertexDatasetResource = Optional.of(vertexDatasetResource);
            return this;
        }

        @Override
        public TuningDataset.Builder examples(List<TuningExample> examples) {
            this.examples = Optional.of(examples);
            return this;
        }

        @Override
        public TuningDataset build() {
            return new AutoValue_TuningDataset(this.gcsUri, this.vertexDatasetResource, this.examples);
        }
    }
}

