/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_DatasetStats;
import com.google.genai.types.Content;
import com.google.genai.types.DatasetDistribution;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class DatasetStats
extends JsonSerializable {
    @JsonProperty(value="totalBillableCharacterCount")
    public abstract Optional<Long> totalBillableCharacterCount();

    @JsonProperty(value="totalTuningCharacterCount")
    public abstract Optional<Long> totalTuningCharacterCount();

    @JsonProperty(value="tuningDatasetExampleCount")
    public abstract Optional<Long> tuningDatasetExampleCount();

    @JsonProperty(value="tuningStepCount")
    public abstract Optional<Long> tuningStepCount();

    @JsonProperty(value="userDatasetExamples")
    public abstract Optional<List<Content>> userDatasetExamples();

    @JsonProperty(value="userInputTokenDistribution")
    public abstract Optional<DatasetDistribution> userInputTokenDistribution();

    @JsonProperty(value="userMessagePerExampleDistribution")
    public abstract Optional<DatasetDistribution> userMessagePerExampleDistribution();

    @JsonProperty(value="userOutputTokenDistribution")
    public abstract Optional<DatasetDistribution> userOutputTokenDistribution();

    public static Builder builder() {
        return new AutoValue_DatasetStats.Builder();
    }

    public abstract Builder toBuilder();

    public static DatasetStats fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, DatasetStats.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_DatasetStats.Builder();
        }

        @JsonProperty(value="totalBillableCharacterCount")
        public abstract Builder totalBillableCharacterCount(Long var1);

        @JsonProperty(value="totalTuningCharacterCount")
        public abstract Builder totalTuningCharacterCount(Long var1);

        @JsonProperty(value="tuningDatasetExampleCount")
        public abstract Builder tuningDatasetExampleCount(Long var1);

        @JsonProperty(value="tuningStepCount")
        public abstract Builder tuningStepCount(Long var1);

        @JsonProperty(value="userDatasetExamples")
        public abstract Builder userDatasetExamples(List<Content> var1);

        public Builder userDatasetExamples(Content ... userDatasetExamples) {
            return this.userDatasetExamples(Arrays.asList(userDatasetExamples));
        }

        public Builder userDatasetExamples(Content.Builder ... userDatasetExamplesBuilders) {
            return this.userDatasetExamples((List)Arrays.asList(userDatasetExamplesBuilders).stream().map(Content.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @JsonProperty(value="userInputTokenDistribution")
        public abstract Builder userInputTokenDistribution(DatasetDistribution var1);

        public Builder userInputTokenDistribution(DatasetDistribution.Builder userInputTokenDistributionBuilder) {
            return this.userInputTokenDistribution(userInputTokenDistributionBuilder.build());
        }

        @JsonProperty(value="userMessagePerExampleDistribution")
        public abstract Builder userMessagePerExampleDistribution(DatasetDistribution var1);

        public Builder userMessagePerExampleDistribution(DatasetDistribution.Builder userMessagePerExampleDistributionBuilder) {
            return this.userMessagePerExampleDistribution(userMessagePerExampleDistributionBuilder.build());
        }

        @JsonProperty(value="userOutputTokenDistribution")
        public abstract Builder userOutputTokenDistribution(DatasetDistribution var1);

        public Builder userOutputTokenDistribution(DatasetDistribution.Builder userOutputTokenDistributionBuilder) {
            return this.userOutputTokenDistribution(userOutputTokenDistributionBuilder.build());
        }

        public abstract DatasetStats build();
    }
}

