/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_TuningJob;
import com.google.genai.types.DistillationSpec;
import com.google.genai.types.EncryptionSpec;
import com.google.genai.types.GoogleRpcStatus;
import com.google.genai.types.JobState;
import com.google.genai.types.PartnerModelTuningSpec;
import com.google.genai.types.SupervisedTuningSpec;
import com.google.genai.types.TunedModel;
import com.google.genai.types.TuningDataStats;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class TuningJob
extends JsonSerializable {
    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @JsonProperty(value="state")
    public abstract Optional<JobState> state();

    @JsonProperty(value="createTime")
    public abstract Optional<Instant> createTime();

    @JsonProperty(value="startTime")
    public abstract Optional<Instant> startTime();

    @JsonProperty(value="endTime")
    public abstract Optional<Instant> endTime();

    @JsonProperty(value="updateTime")
    public abstract Optional<Instant> updateTime();

    @JsonProperty(value="error")
    public abstract Optional<GoogleRpcStatus> error();

    @JsonProperty(value="description")
    public abstract Optional<String> description();

    @JsonProperty(value="baseModel")
    public abstract Optional<String> baseModel();

    @JsonProperty(value="tunedModel")
    public abstract Optional<TunedModel> tunedModel();

    @JsonProperty(value="supervisedTuningSpec")
    public abstract Optional<SupervisedTuningSpec> supervisedTuningSpec();

    @JsonProperty(value="tuningDataStats")
    public abstract Optional<TuningDataStats> tuningDataStats();

    @JsonProperty(value="encryptionSpec")
    public abstract Optional<EncryptionSpec> encryptionSpec();

    @JsonProperty(value="partnerModelTuningSpec")
    public abstract Optional<PartnerModelTuningSpec> partnerModelTuningSpec();

    @JsonProperty(value="distillationSpec")
    public abstract Optional<DistillationSpec> distillationSpec();

    @JsonProperty(value="experiment")
    public abstract Optional<String> experiment();

    @JsonProperty(value="labels")
    public abstract Optional<Map<String, String>> labels();

    @JsonProperty(value="pipelineJob")
    public abstract Optional<String> pipelineJob();

    @JsonProperty(value="satisfiesPzi")
    public abstract Optional<Boolean> satisfiesPzi();

    @JsonProperty(value="satisfiesPzs")
    public abstract Optional<Boolean> satisfiesPzs();

    @JsonProperty(value="serviceAccount")
    public abstract Optional<String> serviceAccount();

    @JsonProperty(value="tunedModelDisplayName")
    public abstract Optional<String> tunedModelDisplayName();

    public static Builder builder() {
        return new AutoValue_TuningJob.Builder();
    }

    public abstract Builder toBuilder();

    public static TuningJob fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, TuningJob.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_TuningJob.Builder();
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @JsonProperty(value="state")
        public abstract Builder state(JobState var1);

        @CanIgnoreReturnValue
        public Builder state(JobState.Known knownType) {
            return this.state(new JobState(knownType));
        }

        @CanIgnoreReturnValue
        public Builder state(String state) {
            return this.state(new JobState(state));
        }

        @JsonProperty(value="createTime")
        public abstract Builder createTime(Instant var1);

        @JsonProperty(value="startTime")
        public abstract Builder startTime(Instant var1);

        @JsonProperty(value="endTime")
        public abstract Builder endTime(Instant var1);

        @JsonProperty(value="updateTime")
        public abstract Builder updateTime(Instant var1);

        @JsonProperty(value="error")
        public abstract Builder error(GoogleRpcStatus var1);

        public Builder error(GoogleRpcStatus.Builder errorBuilder) {
            return this.error(errorBuilder.build());
        }

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @JsonProperty(value="baseModel")
        public abstract Builder baseModel(String var1);

        @JsonProperty(value="tunedModel")
        public abstract Builder tunedModel(TunedModel var1);

        public Builder tunedModel(TunedModel.Builder tunedModelBuilder) {
            return this.tunedModel(tunedModelBuilder.build());
        }

        @JsonProperty(value="supervisedTuningSpec")
        public abstract Builder supervisedTuningSpec(SupervisedTuningSpec var1);

        public Builder supervisedTuningSpec(SupervisedTuningSpec.Builder supervisedTuningSpecBuilder) {
            return this.supervisedTuningSpec(supervisedTuningSpecBuilder.build());
        }

        @JsonProperty(value="tuningDataStats")
        public abstract Builder tuningDataStats(TuningDataStats var1);

        public Builder tuningDataStats(TuningDataStats.Builder tuningDataStatsBuilder) {
            return this.tuningDataStats(tuningDataStatsBuilder.build());
        }

        @JsonProperty(value="encryptionSpec")
        public abstract Builder encryptionSpec(EncryptionSpec var1);

        public Builder encryptionSpec(EncryptionSpec.Builder encryptionSpecBuilder) {
            return this.encryptionSpec(encryptionSpecBuilder.build());
        }

        @JsonProperty(value="partnerModelTuningSpec")
        public abstract Builder partnerModelTuningSpec(PartnerModelTuningSpec var1);

        public Builder partnerModelTuningSpec(PartnerModelTuningSpec.Builder partnerModelTuningSpecBuilder) {
            return this.partnerModelTuningSpec(partnerModelTuningSpecBuilder.build());
        }

        @JsonProperty(value="distillationSpec")
        public abstract Builder distillationSpec(DistillationSpec var1);

        public Builder distillationSpec(DistillationSpec.Builder distillationSpecBuilder) {
            return this.distillationSpec(distillationSpecBuilder.build());
        }

        @JsonProperty(value="experiment")
        public abstract Builder experiment(String var1);

        @JsonProperty(value="labels")
        public abstract Builder labels(Map<String, String> var1);

        @JsonProperty(value="pipelineJob")
        public abstract Builder pipelineJob(String var1);

        @JsonProperty(value="satisfiesPzi")
        public abstract Builder satisfiesPzi(boolean var1);

        @JsonProperty(value="satisfiesPzs")
        public abstract Builder satisfiesPzs(boolean var1);

        @JsonProperty(value="serviceAccount")
        public abstract Builder serviceAccount(String var1);

        @JsonProperty(value="tunedModelDisplayName")
        public abstract Builder tunedModelDisplayName(String var1);

        public abstract TuningJob build();
    }
}

