/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.ApiResponse;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.ClientOptions;
import com.google.genai.types.HttpOptions;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jspecify.annotations.Nullable;

abstract class ApiClient {
    private static final String SDK_VERSION = "1.11.0";
    private static final Logger logger = Logger.getLogger(ApiClient.class.getName());
    private static final ImmutableSet<String> METHODS_WITH_BODY = ImmutableSet.of((Object)"POST", (Object)"PATCH", (Object)"PUT");
    private static final ImmutableSet<String> VALID_HTTP_METHODS = ImmutableSet.builder().addAll(METHODS_WITH_BODY).add((Object)"GET").add((Object)"DELETE").build();
    private static Optional<String> geminiBaseUrl = Optional.empty();
    private static Optional<String> vertexBaseUrl = Optional.empty();
    final OkHttpClient httpClient;
    HttpOptions httpOptions;
    final boolean vertexAI;
    final Optional<ClientOptions> clientOptions;
    final Optional<String> apiKey;
    final Optional<String> project;
    final Optional<String> location;
    final Optional<GoogleCredentials> credentials;

    protected ApiClient(Optional<String> apiKey, Optional<HttpOptions> customHttpOptions, Optional<ClientOptions> clientOptions) {
        Preconditions.checkNotNull(apiKey, (Object)"API Key cannot be null");
        Preconditions.checkNotNull(customHttpOptions, (Object)"customHttpOptions cannot be null");
        Preconditions.checkNotNull(clientOptions, (Object)"clientOptions cannot be null");
        try {
            this.apiKey = Optional.of(apiKey.orElse(ApiClient.getApiKeyFromEnv()));
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("API key must either be provided or set in the environment variable GOOGLE_API_KEY or GEMINI_API_KEY. If both are set, GOOGLE_API_KEY will be used.", e);
        }
        this.project = Optional.empty();
        this.location = Optional.empty();
        this.credentials = Optional.empty();
        this.vertexAI = false;
        this.clientOptions = clientOptions;
        this.httpOptions = ApiClient.defaultHttpOptions(false, this.location, this.apiKey);
        if (customHttpOptions.isPresent()) {
            this.httpOptions = this.mergeHttpOptions(customHttpOptions.get());
        }
        this.httpClient = this.createHttpClient(this.httpOptions.timeout(), clientOptions);
    }

    ApiClient(Optional<String> apiKey, Optional<String> project, Optional<String> location, Optional<GoogleCredentials> credentials, Optional<HttpOptions> customHttpOptions, Optional<ClientOptions> clientOptions) {
        boolean hasLocation;
        Preconditions.checkNotNull(apiKey, (Object)"API Key cannot be null");
        Preconditions.checkNotNull(project, (Object)"project cannot be null");
        Preconditions.checkNotNull(location, (Object)"location cannot be null");
        Preconditions.checkNotNull(credentials, (Object)"credentials cannot be null");
        Preconditions.checkNotNull(customHttpOptions, (Object)"customHttpOptions cannot be null");
        Preconditions.checkNotNull(clientOptions, (Object)"clientOptions cannot be null");
        ImmutableMap<String, String> environmentVariables = ApiClient.defaultEnvironmentVariables();
        String envApiKeyValue = ApiClient.getApiKeyFromEnv();
        String envProjectValue = (String)environmentVariables.get((Object)"project");
        String envLocationValue = (String)environmentVariables.get((Object)"location");
        String apiKeyValue = apiKey.orElse(envApiKeyValue);
        String projectValue = project.orElse(envProjectValue);
        String locationValue = location.orElse(envLocationValue);
        boolean hasEnvApiKeyValue = envApiKeyValue != null && !envApiKeyValue.isEmpty();
        boolean hasEnvProjectValue = envProjectValue != null && !envProjectValue.isEmpty();
        boolean hasEnvLocationValue = envLocationValue != null && !envLocationValue.isEmpty();
        boolean hasApiKey = apiKey != null && apiKey.isPresent();
        boolean hasCredentials = credentials != null && credentials.isPresent();
        boolean hasProject = project != null && project.isPresent();
        boolean bl = hasLocation = location != null && location.isPresent();
        if (hasProject && hasApiKey) {
            throw new IllegalArgumentException("For Vertex AI APIs, project and API key are mutually exclusive in the client initializer. Please provide only one of them.");
        }
        if (hasLocation && hasApiKey) {
            throw new IllegalArgumentException("For Vertex AI APIs, location and API key are mutually exclusive in the client initializer. Please provide only one of them.");
        }
        if (hasCredentials && hasApiKey) {
            throw new IllegalArgumentException("For Vertex AI APIs, API key cannot be set together with credentials. Please provide only one of them.");
        }
        if (hasCredentials && hasEnvApiKeyValue) {
            logger.warning("Warning: The user provided Google Cloud credentials will take precedence over the API key from the environment variable.");
            apiKeyValue = null;
        }
        if (hasApiKey && (hasEnvProjectValue || hasEnvLocationValue)) {
            logger.warning("Warning: The user provided Vertex AI API key will take precedence over the project/location from the environment variables.");
            projectValue = null;
            locationValue = null;
        } else if ((hasProject || hasLocation) && hasEnvApiKeyValue) {
            logger.warning("Warning: The user provided project/location will take precedence over the API key from the environment variable.");
            apiKeyValue = null;
        } else if ((hasEnvProjectValue || hasEnvLocationValue) && hasEnvApiKeyValue) {
            logger.warning("Warning: The project/location from the environment variables will take precedence over the API key from the environment variable.");
            apiKeyValue = null;
        }
        this.apiKey = Optional.ofNullable(apiKeyValue);
        this.project = Optional.ofNullable(projectValue);
        this.location = Optional.ofNullable(locationValue);
        if (!(this.project.isPresent() && this.location.isPresent() || this.apiKey.isPresent())) {
            throw new IllegalArgumentException("For Vertex AI APIs, either project/location or API key must be set.");
        }
        this.credentials = !this.project.isPresent() ? Optional.empty() : Optional.of(credentials.orElseGet(() -> this.defaultCredentials()));
        this.clientOptions = clientOptions;
        this.httpOptions = ApiClient.defaultHttpOptions(true, this.location, this.apiKey);
        if (customHttpOptions.isPresent()) {
            this.httpOptions = this.mergeHttpOptions(customHttpOptions.get());
        }
        this.vertexAI = true;
        this.httpClient = this.createHttpClient(this.httpOptions.timeout(), clientOptions);
    }

    private OkHttpClient createHttpClient(Optional<Integer> timeout, Optional<ClientOptions> clientOptions) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(Duration.ofMillis(0L));
        builder.readTimeout(Duration.ofMillis(0L));
        builder.writeTimeout(Duration.ofMillis(0L));
        timeout.ifPresent(connectTimeout -> builder.connectTimeout(Duration.ofMillis(connectTimeout.intValue())));
        clientOptions.ifPresent(options -> {
            Dispatcher dispatcher = new Dispatcher();
            options.maxConnections().ifPresent(arg_0 -> ((Dispatcher)dispatcher).setMaxRequests(arg_0));
            options.maxConnectionsPerHost().ifPresent(arg_0 -> ((Dispatcher)dispatcher).setMaxRequestsPerHost(arg_0));
            builder.dispatcher(dispatcher);
        });
        return builder.build();
    }

    protected Request buildRequest(String httpMethod, String path, String requestJson, Optional<HttpOptions> requestHttpOptions) {
        String apiVersion;
        HttpOptions mergedHttpOptions;
        String baseUrl;
        boolean queryBaseModel;
        String capitalizedHttpMethod = Ascii.toUpperCase((String)httpMethod);
        boolean bl = queryBaseModel = capitalizedHttpMethod.equals("GET") && path.startsWith("publishers/google/models");
        if (this.vertexAI() && !this.apiKey.isPresent() && !path.startsWith("projects/") && !queryBaseModel) {
            path = String.format("projects/%s/locations/%s/", this.project.get(), this.location.get()) + path;
        }
        if ((baseUrl = (mergedHttpOptions = this.mergeHttpOptions(requestHttpOptions.orElse(null))).baseUrl().orElseThrow(() -> new IllegalStateException("baseUrl is required."))).endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        String requestUrl = (apiVersion = mergedHttpOptions.apiVersion().orElseThrow(() -> new IllegalStateException("apiVersion is required."))).isEmpty() ? String.format("%s/%s", baseUrl, path) : String.format("%s/%s/%s", baseUrl, apiVersion, path);
        if (!VALID_HTTP_METHODS.contains((Object)capitalizedHttpMethod)) {
            throw new IllegalArgumentException("Unsupported HTTP method: " + capitalizedHttpMethod);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        RequestBody body = METHODS_WITH_BODY.contains((Object)capitalizedHttpMethod) ? RequestBody.create((String)requestJson, (MediaType)MediaType.parse((String)"application/json")) : null;
        if (mergedHttpOptions.extraBody().isPresent() && body != null) {
            try {
                Map requestBodyMap = (Map)objectMapper.readValue(requestJson, Map.class);
                this.mergeMaps(requestBodyMap, mergedHttpOptions.extraBody().get());
                requestJson = objectMapper.writeValueAsString((Object)requestBodyMap);
                body = RequestBody.create((String)requestJson, (MediaType)MediaType.parse((String)"application/json"));
            }
            catch (JsonProcessingException e) {
                logger.warning("Failed to merge extraBody into request body: " + e.getMessage());
                body = RequestBody.create((String)requestJson, (MediaType)MediaType.parse((String)"application/json"));
            }
        } else if (mergedHttpOptions.extraBody().isPresent()) {
            logger.warning("HttpOptions.extraBody is set, but the HTTP method does not support a request body. The extraBody will be ignored.");
        }
        Request.Builder requestBuilder = new Request.Builder().url(requestUrl).method(capitalizedHttpMethod, body);
        this.setHeaders(requestBuilder, mergedHttpOptions);
        return requestBuilder.build();
    }

    protected Request buildRequest(String httpMethod, String url, byte[] requestBytes, Optional<HttpOptions> requestHttpOptions) {
        HttpOptions mergedHttpOptions = this.mergeHttpOptions(requestHttpOptions.orElse(null));
        if (httpMethod.equalsIgnoreCase("POST")) {
            RequestBody body = RequestBody.create((byte[])requestBytes, (MediaType)MediaType.get((String)"application/octet-stream"));
            Request.Builder requestBuilder = new Request.Builder().url(url).post(body);
            this.setHeaders(requestBuilder, mergedHttpOptions);
            return requestBuilder.build();
        }
        throw new IllegalArgumentException("The request method with bytes is only supported for POST. Unsupported HTTP method: " + httpMethod);
    }

    private void setHeaders(Request.Builder request, HttpOptions requestHttpOptions) {
        for (Map.Entry<String, String> header : requestHttpOptions.headers().orElse((Map<String, String>)ImmutableMap.of()).entrySet()) {
            request.header(header.getKey(), header.getValue());
        }
        if (this.apiKey.isPresent()) {
            request.header("x-goog-api-key", this.apiKey.get());
        } else {
            GoogleCredentials cred = this.credentials.orElseThrow(() -> new IllegalStateException("credentials is required"));
            try {
                cred.refreshIfExpired();
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to refresh credentials.", e);
            }
            String accessToken = cred.getAccessToken().getTokenValue();
            request.header("Authorization", "Bearer " + accessToken);
            if (cred.getQuotaProjectId() != null) {
                request.header("x-goog-user-project", cred.getQuotaProjectId());
            }
        }
    }

    @CanIgnoreReturnValue
    public abstract ApiResponse request(String var1, String var2, String var3, Optional<HttpOptions> var4);

    public abstract ApiResponse request(String var1, String var2, byte[] var3, Optional<HttpOptions> var4);

    static String libraryVersion() {
        String libraryLabel = String.format("google-genai-sdk/%s", SDK_VERSION);
        String languageLabel = "gl-java/" + System.getProperty("java.version");
        return libraryLabel + " " + languageLabel;
    }

    public boolean vertexAI() {
        return this.vertexAI;
    }

    public @Nullable String project() {
        return this.project.orElse(null);
    }

    public @Nullable String location() {
        return this.location.orElse(null);
    }

    public @Nullable String apiKey() {
        return this.apiKey.orElse(null);
    }

    OkHttpClient httpClient() {
        return this.httpClient;
    }

    private void mergeMaps(Map<String, Object> target, Map<String, Object> source) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String key = entry.getKey();
            Object sourceValue = entry.getValue();
            if (target.containsKey(key)) {
                Object targetValue = target.get(key);
                if (targetValue instanceof Map && sourceValue instanceof Map) {
                    this.mergeMaps((Map)targetValue, (Map)sourceValue);
                    continue;
                }
                if (targetValue instanceof List && sourceValue instanceof List) {
                    target.put(key, sourceValue);
                    continue;
                }
                if (targetValue.getClass() != sourceValue.getClass()) {
                    logger.warning(String.format("Type mismatch for key '%s'. Original type: %s, new type: %s.  Overwriting with the new value.", key, targetValue.getClass().getName(), sourceValue.getClass().getName()));
                }
                target.put(key, sourceValue);
                continue;
            }
            target.put(key, sourceValue);
        }
    }

    private Optional<Map<String, String>> getTimeoutHeader(HttpOptions httpOptionsToApply) {
        if (httpOptionsToApply.timeout().isPresent()) {
            int timeoutInSeconds = (int)Math.ceil((double)httpOptionsToApply.timeout().get().intValue() / 1000.0);
            return Optional.of(ImmutableMap.of((Object)"X-Server-Timeout", (Object)Integer.toString(timeoutInSeconds)));
        }
        return Optional.empty();
    }

    HttpOptions mergeHttpOptions(HttpOptions httpOptionsToApply) {
        if (httpOptionsToApply == null) {
            return this.httpOptions;
        }
        HttpOptions.Builder mergedHttpOptionsBuilder = this.httpOptions.toBuilder();
        if (httpOptionsToApply.baseUrl().isPresent()) {
            mergedHttpOptionsBuilder.baseUrl(httpOptionsToApply.baseUrl().get());
        }
        if (httpOptionsToApply.apiVersion().isPresent()) {
            mergedHttpOptionsBuilder.apiVersion(httpOptionsToApply.apiVersion().get());
        }
        if (httpOptionsToApply.timeout().isPresent()) {
            mergedHttpOptionsBuilder.timeout(httpOptionsToApply.timeout().get());
        }
        if (httpOptionsToApply.headers().isPresent()) {
            Stream headersStream = Stream.concat(Stream.concat(this.httpOptions.headers().orElse((Map<String, String>)ImmutableMap.of()).entrySet().stream(), this.getTimeoutHeader(httpOptionsToApply).orElse((Map<String, String>)ImmutableMap.of()).entrySet().stream()), httpOptionsToApply.headers().orElse((Map<String, String>)ImmutableMap.of()).entrySet().stream());
            Map mergedHeaders = (Map)headersStream.collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, (val1, val2) -> val2));
            mergedHttpOptionsBuilder.headers(mergedHeaders);
        }
        if (httpOptionsToApply.extraBody().isPresent()) {
            mergedHttpOptionsBuilder.extraBody(httpOptionsToApply.extraBody().get());
        }
        return mergedHttpOptionsBuilder.build();
    }

    static HttpOptions defaultHttpOptions(boolean vertexAI, Optional<String> location, Optional<String> apiKey) {
        ImmutableMap.Builder defaultHeaders = ImmutableMap.builder();
        defaultHeaders.put((Object)"Content-Type", (Object)"application/json");
        defaultHeaders.put((Object)"user-agent", (Object)ApiClient.libraryVersion());
        defaultHeaders.put((Object)"x-goog-api-client", (Object)ApiClient.libraryVersion());
        HttpOptions.Builder defaultHttpOptionsBuilder = HttpOptions.builder().headers((Map<String, String>)defaultHeaders.build());
        ImmutableMap<String, String> defaultEnvironmentVariables = ApiClient.defaultEnvironmentVariables();
        if (vertexAI) {
            defaultHttpOptionsBuilder.apiVersion("v1beta1");
            String defaultBaseUrl = vertexBaseUrl.orElseGet(() -> (String)defaultEnvironmentVariables.get((Object)"vertexBaseUrl"));
            if (defaultBaseUrl != null) {
                defaultHttpOptionsBuilder.baseUrl(defaultBaseUrl);
            } else if (apiKey.isPresent() || location.get().equalsIgnoreCase("global")) {
                defaultHttpOptionsBuilder.baseUrl("https://aiplatform.googleapis.com");
            } else {
                defaultHttpOptionsBuilder.baseUrl(String.format("https://%s-aiplatform.googleapis.com", location.get()));
            }
        } else {
            defaultHttpOptionsBuilder.apiVersion("v1beta");
            String defaultBaseUrl = geminiBaseUrl.orElseGet(() -> (String)defaultEnvironmentVariables.get((Object)"geminiBaseUrl"));
            if (defaultBaseUrl != null) {
                defaultHttpOptionsBuilder.baseUrl(defaultBaseUrl);
            } else {
                defaultHttpOptionsBuilder.baseUrl("https://generativelanguage.googleapis.com");
            }
        }
        return defaultHttpOptionsBuilder.build();
    }

    GoogleCredentials defaultCredentials() {
        try {
            return GoogleCredentials.getApplicationDefault().createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to get application default credentials, please explicitly provide credentials.", e);
        }
    }

    static String getApiKeyFromEnv() {
        String geminiApiKey;
        ImmutableMap<String, String> environmentVariables = ApiClient.defaultEnvironmentVariables();
        String googleApiKey = (String)environmentVariables.get((Object)"googleApiKey");
        if (googleApiKey != null && googleApiKey.isEmpty()) {
            googleApiKey = null;
        }
        if ((geminiApiKey = (String)environmentVariables.get((Object)"geminiApiKey")) != null && geminiApiKey.isEmpty()) {
            geminiApiKey = null;
        }
        if (googleApiKey != null && geminiApiKey != null) {
            logger.warning("Both GOOGLE_API_KEY and GEMINI_API_KEY are set. Using GOOGLE_API_KEY.");
        }
        if (googleApiKey != null) {
            return googleApiKey;
        }
        return geminiApiKey;
    }

    static ImmutableMap<String, String> defaultEnvironmentVariables() {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        String value = System.getenv("GOOGLE_API_KEY");
        if (value != null && !value.isEmpty()) {
            mapBuilder.put((Object)"googleApiKey", (Object)value);
        }
        if ((value = System.getenv("GEMINI_API_KEY")) != null && !value.isEmpty()) {
            mapBuilder.put((Object)"geminiApiKey", (Object)value);
        }
        if ((value = System.getenv("GOOGLE_CLOUD_PROJECT")) != null && !value.isEmpty()) {
            mapBuilder.put((Object)"project", (Object)value);
        }
        if ((value = System.getenv("GOOGLE_CLOUD_LOCATION")) != null && !value.isEmpty()) {
            mapBuilder.put((Object)"location", (Object)value);
        }
        if ((value = System.getenv("GOOGLE_GENAI_USE_VERTEXAI")) != null && !value.isEmpty()) {
            mapBuilder.put((Object)"vertexAI", (Object)value);
        }
        if ((value = System.getenv("GOOGLE_GEMINI_BASE_URL")) != null && !value.isEmpty()) {
            mapBuilder.put((Object)"geminiBaseUrl", (Object)value);
        }
        if ((value = System.getenv("GOOGLE_VERTEX_BASE_URL")) != null && !value.isEmpty()) {
            mapBuilder.put((Object)"vertexBaseUrl", (Object)value);
        }
        return mapBuilder.buildOrThrow();
    }

    static void setDefaultBaseUrls(Optional<String> geminiBaseUrl, Optional<String> vertexBaseUrl) {
        ApiClient.geminiBaseUrl = geminiBaseUrl;
        ApiClient.vertexBaseUrl = vertexBaseUrl;
    }
}

