/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AdapterSize;
import com.google.genai.types.AutoValue_CreateTuningJobConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.TuningValidationDataset;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class CreateTuningJobConfig
extends JsonSerializable {
    @JsonProperty(value="httpOptions")
    public abstract Optional<HttpOptions> httpOptions();

    @JsonProperty(value="validationDataset")
    public abstract Optional<TuningValidationDataset> validationDataset();

    @JsonProperty(value="tunedModelDisplayName")
    public abstract Optional<String> tunedModelDisplayName();

    @JsonProperty(value="description")
    public abstract Optional<String> description();

    @JsonProperty(value="epochCount")
    public abstract Optional<Integer> epochCount();

    @JsonProperty(value="learningRateMultiplier")
    public abstract Optional<Float> learningRateMultiplier();

    @JsonProperty(value="exportLastCheckpointOnly")
    public abstract Optional<Boolean> exportLastCheckpointOnly();

    @JsonProperty(value="preTunedModelCheckpointId")
    public abstract Optional<String> preTunedModelCheckpointId();

    @JsonProperty(value="adapterSize")
    public abstract Optional<AdapterSize> adapterSize();

    @JsonProperty(value="batchSize")
    public abstract Optional<Integer> batchSize();

    @JsonProperty(value="learningRate")
    public abstract Optional<Float> learningRate();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_CreateTuningJobConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static CreateTuningJobConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, CreateTuningJobConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_CreateTuningJobConfig.Builder();
        }

        @JsonProperty(value="httpOptions")
        public abstract Builder httpOptions(HttpOptions var1);

        public Builder httpOptions(HttpOptions.Builder httpOptionsBuilder) {
            return this.httpOptions(httpOptionsBuilder.build());
        }

        @JsonProperty(value="validationDataset")
        public abstract Builder validationDataset(TuningValidationDataset var1);

        public Builder validationDataset(TuningValidationDataset.Builder validationDatasetBuilder) {
            return this.validationDataset(validationDatasetBuilder.build());
        }

        @JsonProperty(value="tunedModelDisplayName")
        public abstract Builder tunedModelDisplayName(String var1);

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @JsonProperty(value="epochCount")
        public abstract Builder epochCount(Integer var1);

        @JsonProperty(value="learningRateMultiplier")
        public abstract Builder learningRateMultiplier(Float var1);

        @JsonProperty(value="exportLastCheckpointOnly")
        public abstract Builder exportLastCheckpointOnly(boolean var1);

        @JsonProperty(value="preTunedModelCheckpointId")
        public abstract Builder preTunedModelCheckpointId(String var1);

        @JsonProperty(value="adapterSize")
        public abstract Builder adapterSize(AdapterSize var1);

        @CanIgnoreReturnValue
        public Builder adapterSize(AdapterSize.Known knownType) {
            return this.adapterSize(new AdapterSize(knownType));
        }

        @CanIgnoreReturnValue
        public Builder adapterSize(String adapterSize) {
            return this.adapterSize(new AdapterSize(adapterSize));
        }

        @JsonProperty(value="batchSize")
        public abstract Builder batchSize(Integer var1);

        @JsonProperty(value="learningRate")
        public abstract Builder learningRate(Float var1);

        public abstract CreateTuningJobConfig build();
    }
}

