/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.JsonSerializable;
import com.google.genai.Transformers;
import com.google.genai.errors.GenAiIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.jspecify.annotations.Nullable;

final class Common {
    private Common() {
    }

    static void setValueByPath(ObjectNode jsonObject, String[] path, Object value) {
        if (path == null || path.length == 0) {
            throw new IllegalArgumentException("Path cannot be empty.");
        }
        if (jsonObject == null) {
            throw new IllegalArgumentException("JsonObject cannot be null.");
        }
        ObjectNode currentObject = jsonObject;
        for (int i = 0; i < path.length - 1; ++i) {
            String keyName;
            String key = path[i];
            if (key.endsWith("[]")) {
                keyName = key.substring(0, key.length() - 2);
                if (!currentObject.has(keyName)) {
                    currentObject.putArray(keyName);
                }
                ArrayNode arrayNode = (ArrayNode)currentObject.get(keyName);
                if (value instanceof List) {
                    int j;
                    List listValue = (List)value;
                    if (arrayNode.size() != listValue.size()) {
                        arrayNode.removeAll();
                        for (j = 0; j < listValue.size(); ++j) {
                            arrayNode.addObject();
                        }
                    }
                    for (j = 0; j < arrayNode.size(); ++j) {
                        Common.setValueByPath((ObjectNode)arrayNode.get(j), Arrays.copyOfRange(path, i + 1, path.length), listValue.get(j));
                    }
                } else {
                    if (arrayNode.size() == 0) {
                        arrayNode.addObject();
                    }
                    for (int j = 0; j < arrayNode.size(); ++j) {
                        Common.setValueByPath((ObjectNode)arrayNode.get(j), Arrays.copyOfRange(path, i + 1, path.length), value);
                    }
                }
                return;
            }
            if (key.endsWith("[0]")) {
                keyName = key.substring(0, key.length() - 3);
                if (!currentObject.has(keyName)) {
                    currentObject.putArray(keyName).addObject();
                }
                currentObject = (ObjectNode)((ArrayNode)currentObject.get(keyName)).get(0);
                continue;
            }
            if (!currentObject.has(key)) {
                currentObject.putObject(key);
            }
            currentObject = (ObjectNode)currentObject.get(key);
        }
        String keyToSet = path[path.length - 1];
        JsonNode valueNode = JsonSerializable.toJsonNode(value);
        Transformers.updateJsonNode(currentObject, keyToSet, valueNode);
    }

    static @Nullable Object getValueByPath(JsonNode object, String[] keys) {
        if (object == null || keys == null) {
            return null;
        }
        if (keys.length == 1 && keys[0].equals("_self")) {
            return object;
        }
        JsonNode currentObject = object;
        for (int i = 0; i < keys.length; ++i) {
            String keyName;
            String key = keys[i];
            if (currentObject == null) {
                return null;
            }
            if (key.endsWith("[]")) {
                keyName = key.substring(0, key.length() - 2);
                if (currentObject.isObject() && ((ObjectNode)currentObject).has(keyName) && ((ObjectNode)currentObject).get(keyName).isArray()) {
                    ArrayNode arrayNode = (ArrayNode)((ObjectNode)currentObject).get(keyName);
                    if (keys.length - 1 == i) {
                        return arrayNode;
                    }
                    ArrayNode result = JsonSerializable.objectMapper.createArrayNode();
                    for (JsonNode element : arrayNode) {
                        JsonNode node = (JsonNode)Common.getValueByPath(element, Arrays.copyOfRange(keys, i + 1, keys.length));
                        if (node == null) continue;
                        result.add(node);
                    }
                    return result;
                }
                return null;
            }
            if (key.endsWith("[0]")) {
                keyName = key.substring(0, key.length() - 3);
                if (currentObject.isObject() && ((ObjectNode)currentObject).has(keyName) && ((ObjectNode)currentObject).get(keyName).isArray() && ((ArrayNode)((ObjectNode)currentObject).get(keyName)).size() > 0) {
                    currentObject = ((ArrayNode)((ObjectNode)currentObject).get(keyName)).get(0);
                    continue;
                }
                return null;
            }
            if (currentObject.isObject() && ((ObjectNode)currentObject).has(key)) {
                currentObject = ((ObjectNode)currentObject).get(key);
                continue;
            }
            return null;
        }
        return currentObject;
    }

    static String formatMap(String template, JsonNode data) {
        if (data == null) {
            return template;
        }
        Iterator fields = data.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            String key = (String)field.getKey();
            String placeholder = "{" + key + "}";
            if (!template.contains(placeholder)) continue;
            template = template.replace(placeholder, data.get(key).asText());
        }
        return template;
    }

    static boolean isZero(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Number) {
            Number num = (Number)obj;
            return num.doubleValue() == 0.0;
        }
        if (obj instanceof Character) {
            Character ch = (Character)obj;
            return ch.charValue() == '\u0000';
        }
        if (obj instanceof Boolean) {
            Boolean bool = (Boolean)obj;
            return bool == false;
        }
        return false;
    }

    public static String urlEncode(ObjectNode paramsNode) {
        if (paramsNode == null || paramsNode.size() == 0) {
            return "";
        }
        StringJoiner queryBuilder = new StringJoiner("&");
        String utf8 = StandardCharsets.UTF_8.name();
        try {
            Iterator fields = paramsNode.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                String encodedKey = URLEncoder.encode((String)entry.getKey(), utf8);
                JsonNode valueNode = (JsonNode)entry.getValue();
                if (valueNode.isNull()) {
                    queryBuilder.add(encodedKey + "=");
                    continue;
                }
                String encodedValue = URLEncoder.encode(valueNode.asText(""), utf8).replace("*", "%2A");
                queryBuilder.add(encodedKey + "=" + encodedValue);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new GenAiIOException("UTF-8 encoding not supported", e);
        }
        return queryBuilder.toString();
    }

    static String snakeToCamel(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        boolean capitalizeNext = false;
        for (char c : str.toCharArray()) {
            if (c == '_') {
                capitalizeNext = true;
                continue;
            }
            sb.append(capitalizeNext ? Character.toUpperCase(c) : c);
            capitalizeNext = false;
        }
        return sb.toString();
    }
}

