/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_GenerateVideosConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.Image;
import com.google.genai.types.VideoCompressionQuality;
import com.google.genai.types.VideoGenerationReferenceImage;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GenerateVideosConfig
extends JsonSerializable {
    @JsonProperty(value="httpOptions")
    public abstract Optional<HttpOptions> httpOptions();

    @JsonProperty(value="numberOfVideos")
    public abstract Optional<Integer> numberOfVideos();

    @JsonProperty(value="outputGcsUri")
    public abstract Optional<String> outputGcsUri();

    @JsonProperty(value="fps")
    public abstract Optional<Integer> fps();

    @JsonProperty(value="durationSeconds")
    public abstract Optional<Integer> durationSeconds();

    @JsonProperty(value="seed")
    public abstract Optional<Integer> seed();

    @JsonProperty(value="aspectRatio")
    public abstract Optional<String> aspectRatio();

    @JsonProperty(value="resolution")
    public abstract Optional<String> resolution();

    @JsonProperty(value="personGeneration")
    public abstract Optional<String> personGeneration();

    @JsonProperty(value="pubsubTopic")
    public abstract Optional<String> pubsubTopic();

    @JsonProperty(value="negativePrompt")
    public abstract Optional<String> negativePrompt();

    @JsonProperty(value="enhancePrompt")
    public abstract Optional<Boolean> enhancePrompt();

    @JsonProperty(value="generateAudio")
    public abstract Optional<Boolean> generateAudio();

    @JsonProperty(value="lastFrame")
    public abstract Optional<Image> lastFrame();

    @JsonProperty(value="referenceImages")
    public abstract Optional<List<VideoGenerationReferenceImage>> referenceImages();

    @JsonProperty(value="compressionQuality")
    public abstract Optional<VideoCompressionQuality> compressionQuality();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_GenerateVideosConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static GenerateVideosConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, GenerateVideosConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_GenerateVideosConfig.Builder();
        }

        @JsonProperty(value="httpOptions")
        public abstract Builder httpOptions(HttpOptions var1);

        public Builder httpOptions(HttpOptions.Builder httpOptionsBuilder) {
            return this.httpOptions(httpOptionsBuilder.build());
        }

        @JsonProperty(value="numberOfVideos")
        public abstract Builder numberOfVideos(Integer var1);

        @JsonProperty(value="outputGcsUri")
        public abstract Builder outputGcsUri(String var1);

        @JsonProperty(value="fps")
        public abstract Builder fps(Integer var1);

        @JsonProperty(value="durationSeconds")
        public abstract Builder durationSeconds(Integer var1);

        @JsonProperty(value="seed")
        public abstract Builder seed(Integer var1);

        @JsonProperty(value="aspectRatio")
        public abstract Builder aspectRatio(String var1);

        @JsonProperty(value="resolution")
        public abstract Builder resolution(String var1);

        @JsonProperty(value="personGeneration")
        public abstract Builder personGeneration(String var1);

        @JsonProperty(value="pubsubTopic")
        public abstract Builder pubsubTopic(String var1);

        @JsonProperty(value="negativePrompt")
        public abstract Builder negativePrompt(String var1);

        @JsonProperty(value="enhancePrompt")
        public abstract Builder enhancePrompt(boolean var1);

        @JsonProperty(value="generateAudio")
        public abstract Builder generateAudio(boolean var1);

        @JsonProperty(value="lastFrame")
        public abstract Builder lastFrame(Image var1);

        public Builder lastFrame(Image.Builder lastFrameBuilder) {
            return this.lastFrame(lastFrameBuilder.build());
        }

        @JsonProperty(value="referenceImages")
        public abstract Builder referenceImages(List<VideoGenerationReferenceImage> var1);

        public Builder referenceImages(VideoGenerationReferenceImage ... referenceImages) {
            return this.referenceImages(Arrays.asList(referenceImages));
        }

        public Builder referenceImages(VideoGenerationReferenceImage.Builder ... referenceImagesBuilders) {
            return this.referenceImages((List)Arrays.asList(referenceImagesBuilders).stream().map(VideoGenerationReferenceImage.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @JsonProperty(value="compressionQuality")
        public abstract Builder compressionQuality(VideoCompressionQuality var1);

        @CanIgnoreReturnValue
        public Builder compressionQuality(VideoCompressionQuality.Known knownType) {
            return this.compressionQuality(new VideoCompressionQuality(knownType));
        }

        @CanIgnoreReturnValue
        public Builder compressionQuality(String compressionQuality) {
            return this.compressionQuality(new VideoCompressionQuality(compressionQuality));
        }

        public abstract GenerateVideosConfig build();
    }
}

